/*
 * Copyright (c) 2025 Oracle and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.helidon.webclient.context;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.common.config.ConfigBuilderSupport;
import io.helidon.common.context.http.ContextRecordConfig;

/**
 * Configuration of WebClient transport level propagation of context values.
 *
 * @see #builder()
 * @see #create()
 */
@Generated(value = "io.helidon.builder.codegen.BuilderCodegen", trigger = "io.helidon.webclient.context.WebClientContextConfigBlueprint")
public interface WebClientContextConfig extends WebClientContextConfigBlueprint, Prototype.Api {

    /**
     * Create a new fluent API builder to customize configuration.
     *
     * @return a new builder
     */
    static WebClientContextConfig.Builder builder() {
        return new WebClientContextConfig.Builder();
    }

    /**
     * Create a new fluent API builder from an existing instance.
     *
     * @param instance an existing instance used as a base for the builder
     * @return a builder based on an instance
     */
    static WebClientContextConfig.Builder builder(WebClientContextConfig instance) {
        return WebClientContextConfig.builder().from(instance);
    }

    /**
     * Create a new instance from configuration.
     *
     * @param config used to configure the new instance
     * @return a new instance configured from configuration
     */
    static WebClientContextConfig create(Config config) {
        return WebClientContextConfig.builder().config(config).buildPrototype();
    }

    /**
     * Create a new instance with default values.
     *
     * @return a new instance
     */
    static WebClientContextConfig create() {
        return WebClientContextConfig.builder().buildPrototype();
    }

    /**
     * Fluent API builder base for {@link WebClientContextService}.
     *
     * @param <BUILDER> type of the builder extending this abstract builder
     * @param <PROTOTYPE> type of the prototype interface that would be built by {@link #buildPrototype()}
     */
    abstract class BuilderBase<BUILDER extends WebClientContextConfig.BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends WebClientContextConfig> implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {

        private final List<ContextRecordConfig> records = new ArrayList<>();
        private boolean isRecordsMutated;
        private Config config;
        private String name = "context";

        /**
         * Protected to support extensibility.
         */
        protected BuilderBase() {
        }

        /**
         * Update this builder from an existing prototype instance. This method disables automatic service discovery.
         *
         * @param prototype existing prototype to update this builder from
         * @return updated builder instance
         */
        public BUILDER from(WebClientContextConfig prototype) {
            name(prototype.name());
            if (!isRecordsMutated) {
                records.clear();
            }
            addRecords(prototype.records());
            return self();
        }

        /**
         * Update this builder from an existing prototype builder instance.
         *
         * @param builder existing builder prototype to update this builder from
         * @return updated builder instance
         */
        public BUILDER from(WebClientContextConfig.BuilderBase<?, ?> builder) {
            name(builder.name());
            if (isRecordsMutated) {
                if (builder.isRecordsMutated) {
                    addRecords(builder.records);
                }
            } else {
                records.clear();
                addRecords(builder.records);
            }
            return self();
        }

        /**
         * Update builder from configuration (node of this type).
         * If a value is present in configuration, it would override currently configured values.
         *
         * @param config configuration instance used to obtain values to update this builder
         * @return updated builder instance
         */
        @Override
        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("records").mapList(io.helidon.common.context.http.ContextRecordConfig::create).ifPresent(this::records);
            return self();
        }

        /**
         * Name of this instance.
         *
         * @param name instance name
         * @return updated builder instance
         * @see #name()
         */
        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return self();
        }

        /**
         * List of propagation records.
         *
         * @param records records configuration
         * @return updated builder instance
         * @see #records()
         */
        public BUILDER records(List<? extends ContextRecordConfig> records) {
            Objects.requireNonNull(records);
            isRecordsMutated = true;
            this.records.clear();
            this.records.addAll(records);
            return self();
        }

        /**
         * List of propagation records.
         *
         * @param records records configuration
         * @return updated builder instance
         * @see #records()
         */
        public BUILDER addRecords(List<? extends ContextRecordConfig> records) {
            Objects.requireNonNull(records);
            isRecordsMutated = true;
            this.records.addAll(records);
            return self();
        }

        /**
         * List of propagation records.
         *
         * @param record records configuration
         * @return updated builder instance
         * @see #records()
         */
        public BUILDER addRecord(ContextRecordConfig record) {
            Objects.requireNonNull(record);
            this.records.add(record);
            isRecordsMutated = true;
            return self();
        }

        /**
         * List of propagation records.
         *
         * @param consumer records configuration
         * @return updated builder instance
         * @see #records()
         */
        public BUILDER addRecord(Consumer<ContextRecordConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            var builder = ContextRecordConfig.builder();
            consumer.accept(builder);
            this.records.add(builder.build());
            return self();
        }

        /**
         * Name of this instance.
         *
         * @return the name
         */
        public String name() {
            return name;
        }

        /**
         * List of propagation records.
         *
         * @return the records
         */
        public List<ContextRecordConfig> records() {
            return records;
        }

        /**
         * If this instance was configured, this would be the config instance used.
         *
         * @return config node used to configure this builder, or empty if not configured
         */
        public Optional<Config> config() {
            return Optional.ofNullable(config);
        }

        @Override
        public String toString() {
            return "WebClientContextConfigBuilder{"
                    + "name=" + name + ","
                    + "records=" + records
                    + "}";
        }

        /**
         * Handles providers and decorators.
         */
        protected void preBuildPrototype() {
        }

        /**
         * Validates required properties.
         */
        protected void validatePrototype() {
        }

        /**
         * Generated implementation of the prototype, can be extended by descendant prototype implementations.
         */
        protected static class WebClientContextConfigImpl implements WebClientContextConfig, Supplier<WebClientContextService> {

            private final List<ContextRecordConfig> records;
            private final String name;

            /**
             * Create an instance providing a builder.
             *
             * @param builder extending builder base of this prototype
             */
            protected WebClientContextConfigImpl(WebClientContextConfig.BuilderBase<?, ?> builder) {
                this.name = builder.name();
                this.records = List.copyOf(builder.records());
            }

            @Override
            public WebClientContextService build() {
                return WebClientContextService.create(this);
            }

            @Override
            public WebClientContextService get() {
                return build();
            }

            @Override
            public String name() {
                return name;
            }

            @Override
            public List<ContextRecordConfig> records() {
                return records;
            }

            @Override
            public String toString() {
                return "WebClientContextConfig{"
                        + "name=" + name + ","
                        + "records=" + records
                        + "}";
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof WebClientContextConfig other)) {
                    return false;
                }
                return Objects.equals(name, other.name())
                    && Objects.equals(records, other.records());
            }

            @Override
            public int hashCode() {
                return Objects.hash(name, records);
            }

        }

    }

    /**
     * Fluent API builder for {@link WebClientContextService}.
     */
    class Builder extends WebClientContextConfig.BuilderBase<WebClientContextConfig.Builder, WebClientContextConfig> implements io.helidon.common.Builder<WebClientContextConfig.Builder, WebClientContextService> {

        private Builder() {
        }

        @Override
        public WebClientContextConfig buildPrototype() {
            preBuildPrototype();
            validatePrototype();
            return new WebClientContextConfigImpl(this);
        }

        @Override
        public WebClientContextService build() {
            return WebClientContextService.create(this.buildPrototype());
        }

    }

}
