/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.context.propagation;

import io.helidon.common.context.Context;
import io.helidon.webclient.WebClientRequestHeaders;
import io.helidon.webclient.context.propagation.PropagationRecord;
import java.util.Optional;

class StringRecord
implements PropagationRecord {
    private final String classifier;
    private final String headerName;
    private final Optional<String> defaultValue;

    StringRecord(String classifier, String headerName, String defaultValue) {
        this.classifier = classifier;
        this.headerName = headerName;
        this.defaultValue = Optional.ofNullable(defaultValue);
    }

    @Override
    public void apply(Context context, WebClientRequestHeaders headers) {
        context.get((Object)this.classifier, String.class).or(() -> this.defaultValue).ifPresent(it -> headers.put(this.headerName, new String[]{it}));
    }

    public String toString() {
        return this.classifier + " -> " + this.headerName + " (String)";
    }
}

