/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.context.propagation;

import io.helidon.common.reactive.Single;
import io.helidon.config.Config;
import io.helidon.config.metadata.Configured;
import io.helidon.webclient.WebClientServiceRequest;
import io.helidon.webclient.context.propagation.PropagationRecord;
import io.helidon.webclient.spi.WebClientService;
import java.util.LinkedList;
import java.util.List;

public class WebClientContextPropagation
implements WebClientService {
    private final List<PropagationRecord> propagations;

    private WebClientContextPropagation(Builder builder) {
        this.propagations = List.copyOf(builder.propagations);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static WebClientContextPropagation create(Config config) {
        return WebClientContextPropagation.builder().config(config).build();
    }

    public Single<WebClientServiceRequest> request(WebClientServiceRequest request) {
        for (PropagationRecord propagation : this.propagations) {
            propagation.apply(request.context(), request.headers());
        }
        return Single.just((Object)request);
    }

    @Configured(prefix="context", provides={WebClientService.class}, description="Propagation of context data across network")
    public static class Builder
    implements io.helidon.common.Builder<WebClientContextPropagation> {
        private final List<PropagationRecord> propagations = new LinkedList<PropagationRecord>();

        public WebClientContextPropagation build() {
            return new WebClientContextPropagation(this);
        }

        public Builder config(Config config) {
            config.get("records").asList(Config.class).ifPresent(it -> it.forEach(recordConfig -> this.addRecord(PropagationRecord.builder().config((Config)recordConfig).build())));
            return this;
        }

        public Builder addRecord(PropagationRecord record) {
            this.propagations.add(record);
            return this;
        }
    }
}

