/*
 * Copyright (c) 2025 Oracle and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.helidon.webclient.api;

import java.util.List;
import java.util.Set;

import io.helidon.common.Generated;
import io.helidon.common.GenericType;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.ResolvedType;
import io.helidon.common.types.TypeName;
import io.helidon.service.registry.Dependency;
import io.helidon.service.registry.DependencyCardinality;
import io.helidon.service.registry.DependencyContext;
import io.helidon.service.registry.InterceptionMetadata;
import io.helidon.service.registry.Qualifier;
import io.helidon.service.registry.Service;
import io.helidon.service.registry.ServiceDescriptor;

/**
 * Service descriptor for {@link io.helidon.webclient.api.DefaultErrorHandling}.
 *
 * @param <T> type of the service, for extensibility
 */
@Generated(value = "io.helidon.service.codegen.ServiceExtension", trigger = "io.helidon.webclient.api.DefaultErrorHandling")
public class DefaultErrorHandling__ServiceDescriptor<T extends io.helidon.webclient.api.DefaultErrorHandling> implements ServiceDescriptor<T> {

    /**
     * Global singleton instance for this descriptor.
     */
    public static final DefaultErrorHandling__ServiceDescriptor<DefaultErrorHandling> INSTANCE = new DefaultErrorHandling__ServiceDescriptor<>();
    private static final System.Logger LOGGER = System.getLogger("io.helidon.webclient.api.DefaultErrorHandling");
    private static final TypeName TYPE_0 = TypeName.create("java.util.List<io.helidon.webclient.api.RestClient.ErrorHandler>");
    private static final GenericType<?> GTYPE_0 = new GenericType<List<RestClient.ErrorHandler>>() {};
    private static final TypeName TYPE_1 = TypeName.create("io.helidon.webclient.api.RestClient.ErrorHandler");
    private static final GenericType<?> GTYPE_1 = new GenericType<RestClient.ErrorHandler>() {};
    private static final TypeName SERVICE_TYPE = TypeName.create("io.helidon.webclient.api.DefaultErrorHandling");
    private static final TypeName TYPE = TypeName.create("io.helidon.webclient.api.DefaultErrorHandling__ServiceDescriptor");
    private static final Set<ResolvedType> CONTRACTS = Set.of(ResolvedType.create("io.helidon.webclient.api.RestClient.ErrorHandling"));
    private static final Set<Qualifier> QUALIFIERS = Set.of();
    /**
     * Injection point dependency for DefaultErrorHandling(List errorHandlers), parameter errorHandlers.
     */
    public static final Dependency DEP_0 = Dependency.builder()
            .typeName(TYPE_0)
            .name("errorHandlers")
            .service(SERVICE_TYPE)
            .descriptor(TYPE)
            .descriptorConstant("DEP_0")
            .contract(TYPE_1)
            .contractType(GTYPE_1)
            .cardinality(DependencyCardinality.LIST)
            .build();
    private static final List<Dependency> DEPENDENCIES = List.of(DEP_0);
    static final List<Annotation> ANNOTATIONS = List.of(Annotation.builder()
            .typeName(TypeName.create("io.helidon.service.registry.Service.Singleton"))
            .addMetaAnnotation(Annotation.create(TypeName.create("io.helidon.service.registry.Service.Scope")))
            .build()
    );

    /**
     * Constructor with no side effects
     */
    protected DefaultErrorHandling__ServiceDescriptor() {
    }

    @Override
    public TypeName serviceType() {
        return SERVICE_TYPE;
    }

    @Override
    public TypeName descriptorType() {
        return TYPE;
    }

    @Override
    public TypeName scope() {
        return Service.Singleton.TYPE;
    }

    @Override
    public Set<ResolvedType> contracts() {
        return CONTRACTS;
    }

    @Override
    public List<Dependency> dependencies() {
        return DEPENDENCIES;
    }

    @Override
    @SuppressWarnings("unchecked")
    public DefaultErrorHandling instantiate(DependencyContext ctx__helidonInject, InterceptionMetadata interceptMeta__helidonInject) {
        List<RestClient.ErrorHandler> errorHandlers = ctx__helidonInject.dependency(DEP_0);
        
        if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                LOGGER.log(System.Logger.Level.DEBUG, "instantiate (weight = " + weight() + ", run level = " + runLevel().orElse(null) + ")");
        }
        return new DefaultErrorHandling(errorHandlers);
    }

}
