/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.api;

import io.helidon.common.LazyValue;
import io.helidon.webclient.api.DnsAddressLookup;

final class DefaultAddressLookupFinder {
    private static final System.Logger LOGGER = System.getLogger(DefaultAddressLookupFinder.class.getName());
    private static final LazyValue<Boolean> IPV4_PREFERRED = LazyValue.create(() -> Boolean.getBoolean("java.net.preferIPv4Stack"));
    private static final LazyValue<Boolean> IPV6_PREFERRED = LazyValue.create(() -> Boolean.getBoolean("java.net.preferIPv6Addresses"));
    private static final LazyValue<DnsAddressLookup> DEFAULT_IP_VERSION = LazyValue.create(() -> {
        if (((Boolean)IPV4_PREFERRED.get()).booleanValue() || !((Boolean)IPV6_PREFERRED.get()).booleanValue()) {
            if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                LOGGER.log(System.Logger.Level.DEBUG, "Preferring IPv4 over IPv6 address resolution");
            }
            return DnsAddressLookup.IPV4_PREFERRED;
        }
        if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
            LOGGER.log(System.Logger.Level.DEBUG, "Preferring IPv6 over IPv4 address resolution");
        }
        return DnsAddressLookup.IPV6_PREFERRED;
    });

    private DefaultAddressLookupFinder() {
        throw new IllegalStateException("This class should not be instantiated");
    }

    static DnsAddressLookup defaultDnsAddressLookup() {
        return (DnsAddressLookup)((Object)DEFAULT_IP_VERSION.get());
    }
}

