/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.api;

import io.helidon.webclient.spi.ProtocolConfig;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

class ProtocolConfigs {
    private final List<ProtocolConfig> protocolConfigs;

    private ProtocolConfigs(List<ProtocolConfig> protocolConfigs) {
        this.protocolConfigs = List.copyOf(protocolConfigs);
    }

    public static ProtocolConfigs create(List<ProtocolConfig> protocolConfigs) {
        Objects.requireNonNull(protocolConfigs);
        return new ProtocolConfigs(protocolConfigs);
    }

    public <T extends ProtocolConfig> T config(String protocolType, Class<T> protocolConfigType, Supplier<T> defaultConfigSupplier) {
        Objects.requireNonNull(protocolType);
        Objects.requireNonNull(protocolConfigType);
        return (T)this.protocolConfigs.stream().filter(it -> protocolType.equals(it.type())).filter(it -> protocolConfigType.isAssignableFrom(it.getClass())).map(protocolConfigType::cast).findFirst().orElseGet(defaultConfigSupplier);
    }
}

