/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.api;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.LazyValue;
import io.helidon.common.configurable.LruCache;
import io.helidon.common.tls.Tls;
import io.helidon.common.uri.UriQueryWriteable;
import io.helidon.http.Method;
import io.helidon.inject.configdriven.api.ConfigDriven;
import io.helidon.webclient.api.ClientUri;
import io.helidon.webclient.api.HttpClientRequest;
import io.helidon.webclient.api.ProtocolConfigs;
import io.helidon.webclient.api.Proxy;
import io.helidon.webclient.api.WebClient;
import io.helidon.webclient.api.WebClientConfig;
import io.helidon.webclient.api.WebClientConfigBlueprint;
import io.helidon.webclient.api.WebClientCookieManager;
import io.helidon.webclient.spi.ClientProtocolProvider;
import io.helidon.webclient.spi.HttpClientSpi;
import io.helidon.webclient.spi.HttpClientSpiProvider;
import io.helidon.webclient.spi.Protocol;
import io.helidon.webclient.spi.ProtocolConfig;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@ConfigDriven(value=WebClientConfigBlueprint.class)
class LoomClient
implements WebClient {
    static final LazyValue<ExecutorService> EXECUTOR = LazyValue.create(() -> Executors.newThreadPerTaskExecutor(Thread.ofVirtual().name("helidon-client-", 0L).factory()));
    private static final List<HttpClientSpiProvider> PROVIDERS = HelidonServiceLoader.create(ServiceLoader.load(HttpClientSpiProvider.class)).asList();
    private static final Map<String, HttpClientSpiProvider> HTTP_PROVIDERS_BY_PROTOCOL;
    private final WebClientConfig config;
    private final Map<String, ProtocolSpi> clientSpiByProtocol;
    private final Map<String, Object> clientsByProtocol = new ConcurrentHashMap<String, Object>();
    private final List<ProtocolSpi> protocols;
    private final List<ProtocolSpi> tcpProtocols;
    private final ProtocolConfigs protocolConfigs;
    private final List<String> tcpProtocolIds;
    private final WebClientCookieManager cookieManager;
    private final LruCache<EndpointKey, HttpClientSpi> clientSpiLruCache = LruCache.create();

    @Inject
    protected LoomClient(WebClientConfig config) {
        ArrayList<Object> providers;
        this.config = config;
        this.protocolConfigs = ProtocolConfigs.create(config.protocolConfigs());
        this.cookieManager = config.cookieManager().orElseGet(() -> WebClientCookieManager.builder().build());
        List<String> protocolPreference = config.protocolPreference();
        if (protocolPreference.isEmpty()) {
            providers = new ArrayList<HttpClientSpiProvider>(PROVIDERS);
        } else {
            providers = new ArrayList();
            for (String protocol : protocolPreference) {
                HttpClientSpiProvider spi = HTTP_PROVIDERS_BY_PROTOCOL.get(protocol);
                if (spi == null) {
                    throw new IllegalStateException("Requested protocol \"" + protocol + "\" is not available on classpath");
                }
                providers.add(spi);
            }
        }
        if (providers.isEmpty()) {
            throw new IllegalStateException("WebClient requires at least one protocol provider to be present on classpath, or configured through protocolPreference (such as http1)");
        }
        HashMap<String, ProtocolSpi> clients = new HashMap<String, ProtocolSpi>();
        ArrayList<ProtocolSpi> protocols = new ArrayList<ProtocolSpi>();
        ArrayList<ProtocolSpi> tcpProtocols = new ArrayList<ProtocolSpi>();
        for (HttpClientSpiProvider httpClientSpiProvider : providers) {
            ProtocolConfig protocolConfig = this.protocolConfigs.config(httpClientSpiProvider.protocolId(), httpClientSpiProvider.configType(), () -> (ProtocolConfig)provider.defaultConfig());
            HttpClientSpi clientSpi = (HttpClientSpi)httpClientSpiProvider.protocol(this, protocolConfig);
            String protocolId = httpClientSpiProvider.protocolId();
            ProtocolSpi spi = new ProtocolSpi(protocolId, clientSpi);
            clients.putIfAbsent(protocolId, spi);
            protocols.add(spi);
            if (!clientSpi.isTcp()) continue;
            tcpProtocols.add(spi);
        }
        this.clientSpiByProtocol = clients;
        this.protocols = protocols;
        this.tcpProtocols = tcpProtocols;
        this.tcpProtocolIds = tcpProtocols.stream().map(ProtocolSpi::id).toList();
    }

    @Override
    public WebClientCookieManager cookieManager() {
        return this.cookieManager;
    }

    @Override
    public HttpClientRequest method(Method method) {
        ClientUri clientUri = this.prototype().baseUri().map(ClientUri::create).orElseGet(ClientUri::create);
        this.prototype().baseQuery().ifPresent(arg_0 -> ((UriQueryWriteable)clientUri.writeableQuery()).from(arg_0));
        this.prototype().baseFragment().ifPresent(clientUri::fragment);
        return new HttpClientRequest(this, this.prototype(), method, clientUri, this.clientSpiByProtocol, this.protocols, this.tcpProtocols, this.tcpProtocolIds, this.clientSpiLruCache);
    }

    @Override
    public void closeResource() {
        for (ProtocolSpi o : List.copyOf(this.clientSpiByProtocol.values())) {
            o.spi().releaseResource();
        }
    }

    @Override
    public <T, C extends ProtocolConfig> T client(Protocol<T, C> protocol, C protocolConfig) {
        return protocol.provider().protocol(this, protocolConfig);
    }

    @Override
    public <T, C extends ProtocolConfig> T client(Protocol<T, C> protocol) {
        ClientProtocolProvider provider = protocol.provider();
        return (T)this.clientsByProtocol.computeIfAbsent(provider.protocolId(), protocolId -> {
            ProtocolConfig config = this.protocolConfigs.config(provider.protocolId(), provider.configType(), provider::defaultConfig);
            return protocol.provider().protocol(this, config);
        });
    }

    public WebClientConfig prototype() {
        return this.config;
    }

    @Override
    public ExecutorService executor() {
        return (ExecutorService)EXECUTOR.get();
    }

    static {
        HashMap providerMap = new HashMap();
        PROVIDERS.forEach(it -> providerMap.put(it.protocolId(), it));
        HTTP_PROVIDERS_BY_PROTOCOL = Map.copyOf(providerMap);
    }

    record ProtocolSpi(String id, HttpClientSpi spi) {
    }

    record EndpointKey(String scheme, String authority, Tls tlsConfig, Proxy proxy) {
    }
}

