/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.api;

import io.helidon.builder.api.RuntimeType;
import io.helidon.http.ClientRequestHeaders;
import io.helidon.http.ClientResponseHeaders;
import io.helidon.http.Http;
import io.helidon.webclient.api.ClientUri;
import io.helidon.webclient.api.WebClientCookieManagerConfig;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.CookieManager;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

@RuntimeType.PrototypedBy(value=WebClientCookieManagerConfig.class)
public class WebClientCookieManager
extends CookieManager
implements RuntimeType.Api<WebClientCookieManagerConfig> {
    private static final String COOKIE = Http.HeaderNames.COOKIE.defaultCase();
    private static final String SET_COOKIE = Http.HeaderNames.SET_COOKIE.defaultCase();
    private static final String SET_COOKIE2 = Http.HeaderNames.SET_COOKIE2.defaultCase();
    private final boolean acceptCookies;
    private final List<String> defaultCookies;
    private final WebClientCookieManagerConfig prototype;

    private WebClientCookieManager(WebClientCookieManagerConfig config) {
        super(config.cookieStore().orElse(null), config.cookiePolicy());
        this.prototype = config;
        this.defaultCookies = config.defaultCookies().entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).toList();
        this.acceptCookies = config.automaticStoreEnabled();
    }

    public static WebClientCookieManager create(WebClientCookieManagerConfig config) {
        return new WebClientCookieManager(config);
    }

    public static WebClientCookieManager create(Consumer<WebClientCookieManagerConfig.Builder> configConsumer) {
        return ((WebClientCookieManagerConfig.Builder)WebClientCookieManager.builder().update(configConsumer)).build();
    }

    public static WebClientCookieManagerConfig.Builder builder() {
        return WebClientCookieManagerConfig.builder();
    }

    public WebClientCookieManagerConfig prototype() {
        return this.prototype;
    }

    @Override
    public Map<String, List<String>> get(URI uri, Map<String, List<String>> requestHeaders) throws IOException {
        throw new UnsupportedOperationException("Not implemented, use get(URI, ClientRequestHeaders)");
    }

    @Override
    public void put(URI uri, Map<String, List<String>> responseHeaders) throws IOException {
        throw new UnsupportedOperationException("Not implemented, use put(URI, ClientResponseHeaders)");
    }

    public void request(ClientUri uri, ClientRequestHeaders requestHeaders) {
        try {
            if (this.acceptCookies) {
                Map<String, List<String>> cookieMap = super.get(uri.toUri(), Map.of());
                List<String> cookies = cookieMap.get(COOKIE);
                cookies.addAll(this.defaultCookies);
                if (!cookies.isEmpty()) {
                    requestHeaders.add(Http.HeaderNames.COOKIE, cookies.toArray(new String[0]));
                }
            } else if (!this.defaultCookies.isEmpty()) {
                requestHeaders.add(Http.HeaderNames.COOKIE, this.defaultCookies.toArray(new String[0]));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void response(ClientUri uri, ClientResponseHeaders headers) {
        try {
            if (this.acceptCookies) {
                HashMap<String, List<String>> cookies = null;
                if (headers.contains(Http.HeaderNames.SET_COOKIE)) {
                    cookies = new HashMap<String, List<String>>();
                    cookies.put(SET_COOKIE, headers.get(Http.HeaderNames.SET_COOKIE).allValues());
                }
                if (headers.contains(Http.HeaderNames.SET_COOKIE2)) {
                    cookies = cookies == null ? new HashMap<String, List<String>>() : cookies;
                    cookies.put(SET_COOKIE2, headers.get(Http.HeaderNames.SET_COOKIE2).allValues());
                }
                if (cookies != null) {
                    super.put(uri.toUri(), cookies);
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

