// This is a generated file (powered by Helidon). Do not edit or extend from this artifact as it is subject to change at any time!

package io.helidon.webclient.api;

import java.net.CookiePolicy;
import java.net.CookieStore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;

/**
 * Interface generated from definition. Please add javadoc to the definition interface.
 *
 * @see #builder()
 * @see #create()
 */
@Generated(value = "io.helidon.builder.processor.BlueprintProcessor", trigger = "io.helidon.webclient.api.WebClientCookieManagerConfigBlueprint")
public interface WebClientCookieManagerConfig extends WebClientCookieManagerConfigBlueprint, Prototype.Api {

    /**
     * Create a new fluent API builder to customize configuration.
     *
     * @return a new builder
     */
    static WebClientCookieManagerConfig.Builder builder() {
        return new WebClientCookieManagerConfig.Builder();
    }

    /**
     * Create a new fluent API builder from an existing instance.
     *
     * @param instance an existing instance used as a base for the builder
     * @return a builder based on an instance
     */
    static WebClientCookieManagerConfig.Builder builder(WebClientCookieManagerConfig instance) {
        return WebClientCookieManagerConfig.builder().from(instance);
    }

    /**
     * Create a new instance from configuration.
     *
     * @param config used to configure the new instance
     * @return a new instance configured from configuration
     */
    static WebClientCookieManagerConfig create(Config config) {
        return WebClientCookieManagerConfig.builder().config(config).buildPrototype();
    }

    /**
     * Create a new instance with default values.
     *
     * @return a new instance
     */
    static WebClientCookieManagerConfig create() {
        return WebClientCookieManagerConfig.builder().buildPrototype();
    }

    /**
     * Fluent API builder base for {@link WebClientCookieManager}.
     *
     * @param <BUILDER> type of the builder extending this abstract builder
     * @param <PROTOTYPE> type of the prototype interface that would be built by {@link #buildPrototype()}
     */
    abstract class BuilderBase<BUILDER extends WebClientCookieManagerConfig.BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends WebClientCookieManagerConfig> implements Prototype.ConfiguredBuilder<BUILDER, PROTOTYPE> {

        private final Map<String, String> defaultCookies = new LinkedHashMap<>();
        private boolean automaticStoreEnabled = false;
        private Config config;
        private CookiePolicy cookiePolicy = java.net.CookiePolicy.ACCEPT_ORIGINAL_SERVER;
        private CookieStore cookieStore;

        /**
         * Protected to support extensibility.
         */
        protected BuilderBase() {
        }

        /**
         * Update this builder from an existing prototype instance.
         *
         * @param prototype existing prototype to update this builder from
         * @return updated builder instance
         */
        public BUILDER from(WebClientCookieManagerConfig prototype) {
            automaticStoreEnabled(prototype.automaticStoreEnabled());
            cookiePolicy(prototype.cookiePolicy());
            addDefaultCookies(prototype.defaultCookies());
            cookieStore(prototype.cookieStore());
            return self();
        }

        /**
         * Update this builder from an existing prototype builder instance.
         *
         * @param builder existing builder prototype to update this builder from
         * @return updated builder instance
         */
        public BUILDER from(WebClientCookieManagerConfig.BuilderBase<?, ?> builder) {
            automaticStoreEnabled(builder.automaticStoreEnabled());
            cookiePolicy(builder.cookiePolicy());
            addDefaultCookies(builder.defaultCookies());
            builder.cookieStore().ifPresent(this::cookieStore);
            return self();
        }

        /**
         * Update builder from configuration (node of this type).
         * If a value is present in configuration, it would override currently configured values.
         *
         * @param config configuration instance used to obtain values to update this builder
         * @return updated builder instance
         */
        @Override
        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("automatic-store-enabled").as(Boolean.class).ifPresent(this::automaticStoreEnabled);
            config.get("cookie-policy").as(CookiePolicy.class).ifPresent(this::cookiePolicy);
            config.get("default-cookies").asNodeList().ifPresent(nodes -> nodes.forEach(node -> defaultCookies.put(node.get("name").asString().orElse(node.name()), node.as(java.lang.String.class).get())));
            return self();
        }

        /**
         * Whether automatic cookie store is enabled or not.
         *
         * @param automaticStoreEnabled status of cookie store
         * @return updated builder instance
         * @see #automaticStoreEnabled()
         */
        public BUILDER automaticStoreEnabled(boolean automaticStoreEnabled) {
            this.automaticStoreEnabled = automaticStoreEnabled;
            return self();
        }

        /**
         * Current cookie policy for this client.
         *
         * @param cookiePolicy the cookie policy
         * @return updated builder instance
         * @see #cookiePolicy()
         */
        public BUILDER cookiePolicy(CookiePolicy cookiePolicy) {
            Objects.requireNonNull(cookiePolicy);
            this.cookiePolicy = cookiePolicy;
            return self();
        }

        /**
         * This method replaces all values with the new ones.
         *
         * @param defaultCookies map of default cookies
         * @return updated builder instance
         * @see #defaultCookies()
         */
        public BUILDER defaultCookies(Map<? extends String, ? extends String> defaultCookies) {
            Objects.requireNonNull(defaultCookies);
            this.defaultCookies.clear();
            this.defaultCookies.putAll(defaultCookies);
            return self();
        }

        /**
         * This method keeps existing values, then puts all new values into the map.
         *
         * @param defaultCookies map of default cookies
         * @return updated builder instance
         * @see #defaultCookies()
         */
        public BUILDER addDefaultCookies(Map<? extends String, ? extends String> defaultCookies) {
            Objects.requireNonNull(defaultCookies);
            this.defaultCookies.putAll(defaultCookies);
            return self();
        }

        /**
         * This method adds a new value to the map, or replaces it if the key already exists.
         *
         * @param key key to add or replace
         * @param defaultCookie new value for the key
         * @return updated builder instance
         * @see #defaultCookies()
         */
        public BUILDER putDefaultCookie(String key, String defaultCookie) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(defaultCookie);
            this.defaultCookies.put(key, defaultCookie);
            return self();
        }

        /**
         * Clear existing value of this property.
         *
         * @return updated builder instance
         * @see #cookieStore()
         */
        public BUILDER clearCookieStore() {
            this.cookieStore = null;
            return self();
        }

        /**
         * The cookie store where cookies are kept. If not defined, JDK default is used (in memory store).
         *
         * @param cookieStore cookie store
         * @return updated builder instance
         * @see #cookieStore()
         */
        public BUILDER cookieStore(CookieStore cookieStore) {
            Objects.requireNonNull(cookieStore);
            this.cookieStore = cookieStore;
            return self();
        }

        /**
         * Whether automatic cookie store is enabled or not.
         *
         * @return the automatic store enabled
         */
        public boolean automaticStoreEnabled() {
            return automaticStoreEnabled;
        }

        /**
         * Current cookie policy for this client.
         *
         * @return the cookie policy
         */
        public CookiePolicy cookiePolicy() {
            return cookiePolicy;
        }

        /**
         * Map of default cookies to include in all requests if cookies enabled.
         *
         * @return the default cookies
         */
        public Map<String, String> defaultCookies() {
            return defaultCookies;
        }

        /**
         * The cookie store where cookies are kept. If not defined, JDK default is used (in memory store).
         *
         * @return the cookie store
         */
        public Optional<CookieStore> cookieStore() {
            return Optional.ofNullable(cookieStore);
        }

        /**
         * If this instance was configured, this would be the config instance used.
         *
         * @return config node used to configure this builder, or empty if not configured
         */
        public Optional<Config> config() {
            return Optional.ofNullable(config);
        }

        @Override
        public String toString() {
            return "WebClientCookieManagerConfigBuilder{"
                    + "automaticStoreEnabled=" + automaticStoreEnabled + ","
                    + "cookiePolicy=" + cookiePolicy + ","
                    + "defaultCookies=" + defaultCookies + ","
                    + "cookieStore=" + cookieStore
                    + "}";
        }

        /**
         * Handles providers and decorators.
         */
        protected void preBuildPrototype() {
        }

        /**
         * Validates required properties.
         */
        protected void validatePrototype() {
        }

        /**
         * The cookie store where cookies are kept. If not defined, JDK default is used (in memory store).
         *
         * @param cookieStore cookie store
         * @return updated builder instance
         * @see #cookieStore()
         */
        BUILDER cookieStore(Optional<? extends CookieStore> cookieStore) {
            Objects.requireNonNull(cookieStore);
            this.cookieStore = cookieStore.orElse(null);
            return self();
        }

        /**
         * Generated implementation of the prototype, can be extended by descendant prototype implementations.
         */
        protected static class WebClientCookieManagerConfigImpl implements WebClientCookieManagerConfig, Supplier<WebClientCookieManager> {

            private final boolean automaticStoreEnabled;
            private final CookiePolicy cookiePolicy;
            private final Map<String, String> defaultCookies;
            private final Optional<CookieStore> cookieStore;

            /**
             * Create an instance providing a builder.
             *
             * @param builder extending builder base of this prototype
             */
            protected WebClientCookieManagerConfigImpl(WebClientCookieManagerConfig.BuilderBase<?, ?> builder) {
                this.automaticStoreEnabled = builder.automaticStoreEnabled();
                this.cookiePolicy = builder.cookiePolicy();
                this.defaultCookies = Collections.unmodifiableMap(new LinkedHashMap<>(builder.defaultCookies()));
                this.cookieStore = builder.cookieStore();
            }

            @Override
            public WebClientCookieManager build() {
                return WebClientCookieManager.create(this);
            }

            @Override
            public WebClientCookieManager get() {
                return build();
            }

            @Override
            public boolean automaticStoreEnabled() {
                return automaticStoreEnabled;
            }

            @Override
            public CookiePolicy cookiePolicy() {
                return cookiePolicy;
            }

            @Override
            public Map<String, String> defaultCookies() {
                return defaultCookies;
            }

            @Override
            public Optional<CookieStore> cookieStore() {
                return cookieStore;
            }

            @Override
            public String toString() {
                return "WebClientCookieManagerConfig{"
                        + "automaticStoreEnabled=" + automaticStoreEnabled + ","
                        + "cookiePolicy=" + cookiePolicy + ","
                        + "defaultCookies=" + defaultCookies + ","
                        + "cookieStore=" + cookieStore
                        + "}";
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof WebClientCookieManagerConfig other)) {
                    return false;
                }
                return automaticStoreEnabled == other.automaticStoreEnabled()
                        && Objects.equals(cookiePolicy, other.cookiePolicy())
                        && Objects.equals(defaultCookies, other.defaultCookies())
                        && Objects.equals(cookieStore, other.cookieStore());
            }

            @Override
            public int hashCode() {
                return Objects.hash(automaticStoreEnabled, cookiePolicy, defaultCookies, cookieStore);
            }

        }

    }

    /**
     * Fluent API builder for {@link WebClientCookieManager}.
     */
    class Builder extends WebClientCookieManagerConfig.BuilderBase<WebClientCookieManagerConfig.Builder, WebClientCookieManagerConfig> implements io.helidon.common.Builder<WebClientCookieManagerConfig.Builder, WebClientCookieManager> {

        private Builder() {
        }

        @Override
        public WebClientCookieManagerConfig buildPrototype() {
            preBuildPrototype();
            validatePrototype();
            return new WebClientCookieManagerConfigImpl(this);
        }

        @Override
        public WebClientCookieManager build() {
            return WebClientCookieManager.create(this.buildPrototype());
        }

    }

}
