/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.dns.resolver.roundrobin;

import io.helidon.webclient.api.DnsAddressLookup;
import io.helidon.webclient.api.RuntimeUnknownHostException;
import io.helidon.webclient.spi.DnsResolver;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public final class RoundRobinDnsResolver
implements DnsResolver {
    private final Map<String, HostnameAddresses> hostnameAddresses = new HashMap<String, HostnameAddresses>();

    private RoundRobinDnsResolver() {
    }

    public static RoundRobinDnsResolver create() {
        return new RoundRobinDnsResolver();
    }

    public InetAddress resolveAddress(String hostname, DnsAddressLookup dnsAddressLookup) {
        HostnameAddresses hostnameAddress = this.hostnameAddresses.computeIfAbsent(hostname, host -> {
            try {
                InetAddress[] processed = dnsAddressLookup.filter(InetAddress.getAllByName(host));
                if (processed.length == 0) {
                    throw new RuntimeUnknownHostException("No IP version " + dnsAddressLookup.name() + " found for host " + host);
                }
                return new HostnameAddresses(new AtomicInteger(), processed);
            }
            catch (UnknownHostException e) {
                throw new RuntimeUnknownHostException(e);
            }
        });
        return hostnameAddress.addresses[hostnameAddress.count.getAndIncrement() % hostnameAddress.addresses.length];
    }

    private record HostnameAddresses(AtomicInteger count, InetAddress[] addresses) {
    }
}

