/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.dns.resolver.first;

import io.helidon.webclient.api.DnsAddressLookup;
import io.helidon.webclient.api.RuntimeUnknownHostException;
import io.helidon.webclient.spi.DnsResolver;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

final class FirstDnsResolver
implements DnsResolver {
    private final Map<String, InetAddress> hostnameAddresses = new ConcurrentHashMap<String, InetAddress>();

    FirstDnsResolver() {
    }

    public InetAddress resolveAddress(String hostname, DnsAddressLookup dnsAddressLookup) {
        Objects.requireNonNull(hostname);
        Objects.requireNonNull(dnsAddressLookup);
        return this.hostnameAddresses.computeIfAbsent(hostname, host -> {
            try {
                InetAddress[] processed = dnsAddressLookup.filter(InetAddress.getAllByName(hostname));
                if (processed.length == 0) {
                    throw new RuntimeUnknownHostException("No IP version " + dnsAddressLookup.name() + " found for host " + host);
                }
                return processed[0];
            }
            catch (UnknownHostException e) {
                throw new RuntimeUnknownHostException(e);
            }
        });
    }
}

