/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing.jersey.client;

import io.helidon.common.context.Contexts;
import io.helidon.common.serviceloader.HelidonServiceLoader;
import io.helidon.tracing.config.SpanTracingConfig;
import io.helidon.tracing.config.TracingConfigUtil;
import io.helidon.tracing.jersey.client.internal.TracingContext;
import io.helidon.tracing.spi.TracerProvider;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapAdapter;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.MultivaluedMap;

@Priority(value=750)
public class ClientTracingFilter
implements ClientRequestFilter,
ClientResponseFilter {
    public static final String JAX_RS_TRACING_COMPONENT = "jax-rs";
    public static final String TRACER_PROPERTY_NAME = "io.helidon.tracing.tracer";
    public static final String SPAN_NAME_PROPERTY_NAME = ClientTracingFilter.class.getName() + ".span-name";
    public static final String ENABLED_PROPERTY_NAME = ClientTracingFilter.class.getName() + ".span-enabled";
    public static final String CURRENT_SPAN_CONTEXT_PROPERTY_NAME = "io.helidon.tracing.span-context";
    private static final String SPAN_OPERATION_NAME = "jersey-client-call";
    public static final String X_OT_SPAN_CONTEXT = "x-ot-span-context";
    public static final String X_REQUEST_ID = "x-request-id";
    static final String SPAN_PROPERTY_NAME = ClientTracingFilter.class.getName() + ".span";
    private static final List<String> PROPAGATED_HEADERS = List.of("x-request-id", "x-ot-span-context");
    private static final int HTTP_STATUS_ERROR_THRESHOLD = 400;
    private static final int HTTP_STATUS_SERVER_ERROR_THRESHOLD = 500;
    private final Optional<TracerProvider> tracerProvider;

    public ClientTracingFilter() {
        Iterator iterator = HelidonServiceLoader.create(ServiceLoader.load(TracerProvider.class)).iterator();
        this.tracerProvider = iterator.hasNext() ? Optional.of((TracerProvider)iterator.next()) : Optional.empty();
    }

    public void filter(ClientRequestContext requestContext) {
        Optional<TracingContext> tracingContext = Contexts.context().flatMap(ctx -> ctx.get(TracingContext.class));
        if (this.tracingDisabled(requestContext, tracingContext)) {
            return;
        }
        SpanTracingConfig spanConfig = TracingConfigUtil.spanConfig((String)JAX_RS_TRACING_COMPONENT, (String)SPAN_OPERATION_NAME);
        if (!spanConfig.enabled()) {
            return;
        }
        Tracer tracer = this.findTracer(requestContext, tracingContext);
        Optional<SpanContext> parentSpan = this.findParentSpan(tracer, requestContext, tracingContext);
        Map<String, List<String>> inboundHeaders = this.findInboundHeaders(tracingContext);
        String spanName = this.findSpanName(requestContext, spanConfig);
        Span currentSpan = this.createSpan(requestContext, tracer, parentSpan, spanName);
        requestContext.setProperty(SPAN_PROPERTY_NAME, (Object)currentSpan);
        Contexts.context().ifPresent(ctx -> ctx.register((Object)SPAN_PROPERTY_NAME, (Object)currentSpan));
        Contexts.context().ifPresent(ctx -> ctx.register(TracingConfigUtil.OUTBOUND_SPAN_QUALIFIER, (Object)currentSpan.context()));
        Map<String, List<String>> tracingHeaders = this.tracingHeaders(tracer, currentSpan);
        Map<String, List<String>> outboundHeaders = this.tracerProvider.map(provider -> provider.updateOutboundHeaders(currentSpan, tracer, (SpanContext)parentSpan.orElse(null), tracingHeaders, inboundHeaders)).orElse(tracingHeaders);
        outboundHeaders = this.updateOutboundHeaders(outboundHeaders, inboundHeaders);
        MultivaluedMap headers = requestContext.getHeaders();
        outboundHeaders.forEach((key, value) -> headers.put(key, new ArrayList(value)));
    }

    private boolean tracingDisabled(ClientRequestContext requestContext, Optional<TracingContext> tracingContext) {
        Optional<Boolean> enabled = ClientTracingFilter.property(requestContext, Boolean.class, ENABLED_PROPERTY_NAME);
        if (enabled.isPresent() && !enabled.get().booleanValue()) {
            return true;
        }
        return tracingContext.map(TracingContext::traceClient).map(value -> value == false).orElse(false);
    }

    private Map<String, List<String>> findInboundHeaders(Optional<TracingContext> tracingContext) {
        return tracingContext.map(TracingContext::inboundHeaders).orElse(Map.of());
    }

    private Map<String, List<String>> updateOutboundHeaders(Map<String, List<String>> outboundHeaders, Map<String, List<String>> inboundHeaders) {
        if (inboundHeaders.isEmpty()) {
            return outboundHeaders;
        }
        HashMap<String, List<String>> result = new HashMap<String, List<String>>(outboundHeaders);
        PROPAGATED_HEADERS.forEach(header -> result.computeIfAbsent((String)header, inboundHeaders::get));
        return result;
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) {
        Object property = requestContext.getProperty(SPAN_PROPERTY_NAME);
        if (property instanceof Span) {
            Span span = (Span)property;
            int status = responseContext.getStatus();
            Tags.HTTP_STATUS.set(span, Integer.valueOf(status));
            if (status >= 400) {
                Tags.ERROR.set(span, Boolean.valueOf(true));
                span.log(Map.of("event", "error", "message", "Response HTTP status: " + status, "error.kind", status < 500 ? "ClientError" : "ServerError"));
            }
            span.finish();
        }
    }

    private Optional<SpanContext> findParentSpan(Tracer tracer, ClientRequestContext requestContext, Optional<TracingContext> tracingContext) {
        Optional<SpanContext> property = ClientTracingFilter.property(requestContext, SpanContext.class, CURRENT_SPAN_CONTEXT_PROPERTY_NAME);
        if (property.isPresent()) {
            return property;
        }
        Span activeSpan = tracer.activeSpan();
        if (null != activeSpan) {
            return Optional.of(activeSpan.context());
        }
        return tracingContext.map(TracingContext::parentSpan).or(() -> Contexts.context().flatMap(ctx -> ctx.get(ClientTracingFilter.class, SpanContext.class))).or(() -> Contexts.context().flatMap(ctx -> ctx.get(SpanContext.class)));
    }

    private String findSpanName(ClientRequestContext requestContext, SpanTracingConfig spanConfig) {
        return ClientTracingFilter.property(requestContext, String.class, SPAN_NAME_PROPERTY_NAME).or(() -> ((SpanTracingConfig)spanConfig).newName()).orElseGet(() -> requestContext.getMethod().toUpperCase());
    }

    private Tracer findTracer(ClientRequestContext requestContext, Optional<TracingContext> tracingContext) {
        return ClientTracingFilter.property(requestContext, Tracer.class, TRACER_PROPERTY_NAME).or(() -> tracingContext.map(TracingContext::tracer)).or(() -> Contexts.context().flatMap(ctx -> ctx.get(Tracer.class))).orElseGet(GlobalTracer::get);
    }

    private static <T> Optional<T> property(ClientRequestContext requestContext, Class<T> clazz, String propertyName) {
        return Optional.ofNullable(requestContext.getProperty(propertyName)).filter(clazz::isInstance).or(() -> Optional.ofNullable(requestContext.getConfiguration().getProperty(propertyName)).filter(clazz::isInstance)).map(clazz::cast);
    }

    private Map<String, List<String>> tracingHeaders(Tracer tracer, Span currentSpan) {
        HashMap tracerHeaders = new HashMap();
        tracer.inject(currentSpan.context(), Format.Builtin.HTTP_HEADERS, (Object)new TextMapAdapter(tracerHeaders));
        return new HashMap<String, List<String>>(tracerHeaders.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> List.of((String)entry.getValue()))));
    }

    private Span createSpan(ClientRequestContext requestContext, Tracer tracer, Optional<SpanContext> parentSpan, String spanName) {
        Tracer.SpanBuilder spanBuilder = tracer.buildSpan(spanName).withTag(Tags.SPAN_KIND.getKey(), "client").withTag(Tags.HTTP_METHOD.getKey(), requestContext.getMethod()).withTag(Tags.HTTP_URL.getKey(), this.url(requestContext.getUri())).withTag(Tags.COMPONENT.getKey(), "jaxrs");
        parentSpan.ifPresent(arg_0 -> ((Tracer.SpanBuilder)spanBuilder).asChildOf(arg_0));
        return spanBuilder.start();
    }

    private String url(URI uri) {
        String host = uri.getHost();
        host = host.replace("127.0.0.1", "localhost");
        Object query = uri.getQuery();
        if (null == query) {
            query = "";
        } else if (!((String)query).isEmpty()) {
            query = "?" + (String)query;
        }
        return uri.getScheme() + "://" + host + ":" + uri.getPort() + uri.getPath() + (String)query;
    }
}

