/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing.jersey.client.internal;

import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public final class TracingContext {
    private static final ThreadLocal<TracingContext> TRACING_CONTEXT = new ThreadLocal();
    private SpanContext parentSpan;
    private final Tracer tracer;
    private final Map<String, List<String>> inboundHeaders;
    private boolean traceClient;

    public static Optional<TracingContext> get() {
        return Optional.ofNullable(TRACING_CONTEXT.get());
    }

    public static TracingContext compute(Supplier<TracingContext> contextSupplier) {
        TracingContext tracingContext = TRACING_CONTEXT.get();
        if (null == tracingContext) {
            TracingContext.set(contextSupplier.get());
        }
        return TracingContext.get().orElseThrow(() -> new IllegalStateException("Computed result was null"));
    }

    public static void set(TracingContext context) {
        TRACING_CONTEXT.set(context);
    }

    public static void remove() {
        TRACING_CONTEXT.remove();
    }

    public static TracingContext create(Tracer tracer, Map<String, List<String>> inboundHeaders) {
        return new TracingContext(tracer, inboundHeaders, true);
    }

    public static TracingContext create(Tracer tracer, Map<String, List<String>> inboundHeaders, boolean clientEnabled) {
        return new TracingContext(tracer, inboundHeaders, clientEnabled);
    }

    private TracingContext(Tracer tracer, Map<String, List<String>> inboundHeaders, boolean traceClient) {
        this.tracer = tracer;
        this.inboundHeaders = inboundHeaders;
        this.traceClient = traceClient;
    }

    public boolean traceClient() {
        return this.traceClient;
    }

    public SpanContext parentSpan() {
        return this.parentSpan;
    }

    public Tracer tracer() {
        return this.tracer;
    }

    public Map<String, List<String>> inboundHeaders() {
        return this.inboundHeaders;
    }

    public void parentSpan(SpanContext context) {
        this.parentSpan = context;
    }
}

