/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.configuration.ucp;

import io.helidon.service.configuration.api.ServiceConfiguration;
import io.helidon.service.configuration.api.ServiceConfigurationProvider;
import io.helidon.service.configuration.api.System;
import io.helidon.service.configuration.ucp.UCPServiceConfiguration;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;

public abstract class UCPServiceConfigurationProvider
extends ServiceConfigurationProvider {
    private static final Pattern WHITESPACE_COMMA_PATTERN = Pattern.compile("\\s*,\\s*");
    private final String prefix;

    protected UCPServiceConfigurationProvider() {
        super("ucp");
        this.prefix = "javax.sql.DataSource";
    }

    public String getPrefix() {
        return this.prefix;
    }

    protected UCPServiceConfiguration create(Properties properties, System system, Properties coordinates) {
        Objects.requireNonNull(properties);
        return new UCPServiceConfiguration(properties, system, coordinates);
    }

    public final ServiceConfiguration buildFor(Set<? extends System> systems, Properties coordinates) {
        Properties properties;
        UCPServiceConfiguration returnValue = null;
        System system = UCPServiceConfigurationProvider.getAuthoritativeSystem(systems, (Properties)coordinates);
        if (system != null && system.isEnabled() && this.appliesTo(properties = new Properties(), system, coordinates)) {
            returnValue = this.create(properties, system, coordinates);
        }
        return returnValue;
    }

    protected boolean appliesTo(Properties properties, System system, Properties coordinates) {
        Set<String> dataSourceNames;
        Objects.requireNonNull(properties);
        boolean returnValue = false;
        if (system != null && system.isEnabled() && (dataSourceNames = this.getDataSourceNames(properties, system, coordinates)) != null && !dataSourceNames.isEmpty()) {
            String prefix = this.getPrefix();
            assert (prefix != null);
            for (String dataSourceName : dataSourceNames) {
                block12: {
                    this.installDataSourceProperties(properties, system, coordinates, dataSourceName);
                    String dataSourceClassName = this.getDataSourceProperty(properties, system, coordinates, dataSourceName, "dataSourceClassName");
                    if (dataSourceClassName == null) {
                        String jdbcUrl = this.getDataSourceProperty(properties, system, coordinates, dataSourceName, "jdbcUrl");
                        if (jdbcUrl != null) {
                            try {
                                Driver driver = DriverManager.getDriver(jdbcUrl);
                                assert (driver != null);
                                returnValue = true;
                            }
                            catch (SQLException ohWell) {
                                assert (!returnValue);
                            }
                        }
                    } else {
                        try {
                            Class.forName(dataSourceClassName);
                            returnValue = true;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            if ($assertionsDisabled || !returnValue) break block12;
                            throw new AssertionError();
                        }
                    }
                }
                if (returnValue) continue;
                break;
            }
        }
        return returnValue;
    }

    private Set<String> getDataSourceNames(Properties target, System system, Properties coordinates) {
        Objects.requireNonNull(target);
        HashSet<String> returnValue = new HashSet<String>();
        String dataSourceNamesProperty = UCPServiceConfigurationProvider.getProperty(target, system, coordinates, this.getServiceIdentifier() + ".dataSourceNames", null);
        if (dataSourceNamesProperty == null || dataSourceNamesProperty.trim().isEmpty()) {
            Set<String> allPropertyNames = UCPServiceConfigurationProvider.getPropertyNames(target, system, coordinates);
            assert (allPropertyNames != null);
            String prefixWithDot = this.getPrefix() + ".";
            int prefixWithDotLength = prefixWithDot.length();
            for (String propertyName : allPropertyNames) {
                int dotIndex;
                if (propertyName == null || propertyName.length() <= prefixWithDotLength || !propertyName.startsWith(prefixWithDot) || (dotIndex = (propertyName = propertyName.substring(prefixWithDotLength)).indexOf(46)) <= 0) continue;
                returnValue.add(propertyName.substring(0, dotIndex));
            }
            if (returnValue.isEmpty()) {
                returnValue.add(null);
            }
        } else {
            returnValue.addAll(Arrays.asList(WHITESPACE_COMMA_PATTERN.split(dataSourceNamesProperty)));
        }
        return returnValue;
    }

    protected void installDataSourceProperties(Properties target, System system, Properties coordinates, String dataSourceName) {
        Objects.requireNonNull(target);
        String hikariPropertiesPathString = this.getDataSourceProperty(target, system, coordinates, this.getServiceIdentifier(), dataSourceName, "propertiesPath");
        if (hikariPropertiesPathString != null) {
            Properties temp = new Properties();
            try (BufferedReader reader2 = Files.newBufferedReader(Paths.get(hikariPropertiesPathString, new String[0]), StandardCharsets.UTF_8);){
                temp.load(reader2);
                this.setDataSourceProperty(target, dataSourceName, "explicitlyConfigured", "true");
            }
            catch (IOException reader2) {
                // empty catch block
            }
            if (!temp.isEmpty()) {
                Set<String> names = temp.stringPropertyNames();
                assert (names != null);
                assert (!names.isEmpty());
                String prefix = this.getPrefix();
                assert (prefix != null);
                for (String unprefixedPropertyName : names) {
                    if (unprefixedPropertyName == null || unprefixedPropertyName.isEmpty()) continue;
                    if (dataSourceName == null || dataSourceName.isEmpty() || unprefixedPropertyName.startsWith(prefix + "." + dataSourceName + ".")) {
                        target.setProperty(unprefixedPropertyName, temp.getProperty(unprefixedPropertyName));
                        continue;
                    }
                    target.setProperty(prefix + "." + dataSourceName + "." + unprefixedPropertyName, temp.getProperty(unprefixedPropertyName));
                }
            }
        }
    }

    private Object setDataSourceProperty(Properties properties, String dataSourceName, String unprefixedPropertyName, String propertyValue) {
        Objects.requireNonNull(properties);
        Object returnValue = properties.setProperty(UCPServiceConfigurationProvider.prefixDataSourcePropertyName(this.getPrefix(), dataSourceName, unprefixedPropertyName), propertyValue);
        return returnValue;
    }

    protected final String getDataSourceProperty(Properties properties, System system, Properties coordinates, String dataSourceName, String unprefixedPropertyName) {
        return this.getDataSourceProperty(properties, system, coordinates, this.getPrefix(), dataSourceName, unprefixedPropertyName);
    }

    private String getDataSourceProperty(Properties properties, System system, Properties coordinates, String prefix, String dataSourceName, String unprefixedPropertyName) {
        String returnValue = UCPServiceConfigurationProvider.getProperty(properties, system, coordinates, UCPServiceConfigurationProvider.prefixDataSourcePropertyName(prefix, dataSourceName, unprefixedPropertyName), null);
        return returnValue;
    }

    private static String prefixDataSourcePropertyName(String prefix, String dataSourceName, String unprefixedPropertyName) {
        Objects.requireNonNull(prefix);
        if (prefix.isEmpty()) {
            throw new IllegalArgumentException("prefix.isEmpty()");
        }
        Objects.requireNonNull(unprefixedPropertyName);
        String prefixedPropertyName = dataSourceName == null ? prefix + "." + unprefixedPropertyName : ((dataSourceName = dataSourceName.trim()).isEmpty() ? prefix + "." + unprefixedPropertyName : prefix + "." + dataSourceName + "." + unprefixedPropertyName);
        return prefixedPropertyName;
    }

    private static Set<String> getPropertyNames(Properties properties, System system, Properties coordinates) {
        Objects.requireNonNull(properties);
        HashSet<String> returnValue = new HashSet<String>();
        Properties systemProperties = system == null || !system.isEnabled() ? null : system.getProperties();
        if (systemProperties != null) {
            returnValue.addAll(systemProperties.stringPropertyNames());
        }
        returnValue.addAll(properties.stringPropertyNames());
        if (coordinates != null) {
            returnValue.addAll(coordinates.stringPropertyNames());
        }
        return Collections.unmodifiableSet(returnValue);
    }

    private static String getProperty(Properties properties, System system, Properties coordinates, String propertyName, String defaultValue) {
        Objects.requireNonNull(properties);
        Objects.requireNonNull(propertyName);
        String returnValue = properties.getProperty(propertyName);
        if (returnValue == null) {
            if (coordinates != null) {
                returnValue = coordinates.getProperty(propertyName);
            }
            if (returnValue == null) {
                Properties systemProperties;
                returnValue = system == null || !system.isEnabled() ? java.lang.System.getProperty(propertyName, defaultValue) : ((systemProperties = system.getProperties()) == null ? defaultValue : systemProperties.getProperty(propertyName, defaultValue));
            }
        }
        return returnValue;
    }
}

