/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.configuration.ucp.localhost;

import io.helidon.service.configuration.api.System;
import io.helidon.service.configuration.ucp.UCPServiceConfiguration;
import io.helidon.service.configuration.ucp.localhost.UCPServiceConfigurationLocalhostProvider;
import java.util.Objects;
import java.util.Properties;

public class UCPServiceConfigurationLocalhost
extends UCPServiceConfiguration {
    private final UCPServiceConfigurationLocalhostProvider provider;

    public UCPServiceConfigurationLocalhost(UCPServiceConfigurationLocalhostProvider provider, Properties properties, System system, Properties coordinates) {
        super(Objects.requireNonNull(properties), system, coordinates);
        this.provider = Objects.requireNonNull(provider);
    }

    public String getProperty(String propertyName, String defaultValue) {
        String returnValue = this.properties.getProperty(Objects.requireNonNull(propertyName));
        if (returnValue == null) {
            String dataSourceName;
            String prefix = this.provider.getPrefix();
            assert (prefix != null);
            assert (!prefix.isEmpty());
            if (propertyName.startsWith(prefix + ".") && (dataSourceName = this.provider.extractDataSourceName(propertyName)) != null && !(dataSourceName = dataSourceName.trim()).isEmpty()) {
                this.provider.installDataSourceProperties(this.properties, this.system, this.coordinates, dataSourceName);
                returnValue = this.properties.getProperty(propertyName);
            }
        }
        return returnValue;
    }
}

