/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.configuration.hikaricp.accs;

import io.helidon.service.configuration.api.System;
import io.helidon.service.configuration.hikaricp.HikariCPServiceConfigurationProvider;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;

public class HikariCPServiceConfigurationACCSProvider
extends HikariCPServiceConfigurationProvider {
    protected boolean appliesTo(Properties properties, System system, Properties coordinates) {
        Set keys;
        Map env;
        Objects.requireNonNull(properties);
        boolean returnValue = false;
        if (system != null && system.isEnabled() && "accs".equalsIgnoreCase(system.getName()) && (env = system.getenv()) != null && !env.isEmpty() && (keys = env.keySet()) != null && !keys.isEmpty()) {
            boolean dbaas = false;
            boolean mysqlcs = false;
            for (String key : keys) {
                if (key == null) continue;
                if (dbaas) {
                    if (!mysqlcs && !key.startsWith("MYSQLCS_")) continue;
                    mysqlcs = true;
                    break;
                }
                if (mysqlcs) {
                    if (!key.startsWith("DBAAS_")) continue;
                    dbaas = true;
                    break;
                }
                if (key.startsWith("DBAAS_")) {
                    dbaas = true;
                    continue;
                }
                if (!key.startsWith("MYSQLCS_")) continue;
                mysqlcs = true;
            }
            returnValue = dbaas ? (mysqlcs ? false : super.appliesTo(properties, system, coordinates)) : (mysqlcs ? super.appliesTo(properties, system, coordinates) : false);
        }
        return returnValue;
    }

    protected void installDataSourceProperties(Properties target, System system, Properties coordinates, String dataSourceName) {
        Objects.requireNonNull(target);
        super.installDataSourceProperties(target, system, coordinates, dataSourceName);
        if (!"true".equalsIgnoreCase(this.getDataSourceProperty(target, system, coordinates, dataSourceName, "explicitlyConfigured"))) {
            String password;
            String user;
            String url;
            String description;
            String dataSourceClassName;
            String prefix = this.getPrefix();
            assert (prefix != null);
            assert (!prefix.isEmpty());
            String urlValue = HikariCPServiceConfigurationACCSProvider.getJdbcUrl(system, dataSourceName);
            if (dataSourceName == null) {
                dataSourceClassName = prefix + ".dataSourceClassName";
                description = prefix + ".dataSource.description";
                url = prefix + ".dataSource.url";
                user = prefix + ".dataSource.user";
                password = prefix + ".dataSource.password";
            } else if ((dataSourceName = dataSourceName.trim()).isEmpty()) {
                dataSourceClassName = prefix + ".dataSourceClassName";
                description = prefix + ".dataSource.description";
                url = prefix + ".dataSource.url";
                user = prefix + ".dataSource.user";
                password = prefix + ".dataSource.password";
            } else {
                dataSourceClassName = prefix + "." + dataSourceName + ".dataSourceClassName";
                description = prefix + "." + dataSourceName + ".dataSource.description";
                url = prefix + "." + dataSourceName + ".dataSource.url";
                user = prefix + "." + dataSourceName + ".dataSource.user";
                password = prefix + "." + dataSourceName + ".dataSource.password";
            }
            target.setProperty(dataSourceClassName, this.getDataSourceClassName(urlValue));
            target.setProperty(url, urlValue);
            target.setProperty(description, "Autodiscovered");
            target.setProperty(user, HikariCPServiceConfigurationACCSProvider.getUser(system, dataSourceName));
            target.setProperty(password, HikariCPServiceConfigurationACCSProvider.getPassword(system, dataSourceName));
        }
    }

    protected String getDataSourceClassName(String jdbcUrl) {
        int colonIndex;
        Objects.requireNonNull(jdbcUrl);
        String returnValue = null;
        if (jdbcUrl.startsWith("jdbc:") && jdbcUrl.length() > "jdbc:".length() && (colonIndex = jdbcUrl.indexOf(58, "jdbc:".length())) > 0) {
            String type = jdbcUrl.substring("jdbc:".length(), colonIndex);
            assert (type != null);
            assert (!type.isEmpty());
            switch (type) {
                case "mysql": {
                    returnValue = "com.mysql.cj.jdbc.MysqlDataSource";
                    break;
                }
                case "oracle": {
                    returnValue = "oracle.jdbc.pool.OracleDataSource";
                    break;
                }
            }
        }
        return returnValue;
    }

    private static String getUser(System system, String suppliedDataSourceName) {
        String returnValue = null;
        if (system != null) {
            Map env = system.getenv();
            assert (env != null);
            String dataSourceName = null;
            if (suppliedDataSourceName != null && (dataSourceName = suppliedDataSourceName.trim().toUpperCase()).isEmpty()) {
                dataSourceName = null;
            }
            if (dataSourceName == null) {
                if (env.containsKey("DBAAS_USER")) {
                    if (!env.containsKey("MYSQLCS_USER_NAME")) {
                        returnValue = (String)env.get("DBAAS_USER");
                    }
                } else if (env.containsKey("MYSQLCS_USER_NAME")) {
                    returnValue = (String)env.get("MYSQLCS_USER_NAME");
                }
            } else if (env.containsKey("DBAAS_" + dataSourceName + "_USER")) {
                if (!env.containsKey("MYSQLCS_" + dataSourceName + "_USER_NAME")) {
                    returnValue = (String)env.get("DBAAS_" + dataSourceName + "_USER");
                }
            } else if (env.containsKey("MYSQLCS_ " + dataSourceName + "_USER_NAME")) {
                returnValue = (String)env.get("MYSQLCS_" + dataSourceName + "_USER_NAME");
            }
        }
        return returnValue;
    }

    private static String getPassword(System system, String suppliedDataSourceName) {
        String returnValue = null;
        if (system != null) {
            Map env = system.getenv();
            assert (env != null);
            String dataSourceName = null;
            if (suppliedDataSourceName != null && (dataSourceName = suppliedDataSourceName.trim().toUpperCase()).isEmpty()) {
                dataSourceName = null;
            }
            if (dataSourceName == null) {
                if (env.containsKey("DBAAS_PASSWORD")) {
                    if (!env.containsKey("MYSQLCS_USER_PASSWORD")) {
                        returnValue = (String)env.get("DBAAS_PASSWORD");
                    }
                } else if (env.containsKey("MYSQLCS_USER_PASSWORD")) {
                    returnValue = (String)env.get("MYSQLCS_USER_PASSWORD");
                }
            } else if (env.containsKey("DBAAS_" + dataSourceName + "_PASSWORD")) {
                if (!env.containsKey("MYSQLCS_" + dataSourceName + "_USER_PASSWORD")) {
                    returnValue = (String)env.get("DBAAS_" + dataSourceName + "_PASSWORD");
                }
            } else if (env.containsKey("MYSQLCS_ " + dataSourceName + "_USER_PASSWORD")) {
                returnValue = (String)env.get("MYSQLCS_" + dataSourceName + "_USER_PASSWORD");
            }
        }
        return returnValue;
    }

    private static String getJdbcUrl(System system, String suppliedDataSourceName) {
        String returnValue = null;
        if (system != null) {
            Map env = system.getenv();
            assert (env != null);
            String dataSourceName = null;
            if (suppliedDataSourceName != null && (dataSourceName = suppliedDataSourceName.trim().toUpperCase()).isEmpty()) {
                dataSourceName = null;
            }
            if (dataSourceName == null) {
                if (env.containsKey("DBAAS_DEFAULT_CONNECT_DESCRIPTOR")) {
                    if (!env.containsKey("MYSQLCS_CONNECT_STRING")) {
                        returnValue = "jdbc:oracle:thin:@//" + (String)env.get("DBAAS_DEFAULT_CONNECT_DESCRIPTOR");
                    }
                } else if (env.containsKey("MYSQLCS_CONNECT_STRING")) {
                    returnValue = "jdbc:mysql://" + (String)env.get("MYSQLCS_CONNECT_STRING");
                }
            } else if (env.containsKey("DBAAS_" + dataSourceName + "_CONNECT_DESCRIPTOR")) {
                if (!env.containsKey("MYSQLCS_" + dataSourceName + "_URL")) {
                    returnValue = "jdbc:oracle:thin:@//" + (String)env.get("DBAAS_" + dataSourceName + "_CONNECT_DESCRIPTOR");
                }
            } else if (env.containsKey("MYSQLCS_ " + dataSourceName + "_CONNECT_STRING")) {
                returnValue = "jdbc:mysql://" + (String)env.get("MYSQLCS_" + dataSourceName + "_CONNECT_STRING");
            }
        }
        return returnValue;
    }
}

