/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.configuration.microprofile.config;

import io.helidon.service.configuration.api.ServiceConfiguration;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class ServiceConfigurationConfigSource
implements ConfigSource {
    private final ServiceConfiguration sc;
    private final String name;

    protected ServiceConfigurationConfigSource() {
        this(null);
    }

    protected ServiceConfigurationConfigSource(ServiceConfiguration serviceConfiguration) {
        if (serviceConfiguration == null) {
            String lowerCaseSimpleClassName = this.getClass().getSimpleName().toLowerCase();
            this.name = System.getProperty(lowerCaseSimpleClassName + ".serviceIdentifier", lowerCaseSimpleClassName);
            this.sc = ServiceConfiguration.getInstance((String)this.name);
        } else {
            this.name = serviceConfiguration.getServiceIdentifier();
            this.sc = serviceConfiguration;
        }
    }

    public final String getName() {
        return this.name;
    }

    public final Set<String> getPropertyNames() {
        Set<Object> scPropertyNames;
        Set<Object> returnValue = this.sc == null ? Collections.emptySet() : ((scPropertyNames = this.sc.getPropertyNames()) == null ? Collections.emptySet() : scPropertyNames);
        return returnValue;
    }

    public final Map<String, String> getProperties() {
        Map<String, String> returnValue;
        if (this.sc == null) {
            returnValue = Collections.emptyMap();
        } else {
            Set propertyNames = this.sc.getPropertyNames();
            if (propertyNames == null || propertyNames.isEmpty()) {
                returnValue = Collections.emptyMap();
            } else {
                LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
                for (String propertyName : propertyNames) {
                    if (propertyName == null) continue;
                    properties.put(propertyName, this.sc.getProperty(propertyName));
                }
                returnValue = properties.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(properties);
            }
        }
        return returnValue;
    }

    public final String getValue(String name) {
        String returnValue = this.sc == null ? null : this.sc.getProperty(name);
        return returnValue;
    }
}

