/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.configuration.api;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;

public abstract class System {
    private final String name;
    private final boolean authoritative;

    protected System(String name, boolean authoritative) {
        this.name = Objects.requireNonNull(name);
        this.authoritative = authoritative;
    }

    public final String getName() {
        return this.name;
    }

    public abstract boolean isEnabled();

    public boolean isAuthoritative() {
        return this.authoritative;
    }

    public Map<String, String> getenv() {
        return java.lang.System.getenv();
    }

    public Properties getProperties() {
        return java.lang.System.getProperties();
    }

    public int hashCode() {
        int hashCode = 17;
        String value = this.getName();
        int c = value == null ? 0 : value.hashCode();
        hashCode = 37 * hashCode + c;
        c = this.isEnabled() ? 1 : 0;
        hashCode = 37 * hashCode + c;
        c = this.isAuthoritative() ? 1 : 0;
        hashCode = 37 * hashCode + c;
        return hashCode;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof System) {
            System her = (System)other;
            String name = this.getName();
            if (name == null ? her.getName() != null : !name.equals(her.getName())) {
                return false;
            }
            return this.isEnabled() && her.isEnabled() && this.isAuthoritative() && her.isAuthoritative();
        }
        return false;
    }

    public static final Set<System> getSystems() {
        ServiceLoader<System> systemsIterable = ServiceLoader.load(System.class);
        assert (systemsIterable != null);
        Set<System> returnValue = null;
        for (System system : systemsIterable) {
            assert (system != null);
            if (!system.isEnabled()) continue;
            if (system.isAuthoritative()) {
                returnValue = Collections.singleton(system);
                break;
            }
            if (returnValue == null) {
                returnValue = new HashSet();
                returnValue.add(system);
                continue;
            }
            returnValue.add(system);
            break;
        }
        if (returnValue == null) {
            returnValue = Collections.emptySet();
        } else {
            assert (!returnValue.isEmpty());
            returnValue = Collections.unmodifiableSet(returnValue);
        }
        return returnValue;
    }
}

