/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.configuration.api;

import io.helidon.service.configuration.api.ServiceConfigurationProvider;
import io.helidon.service.configuration.api.System;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;

public abstract class ServiceConfiguration {
    private static volatile Iterable<ServiceConfigurationProvider> serviceConfigurationProviders;
    private final String serviceIdentifier;

    private ServiceConfiguration() {
        this.serviceIdentifier = null;
    }

    protected ServiceConfiguration(String serviceIdentifier) {
        this.serviceIdentifier = Objects.requireNonNull(serviceIdentifier);
    }

    public final String getServiceIdentifier() {
        return this.serviceIdentifier;
    }

    public abstract Set<String> getPropertyNames();

    public final String getProperty(String propertyName) {
        return this.getProperty(propertyName, null);
    }

    public abstract String getProperty(String var1, String var2);

    public static final ServiceConfiguration getInstance(String serviceIdentifier) {
        return ServiceConfiguration.getInstance(serviceIdentifier, null);
    }

    public static final ServiceConfiguration getInstance(String serviceIdentifier, Properties coordinates) {
        Objects.requireNonNull(serviceIdentifier);
        ServiceConfiguration returnValue = null;
        Iterable<ServiceConfigurationProvider> serviceConfigurationProviders = ServiceConfiguration.serviceConfigurationProviders;
        if (serviceConfigurationProviders == null) {
            serviceConfigurationProviders = ServiceLoader.load(ServiceConfigurationProvider.class);
            assert (serviceConfigurationProviders != null);
            ServiceConfiguration.serviceConfigurationProviders = serviceConfigurationProviders;
        }
        assert (serviceConfigurationProviders != null);
        Set<System> systems = System.getSystems();
        for (ServiceConfigurationProvider serviceConfigurationProvider : serviceConfigurationProviders) {
            assert (serviceConfigurationProvider != null);
            if (!serviceIdentifier.equals(serviceConfigurationProvider.getServiceIdentifier()) || (returnValue = serviceConfigurationProvider.buildFor(systems, coordinates)) == null) continue;
            if (serviceIdentifier.equals(returnValue.getServiceIdentifier())) break;
            throw new IllegalStateException("!serviceIdentifier.equals(returnValue.getServiceIdentifier()): !\"" + serviceIdentifier + "\".equals(\"" + returnValue.getServiceIdentifier() + "\")");
        }
        return returnValue;
    }
}

