/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.configuration.api;

import io.helidon.service.configuration.api.ServiceConfiguration;
import io.helidon.service.configuration.api.System;
import java.util.Iterator;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;

public abstract class ServiceConfigurationProvider {
    private final String serviceIdentifier;

    private ServiceConfigurationProvider() {
        this.serviceIdentifier = null;
    }

    protected ServiceConfigurationProvider(String serviceIdentifier) {
        this.serviceIdentifier = Objects.requireNonNull(serviceIdentifier);
    }

    public final String getServiceIdentifier() {
        return this.serviceIdentifier;
    }

    public abstract ServiceConfiguration buildFor(Set<? extends System> var1, Properties var2);

    protected static final System getAuthoritativeSystem(Set<? extends System> systems, Properties coordinates) {
        Iterator<? extends System> iterator;
        System returnValue = null;
        if (systems != null && !systems.isEmpty() && (iterator = systems.iterator()) != null && iterator.hasNext()) {
            returnValue = iterator.next();
            if (iterator.hasNext()) {
                assert (systems.size() > 1);
                while (returnValue == null || !returnValue.isEnabled() || !returnValue.isAuthoritative()) {
                    returnValue = iterator.next();
                    if (iterator.hasNext()) continue;
                    break;
                }
            } else if (returnValue != null && !returnValue.isEnabled()) {
                assert (systems.size() == 1);
                returnValue = null;
            }
        }
        return returnValue;
    }
}

