/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.provider.httpsign;

import io.helidon.common.pki.KeyConfig;
import io.helidon.config.Config;
import io.helidon.security.provider.httpsign.HttpSignHeader;
import io.helidon.security.provider.httpsign.HttpSignProvider;
import io.helidon.security.provider.httpsign.HttpSignatureException;
import io.helidon.security.provider.httpsign.SignedHeadersConfig;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public class OutboundTargetDefinition {
    private final String keyId;
    private final String algorithm;
    private final KeyConfig keyConfig;
    private final HttpSignHeader header;
    private final byte[] hmacSharedSecret;
    private final SignedHeadersConfig signedHeadersConfig;

    private OutboundTargetDefinition(Builder builder) {
        this.keyId = builder.keyId;
        this.algorithm = builder.algorithm;
        this.keyConfig = builder.keyConfig;
        this.header = builder.header;
        this.hmacSharedSecret = builder.hmacSharedSecret;
        this.signedHeadersConfig = builder.signedHeadersConfig;
        Objects.requireNonNull(this.algorithm, "Signature algorithm must not be null");
        Objects.requireNonNull(this.keyId, "Key id must not be null");
        Objects.requireNonNull(this.header, "Header to use must not be null");
        Objects.requireNonNull(this.signedHeadersConfig, "Configuration of how to sign headers must not be null");
        if ("hmac-sha256".equals(this.algorithm)) {
            Objects.requireNonNull(this.hmacSharedSecret, "HMAC shared secret must not be null");
        } else if ("rsa-sha256".equals(this.algorithm)) {
            Objects.requireNonNull(this.keyConfig, "RSA Keys configuration must not be null");
        }
    }

    public static Builder builder(String keyId) {
        return new Builder().keyId(keyId);
    }

    public static Builder builder(Config config) {
        return new Builder().fromConfig(config);
    }

    public static OutboundTargetDefinition fromConfig(Config config) {
        return OutboundTargetDefinition.builder(config).build();
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public Optional<KeyConfig> getKeyConfig() {
        return Optional.ofNullable(this.keyConfig);
    }

    public Optional<byte[]> getHmacSharedSecret() {
        return Optional.ofNullable(this.hmacSharedSecret);
    }

    public HttpSignHeader getHeader() {
        return this.header;
    }

    public SignedHeadersConfig getSignedHeadersConfig() {
        return this.signedHeadersConfig;
    }

    public static class Builder
    implements io.helidon.common.Builder<OutboundTargetDefinition> {
        private String keyId;
        private String algorithm;
        private KeyConfig keyConfig;
        private HttpSignHeader header = HttpSignHeader.SIGNATURE;
        private byte[] hmacSharedSecret;
        private SignedHeadersConfig signedHeadersConfig = HttpSignProvider.DEFAULT_REQUIRED_HEADERS;

        private Builder() {
        }

        public Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public Builder header(HttpSignHeader header) {
            this.header = header;
            return this;
        }

        public Builder algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder privateKeyConfig(KeyConfig keyConfig) {
            if (null == this.algorithm) {
                this.algorithm = "rsa-sha256";
            }
            keyConfig.getPrivateKey().orElseThrow(() -> new HttpSignatureException("Configuration must contain a private key"));
            this.keyConfig = keyConfig;
            return this;
        }

        public Builder signedHeaders(SignedHeadersConfig config) {
            this.signedHeadersConfig = config;
            return this;
        }

        public Builder hmacSecret(byte[] secret) {
            if (null == this.algorithm) {
                this.algorithm = "hmac-sha256";
            }
            this.hmacSharedSecret = Arrays.copyOf(secret, secret.length);
            return this;
        }

        public Builder hmacSecret(String secret) {
            return this.hmacSecret(secret.getBytes(StandardCharsets.UTF_8));
        }

        public OutboundTargetDefinition build() {
            return new OutboundTargetDefinition(this);
        }

        public Builder fromConfig(Config config) {
            Builder builder = new Builder();
            builder.keyId(config.get("key-id").asString());
            config.get("header").asOptional(HttpSignHeader.class).ifPresent(builder::header);
            config.get("sign-headers").asOptional(SignedHeadersConfig.class).ifPresent(builder::signedHeaders);
            config.get("private-key").asOptional(KeyConfig.class).ifPresent(builder::privateKeyConfig);
            config.get("hmac.secret").value().ifPresent(builder::hmacSecret);
            config.get("algorithm").value().ifPresent(builder::algorithm);
            return builder;
        }
    }
}

