/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.provider.httpsign;

import io.helidon.common.CollectionsHelper;
import io.helidon.config.Config;
import io.helidon.security.AuthenticationResponse;
import io.helidon.security.EndpointConfig;
import io.helidon.security.OutboundSecurityResponse;
import io.helidon.security.Principal;
import io.helidon.security.ProviderRequest;
import io.helidon.security.SecurityEnvironment;
import io.helidon.security.SecurityResponse;
import io.helidon.security.Subject;
import io.helidon.security.SubjectType;
import io.helidon.security.provider.httpsign.HttpSignHeader;
import io.helidon.security.provider.httpsign.HttpSignature;
import io.helidon.security.provider.httpsign.HttpSignatureException;
import io.helidon.security.provider.httpsign.InboundClientDefinition;
import io.helidon.security.provider.httpsign.OutboundTargetDefinition;
import io.helidon.security.provider.httpsign.SignedHeadersConfig;
import io.helidon.security.providers.OutboundConfig;
import io.helidon.security.spi.AuthenticationProvider;
import io.helidon.security.spi.OutboundSecurityProvider;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public final class HttpSignProvider
implements AuthenticationProvider,
OutboundSecurityProvider {
    static final String ALGORITHM_HMAC = "hmac-sha256";
    static final String ALGORITHM_RSA = "rsa-sha256";
    static final SignedHeadersConfig DEFAULT_REQUIRED_HEADERS = SignedHeadersConfig.builder().defaultConfig(SignedHeadersConfig.HeadersConfig.create(CollectionsHelper.listOf((Object[])new String[]{"date", "(request-target)"}))).config("get", SignedHeadersConfig.HeadersConfig.create(CollectionsHelper.listOf((Object[])new String[]{"date", "(request-target)", "host"}), CollectionsHelper.listOf((Object[])new String[]{"authorization"}))).config("head", SignedHeadersConfig.HeadersConfig.create(CollectionsHelper.listOf((Object[])new String[]{"date", "(request-target)", "host"}), CollectionsHelper.listOf((Object[])new String[]{"authorization"}))).config("delete", SignedHeadersConfig.HeadersConfig.create(CollectionsHelper.listOf((Object[])new String[]{"date", "(request-target)", "host"}), CollectionsHelper.listOf((Object[])new String[]{"authorization"}))).config("put", SignedHeadersConfig.HeadersConfig.create(CollectionsHelper.listOf((Object[])new String[]{"date", "(request-target)", "host"}), CollectionsHelper.listOf((Object[])new String[]{"authorization"}))).config("post", SignedHeadersConfig.HeadersConfig.create(CollectionsHelper.listOf((Object[])new String[]{"date", "(request-target)", "host"}), CollectionsHelper.listOf((Object[])new String[]{"authorization"}))).build();
    static final String ATTRIB_NAME_KEY_ID = HttpSignProvider.class.getName() + ".keyId";
    private final boolean optional;
    private final String realm;
    private final Set<HttpSignHeader> acceptHeaders;
    private final SignedHeadersConfig inboundRequiredHeaders;
    private final Map<String, InboundClientDefinition> inboundKeys;
    private final OutboundConfig outboundConfig;
    private final Map<String, OutboundTargetDefinition> targetKeys = new HashMap<String, OutboundTargetDefinition>();

    private HttpSignProvider(Builder builder) {
        this.optional = builder.optional;
        this.realm = builder.realm;
        this.acceptHeaders = builder.acceptHeaders.isEmpty() ? EnumSet.of(HttpSignHeader.SIGNATURE, HttpSignHeader.AUTHORIZATION) : EnumSet.copyOf(builder.acceptHeaders);
        this.inboundRequiredHeaders = builder.inboundRequiredHeaders;
        this.inboundKeys = builder.inboundKeys;
        this.outboundConfig = builder.outboundConfig;
        this.outboundConfig.getTargets().forEach(target -> target.getConfig().ifPresent(targetConfig -> {
            OutboundTargetDefinition outboundTargetDefinition = (OutboundTargetDefinition)targetConfig.get("signature").as(OutboundTargetDefinition.class);
            this.targetKeys.put(target.getName(), outboundTargetDefinition);
        }));
    }

    public static HttpSignProvider fromConfig(Config config) {
        return HttpSignProvider.builder().fromConfig(config).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public CompletionStage<AuthenticationResponse> authenticate(ProviderRequest providerRequest) {
        Map headers = providerRequest.getEnv().getHeaders();
        if (headers.get("Signature") != null && this.acceptHeaders.contains((Object)HttpSignHeader.SIGNATURE)) {
            return CompletableFuture.supplyAsync(() -> this.signatureHeader((List)headers.get("Signature"), providerRequest.getEnv()), providerRequest.getContext().getExecutorService());
        }
        if (headers.get("Authorization") != null && this.acceptHeaders.contains((Object)HttpSignHeader.AUTHORIZATION)) {
            return CompletableFuture.supplyAsync(() -> this.authorizeHeader(providerRequest.getEnv()), providerRequest.getContext().getExecutorService());
        }
        if (this.optional) {
            return CompletableFuture.completedFuture(AuthenticationResponse.abstain());
        }
        return CompletableFuture.completedFuture(AuthenticationResponse.failed((String)("Missing header. Accepted headers: " + this.acceptHeaders)));
    }

    private AuthenticationResponse authorizeHeader(SecurityEnvironment env) {
        List authorization = (List)env.getHeaders().get("Authorization");
        AuthenticationResponse response = null;
        for (String authorizationValue : authorization) {
            if (!authorizationValue.toLowerCase().startsWith("signature ") || !(response = this.signatureHeader(CollectionsHelper.listOf((Object[])new String[]{authorizationValue.substring("singature ".length())}), env)).getStatus().isSuccess()) continue;
            return response;
        }
        if (this.optional) {
            return AuthenticationResponse.abstain();
        }
        return this.challenge(env, null == response ? "No Signature authorization header" : response.getDescription().orElse("Unknown problem"));
    }

    private AuthenticationResponse challenge(SecurityEnvironment env, String description) {
        return ((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)AuthenticationResponse.builder().responseHeader("WWW-Authenticate", "Signature realm=\"" + this.realm + ",headers=\"" + this.headersForMethod(env.getMethod()) + "\"")).status(SecurityResponse.SecurityStatus.FAILURE)).statusCode(401)).description(description)).build();
    }

    private String headersForMethod(String method) {
        return String.join((CharSequence)" ", this.inboundRequiredHeaders.getHeaders(method.toLowerCase()));
    }

    private AuthenticationResponse signatureHeader(List<String> signatures, SecurityEnvironment env) {
        String lastError = signatures.isEmpty() ? "No signature values for Signature header" : null;
        for (String signature : signatures) {
            HttpSignature httpSignature = HttpSignature.fromHeader(signature);
            Optional<String> validate = httpSignature.validate();
            if (validate.isPresent()) {
                lastError = validate.get();
                continue;
            }
            InboundClientDefinition clientDefinition = this.inboundKeys.get(httpSignature.getKeyId());
            if (null == clientDefinition) {
                lastError = "Client definition for client with key " + httpSignature.getKeyId() + " not found";
                continue;
            }
            return this.validateSignature(env, httpSignature, clientDefinition);
        }
        if (this.optional) {
            return AuthenticationResponse.abstain();
        }
        return AuthenticationResponse.failed((String)lastError);
    }

    private AuthenticationResponse validateSignature(SecurityEnvironment env, HttpSignature httpSignature, InboundClientDefinition clientDefinition) {
        Optional<String> validationResult = httpSignature.validate(env, clientDefinition, this.inboundRequiredHeaders.getHeaders(env.getMethod(), env.getHeaders()));
        if (validationResult.isPresent()) {
            return AuthenticationResponse.failed((String)validationResult.get());
        }
        Principal principal = Principal.builder().name(clientDefinition.getPrincipalName()).addAttribute(ATTRIB_NAME_KEY_ID, (Object)clientDefinition.getKeyId()).build();
        Subject subject = Subject.builder().principal(principal).build();
        if (clientDefinition.getSubjectType() == SubjectType.USER) {
            return AuthenticationResponse.success((Subject)subject);
        }
        return AuthenticationResponse.successService((Subject)subject);
    }

    public boolean isOutboundSupported(ProviderRequest providerRequest, SecurityEnvironment outboundEnv, EndpointConfig outboundConfig) {
        return this.outboundConfig.findTarget(outboundEnv).isPresent();
    }

    public CompletionStage<OutboundSecurityResponse> outboundSecurity(ProviderRequest providerRequest, SecurityEnvironment outboundEnv, EndpointConfig outboundConfig) {
        return CompletableFuture.supplyAsync(() -> this.signRequest(outboundEnv), providerRequest.getContext().getExecutorService());
    }

    private OutboundSecurityResponse signRequest(SecurityEnvironment outboundEnv) {
        Optional targetOpt = this.outboundConfig.findTarget(outboundEnv);
        return targetOpt.map(target -> {
            OutboundTargetDefinition targetConfig = this.targetKeys.computeIfAbsent(target.getName(), key -> target.getConfig().flatMap(config -> config.get("signature").asOptional(OutboundTargetDefinition.class)).orElse((OutboundTargetDefinition)target.getCustomObject(OutboundTargetDefinition.class).orElseThrow(() -> new HttpSignatureException("Failed to find configuration for outbound signatures for target " + target.getName()))));
            TreeMap<String, List<String>> newHeaders = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            newHeaders.putAll(outboundEnv.getHeaders());
            HttpSignature signature = HttpSignature.sign(outboundEnv, targetConfig, newHeaders);
            OutboundSecurityResponse.Builder builder = (OutboundSecurityResponse.Builder)((OutboundSecurityResponse.Builder)OutboundSecurityResponse.builder().requestHeaders(newHeaders)).status(SecurityResponse.SecurityStatus.SUCCESS);
            switch (targetConfig.getHeader()) {
                case SIGNATURE: {
                    builder.requestHeader("Signature", signature.toSignatureHeader());
                    break;
                }
                case AUTHORIZATION: {
                    builder.requestHeader("Authorization", "Signature " + signature.toSignatureHeader());
                    break;
                }
                default: {
                    throw new HttpSignatureException("Invalid header configuration: " + (Object)((Object)targetConfig.getHeader()));
                }
            }
            Map headers = outboundEnv.getHeaders();
            if (headers.containsKey("host")) {
                builder.requestHeader("host", (List)headers.get("host"));
            }
            if (headers.containsKey("date")) {
                builder.requestHeader("date", (List)headers.get("date"));
            }
            return builder.build();
        }).orElse(OutboundSecurityResponse.empty());
    }

    public static class Builder
    implements io.helidon.common.Builder<HttpSignProvider> {
        private boolean optional = true;
        private String realm = "prime";
        private final Set<HttpSignHeader> acceptHeaders = EnumSet.noneOf(HttpSignHeader.class);
        private SignedHeadersConfig inboundRequiredHeaders = SignedHeadersConfig.builder().build();
        private OutboundConfig outboundConfig = OutboundConfig.builder().build();
        private final Map<String, InboundClientDefinition> inboundKeys = new HashMap<String, InboundClientDefinition>();

        public HttpSignProvider build() {
            return new HttpSignProvider(this);
        }

        public Builder fromConfig(Config config) {
            this.acceptHeaders.addAll(config.get("headers").asList(HttpSignHeader.class, CollectionsHelper.listOf()));
            this.optional = config.get("optional").asBoolean(false);
            this.realm = config.get("realm").asString("prime");
            this.inboundRequiredHeaders = (SignedHeadersConfig)config.get("sign-headers").as(SignedHeadersConfig.class, (Object)DEFAULT_REQUIRED_HEADERS);
            this.outboundConfig = OutboundConfig.parseTargets((Config)config);
            config.get("inbound.keys").asList(InboundClientDefinition.class, CollectionsHelper.listOf()).forEach(inbound -> this.inboundKeys.put(inbound.getKeyId(), (InboundClientDefinition)inbound));
            return this;
        }

        public Builder outbound(OutboundConfig targets) {
            this.outboundConfig = targets;
            return this;
        }

        public Builder addInbound(InboundClientDefinition client) {
            this.inboundKeys.put(client.getKeyId(), client);
            return this;
        }

        public Builder inboundRequiredHeaders(SignedHeadersConfig inboundRequiredHeaders) {
            this.inboundRequiredHeaders = inboundRequiredHeaders;
            return this;
        }

        public Builder addAcceptHeader(HttpSignHeader header) {
            this.acceptHeaders.add(header);
            return this;
        }

        public Builder optional(boolean optional) {
            this.optional = optional;
            return this;
        }

        public Builder realm(String realm) {
            this.realm = realm;
            return this;
        }
    }
}

