/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.provider.httpsign;

import io.helidon.common.CollectionsHelper;
import io.helidon.common.OptionalHelper;
import io.helidon.config.Config;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

public class SignedHeadersConfig {
    public static final String REQUEST_TARGET = "(request-target)";
    private final HeadersConfig defaultConfig;
    private final Map<String, HeadersConfig> methodConfigs;

    private SignedHeadersConfig(Builder builder) {
        this.defaultConfig = builder.defaultConfig;
        this.methodConfigs = new TreeMap<String, HeadersConfig>(String.CASE_INSENSITIVE_ORDER);
        this.methodConfigs.putAll(builder.methodConfigs);
    }

    public static SignedHeadersConfig fromConfig(Config config) {
        Builder builder = SignedHeadersConfig.builder();
        config.asNodeList().forEach(methodConfig -> {
            HeadersConfig mc = HeadersConfig.fromConfig(methodConfig);
            OptionalHelper.from((Optional)methodConfig.get("method").value()).ifPresentOrElse(method -> builder.config((String)method, mc), () -> builder.defaultConfig(mc));
        });
        return builder.build();
    }

    public static Builder builder() {
        return new Builder().defaultConfig(HeadersConfig.create());
    }

    List<String> getHeaders(String method, Map<String, List<String>> transportHeaders) {
        return this.methodConfigs.getOrDefault(method, this.defaultConfig).getHeaders(transportHeaders);
    }

    List<String> getHeaders(String method) {
        return new ArrayList<String>(this.methodConfigs.getOrDefault(method, this.defaultConfig).always);
    }

    public static class HeadersConfig {
        private final List<String> always;
        private final List<String> ifPresent;

        private HeadersConfig(List<String> requiredHeaders, List<String> ifPresentHeaders) {
            this.always = new ArrayList<String>(requiredHeaders);
            this.ifPresent = new LinkedList<String>(ifPresentHeaders);
        }

        public static HeadersConfig create() {
            return HeadersConfig.create(CollectionsHelper.listOf());
        }

        public static HeadersConfig create(List<String> requiredHeaders) {
            return HeadersConfig.create(requiredHeaders, CollectionsHelper.listOf());
        }

        public static HeadersConfig create(List<String> requiredHeaders, List<String> ifPresentHeaders) {
            return new HeadersConfig(requiredHeaders, ifPresentHeaders);
        }

        public static HeadersConfig fromConfig(Config config) {
            return HeadersConfig.create(config.get("always").asStringList(CollectionsHelper.listOf()), config.get("if-present").asStringList(CollectionsHelper.listOf()));
        }

        List<String> getHeaders(Map<String, List<String>> transportHeaders) {
            ArrayList<String> result = new ArrayList<String>(this.always);
            this.ifPresent.stream().filter(transportHeaders::containsKey).forEach(result::add);
            return result;
        }
    }

    public static class Builder
    implements io.helidon.common.Builder<SignedHeadersConfig> {
        private static final HeadersConfig DEFAULT_HEADERS = HeadersConfig.create(CollectionsHelper.listOf((Object[])new String[]{"date"}));
        private final Map<String, HeadersConfig> methodConfigs = new TreeMap<String, HeadersConfig>(String.CASE_INSENSITIVE_ORDER);
        private HeadersConfig defaultConfig = DEFAULT_HEADERS;

        private Builder() {
        }

        public SignedHeadersConfig build() {
            return new SignedHeadersConfig(this);
        }

        public Builder defaultConfig(HeadersConfig config) {
            this.defaultConfig = config;
            return this;
        }

        public Builder config(String method, HeadersConfig config) {
            this.methodConfigs.put(method, config);
            return this;
        }
    }
}

