/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.provider.httpauth;

import io.helidon.config.Config;
import java.util.Arrays;

public class HttpDigest {

    public static enum Qop {
        NONE("none"),
        AUTH("auth");

        private final String qop;

        private Qop(String qop) {
            this.qop = qop;
        }

        public static Qop fromConfig(Config config) {
            return Qop.fromString(config.asString());
        }

        static Qop fromString(String value) {
            if (null == value) {
                return NONE;
            }
            for (Qop qop : Qop.values()) {
                if (!qop.getQop().equals(value)) continue;
                return qop;
            }
            throw new IllegalArgumentException("Invalid QOP for digest: " + value + ", allowed: " + Arrays.toString((Object[])Qop.values()));
        }

        public String getQop() {
            return this.qop;
        }
    }

    public static enum Algorithm {
        MD5("MD5");

        private final String algorithm;

        private Algorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        public static Algorithm fromConfig(Config config) {
            return Algorithm.fromString(config.asString());
        }

        static Algorithm fromString(String value) {
            if (null == value) {
                return MD5;
            }
            for (Algorithm algorithm : Algorithm.values()) {
                if (!algorithm.getAlgorithm().equals(value)) continue;
                return algorithm;
            }
            throw new IllegalArgumentException("Invalid algorithm for digest: " + value + ", allowed: " + Arrays.toString((Object[])Algorithm.values()));
        }

        public String getAlgorithm() {
            return this.algorithm;
        }
    }
}

