/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.provider.httpauth;

import io.helidon.common.CollectionsHelper;
import io.helidon.common.OptionalHelper;
import io.helidon.config.Config;
import io.helidon.security.AuthenticationResponse;
import io.helidon.security.EndpointConfig;
import io.helidon.security.Grant;
import io.helidon.security.OutboundSecurityResponse;
import io.helidon.security.Principal;
import io.helidon.security.ProviderRequest;
import io.helidon.security.Role;
import io.helidon.security.SecurityContext;
import io.helidon.security.SecurityEnvironment;
import io.helidon.security.SecurityResponse;
import io.helidon.security.Subject;
import io.helidon.security.SubjectType;
import io.helidon.security.provider.httpauth.ConfigUserStore;
import io.helidon.security.provider.httpauth.HttpAuthException;
import io.helidon.security.provider.httpauth.UserStore;
import io.helidon.security.spi.AuthenticationProvider;
import io.helidon.security.spi.OutboundSecurityProvider;
import io.helidon.security.spi.SynchronousProvider;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpBasicAuthProvider
extends SynchronousProvider
implements AuthenticationProvider,
OutboundSecurityProvider {
    public static final String EP_PROPERTY_OUTBOUND_USER = "io.helidon.security.outbound.user";
    public static final String EP_PROPERTY_OUTBOUND_PASSWORD = "io.helidon.security.outbound.password";
    static final String HEADER_AUTHENTICATION_REQUIRED = "WWW-Authenticate";
    static final String HEADER_AUTHENTICATION = "authorization";
    static final String BASIC_PREFIX = "basic ";
    private static final Logger LOGGER = Logger.getLogger(HttpBasicAuthProvider.class.getName());
    private static final Pattern CREDENTIAL_PATTERN = Pattern.compile("(.*):(.*)");
    private static final char[] EMPTY_PASSWORD = new char[0];
    private final UserStore userStore;
    private final String realm;
    private final SubjectType subjectType;

    private HttpBasicAuthProvider(Builder builder) {
        this.userStore = builder.userStore;
        this.realm = builder.realm;
        this.subjectType = builder.subjectType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static HttpBasicAuthProvider fromConfig(Config config) {
        return Builder.fromConfig(config).build();
    }

    private static OutboundSecurityResponse toBasicAuthOutbound(UserStore.User user) {
        String b64 = Base64.getEncoder().encodeToString((user.getLogin() + ":" + new String(user.getPassword())).getBytes(StandardCharsets.UTF_8));
        String basicAuthB64 = BASIC_PREFIX + b64;
        return OutboundSecurityResponse.withHeaders((Map)CollectionsHelper.mapOf((Object)"Authorization", (Object)CollectionsHelper.listOf((Object[])new String[]{basicAuthB64})));
    }

    public boolean isOutboundSupported(ProviderRequest providerRequest, SecurityEnvironment outbondEnv, EndpointConfig outboundEp) {
        if (outboundEp.getAttributeNames().contains(EP_PROPERTY_OUTBOUND_USER)) {
            return true;
        }
        SecurityContext secContext = providerRequest.getContext();
        boolean userSupported = secContext.getUser().map(user -> user.getPrivateCredential(UserStore.User.class).isPresent()).orElse(false);
        boolean serviceSupported = secContext.getService().map(user -> user.getPrivateCredential(UserStore.User.class).isPresent()).orElse(false);
        return userSupported || serviceSupported;
    }

    protected OutboundSecurityResponse syncOutbound(ProviderRequest providerRequest, SecurityEnvironment outboundEnv, EndpointConfig outboundEp) {
        Optional maybeUsername = outboundEp.getAttribute(EP_PROPERTY_OUTBOUND_USER);
        if (maybeUsername.isPresent()) {
            String username = maybeUsername.get().toString();
            UserStore.User user2 = this.userStore.getUser(username).orElseGet(() -> this.userFromEndpoint(username, outboundEp));
            return HttpBasicAuthProvider.toBasicAuthOutbound(user2);
        }
        SecurityContext secContext = providerRequest.getContext();
        return OptionalHelper.from(secContext.getUser().flatMap(user -> user.getPrivateCredential(UserStore.User.class))).or(() -> secContext.getService().flatMap(service -> service.getPrivateCredential(UserStore.User.class))).asOptional().map(user -> {
            Optional password = outboundEp.getAttribute(EP_PROPERTY_OUTBOUND_PASSWORD);
            if (password.isPresent()) {
                return HttpBasicAuthProvider.toBasicAuthOutbound(new UserStore.User((UserStore.User)user, password){
                    final /* synthetic */ UserStore.User val$user;
                    final /* synthetic */ Optional val$password;
                    {
                        this.val$user = user;
                        this.val$password = optional;
                    }

                    @Override
                    public String getLogin() {
                        return this.val$user.getLogin();
                    }

                    @Override
                    public char[] getPassword() {
                        return this.val$password.map(String::valueOf).map(String::toCharArray).orElse(EMPTY_PASSWORD);
                    }
                });
            }
            return HttpBasicAuthProvider.toBasicAuthOutbound(user);
        }).orElseGet(OutboundSecurityResponse::abstain);
    }

    private UserStore.User userFromEndpoint(final String username, final EndpointConfig outboundEp) {
        return new UserStore.User(){

            @Override
            public String getLogin() {
                return username;
            }

            @Override
            public char[] getPassword() {
                return outboundEp.getAttribute(HttpBasicAuthProvider.EP_PROPERTY_OUTBOUND_PASSWORD).map(String::valueOf).map(String::toCharArray).orElse(EMPTY_PASSWORD);
            }
        };
    }

    protected AuthenticationResponse syncAuthenticate(ProviderRequest providerRequest) {
        Map headers = providerRequest.getEnv().getHeaders();
        List authorizationHeader = (List)headers.get(HEADER_AUTHENTICATION);
        if (null == authorizationHeader) {
            return this.fail("No authorization header");
        }
        return authorizationHeader.stream().filter(header -> header.toLowerCase().startsWith(BASIC_PREFIX)).findFirst().map(this::validateBasicAuth).orElseGet(() -> this.fail("Authorization header does not contain basic authentication: " + authorizationHeader));
    }

    private AuthenticationResponse validateBasicAuth(String basicAuthHeader) {
        String usernameAndPassword;
        String b64 = basicAuthHeader.substring(BASIC_PREFIX.length());
        try {
            usernameAndPassword = new String(Base64.getDecoder().decode(b64), StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException e) {
            return this.fail("Basic authentication header with invalid content - not base64 encoded");
        }
        Matcher matcher = CREDENTIAL_PATTERN.matcher(usernameAndPassword);
        if (!matcher.matches()) {
            LOGGER.finest(() -> "Basic authentication header with invalid content: " + usernameAndPassword);
            return this.fail("Basic authentication header with invalid content");
        }
        String username = matcher.group(1);
        char[] password = matcher.group(2).toCharArray();
        return this.userStore.getUser(username).map(user -> {
            if (Arrays.equals(password, user.getPassword())) {
                if (this.subjectType == SubjectType.USER) {
                    return AuthenticationResponse.success((Subject)this.buildSubject((UserStore.User)user));
                }
                return AuthenticationResponse.successService((Subject)this.buildSubject((UserStore.User)user));
            }
            return this.fail("Invalid username or password");
        }).orElse(this.fail("Invalid username or password"));
    }

    private AuthenticationResponse fail(String message) {
        return ((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)((AuthenticationResponse.Builder)AuthenticationResponse.builder().statusCode(401)).responseHeader(HEADER_AUTHENTICATION_REQUIRED, this.buildChallenge())).status(SecurityResponse.SecurityStatus.FAILURE)).description(message)).build();
    }

    private String buildChallenge() {
        return "Basic realm=\"" + this.realm + "\"";
    }

    private Subject buildSubject(UserStore.User user) {
        Subject.Builder builder = Subject.builder().principal(Principal.builder().name(user.getLogin()).build()).addPrivateCredential(UserStore.User.class, (Object)user);
        user.getRoles().forEach(role -> builder.addGrant((Grant)Role.create((String)role)));
        return builder.build();
    }

    public static class Builder
    implements io.helidon.common.Builder<HttpBasicAuthProvider> {
        private UserStore userStore;
        private String realm;
        private SubjectType subjectType = SubjectType.USER;

        private Builder() {
        }

        static Builder fromConfig(Config config) {
            Builder builder = new Builder();
            builder.realm(config.get("realm").asString("realm"));
            config.get("principal-type").asOptional(SubjectType.class).ifPresent(builder::subjectType);
            builder.userStore((UserStore)config.get("users").asOptional(ConfigUserStore.class).orElseThrow(() -> new HttpAuthException("No users configured! Key \"users\" must be in configuration")));
            return builder;
        }

        public HttpBasicAuthProvider build() {
            Objects.requireNonNull(this.userStore, "User store must be configured");
            return new HttpBasicAuthProvider(this);
        }

        public Builder subjectType(SubjectType subjectType) {
            this.subjectType = subjectType;
            switch (subjectType) {
                case USER: 
                case SERVICE: {
                    break;
                }
                default: {
                    throw new SecurityException("Invalid configuration. Principal type not supported: " + subjectType);
                }
            }
            return this;
        }

        public Builder userStore(UserStore store) {
            this.userStore = store;
            return this;
        }

        public Builder realm(String realm) {
            this.realm = realm;
            return this;
        }
    }
}

