/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.provider.httpauth;

import io.helidon.security.provider.httpauth.HttpAuthException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

final class HttpAuthUtil {
    private static final int SIZEOF_LONG = 8;

    private HttpAuthUtil() {
    }

    static long toLong(byte[] bytes, int offset, int length) {
        if (length != 8 || offset + length > bytes.length) {
            throw HttpAuthUtil.explainWrongLengthOrOffset(bytes, offset, length, 8);
        }
        long l = 0L;
        for (int i = offset; i < offset + length; ++i) {
            l <<= 8;
            l ^= (long)(bytes[i] & 0xFF);
        }
        return l;
    }

    static byte[] toBytes(long val) {
        byte[] b = new byte[8];
        for (int i = 7; i > 0; --i) {
            b[i] = (byte)val;
            val >>>= 8;
        }
        b[0] = (byte)val;
        return b;
    }

    static Cipher cipher(char[] masterPassword, byte[] salt, int cipherMode) throws HttpAuthException {
        try {
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            PBEKeySpec keySpec = new PBEKeySpec(masterPassword, salt, 10000, 128);
            SecretKeySpec spec = new SecretKeySpec(secretKeyFactory.generateSecret(keySpec).getEncoded(), "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(cipherMode, (Key)spec, new IvParameterSpec(salt));
            return cipher;
        }
        catch (Exception e) {
            throw new HttpAuthException("Failed to prepare a cipher instance", e);
        }
    }

    private static IllegalArgumentException explainWrongLengthOrOffset(byte[] bytes, int offset, int length, int expectedLength) {
        String reason = length != expectedLength ? "Wrong length: " + length + ", expected " + expectedLength : "offset (" + offset + ") + length (" + length + ") exceed the capacity of the array: " + bytes.length;
        return new IllegalArgumentException(reason);
    }
}

