/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.provider.httpauth;

import io.helidon.security.provider.httpauth.HttpAuthException;
import io.helidon.security.provider.httpauth.HttpDigest;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.logging.Logger;

class DigestToken {
    private static final Logger LOGGER = Logger.getLogger(DigestToken.class.getName());
    private static final char[] HEX_ARRAY = "0123456789abcdef".toCharArray();
    private String username;
    private String realm;
    private String uri;
    private HttpDigest.Algorithm algorithm;
    private String response;
    private String opaque;
    private HttpDigest.Qop qop;
    private String nc;
    private String cnonce;
    private String method;
    private String nonce;

    DigestToken() {
    }

    static DigestToken fromAuthorizationHeader(String header, String method) {
        String[] strings;
        HashMap<String, String> values = new HashMap<String, String>();
        for (String string : strings = header.split(",")) {
            int eq = string.indexOf(61);
            if (eq > 0) {
                String trimmed = string.trim();
                eq = trimmed.indexOf(61);
                String key = trimmed.substring(0, eq).trim();
                String value = DigestToken.unquote(trimmed.substring(eq + 1).trim());
                values.put(key, value);
                continue;
            }
            LOGGER.finest(() -> "Unrecognized digest header value: " + string);
        }
        DigestToken dt = new DigestToken();
        dt.username = (String)values.get("username");
        dt.realm = (String)values.get("realm");
        dt.uri = (String)values.get("uri");
        dt.algorithm = HttpDigest.Algorithm.fromString((String)values.get("algorithm"));
        dt.response = (String)values.get("response");
        dt.opaque = (String)values.get("opaque");
        dt.qop = HttpDigest.Qop.fromString((String)values.get("qop"));
        dt.method = method.toUpperCase();
        dt.nc = (String)values.get("nc");
        dt.cnonce = (String)values.get("cnonce");
        dt.nonce = (String)values.get("nonce");
        StringBuilder validationMessage = new StringBuilder();
        if (null == dt.username) {
            validationMessage.append("username is null, ");
        }
        if (null == dt.realm) {
            validationMessage.append("realm is null, ");
        }
        if (null == dt.uri) {
            validationMessage.append("uri is null, ");
        }
        if (null == dt.response) {
            validationMessage.append("response is null, ");
        }
        if (null == dt.opaque) {
            validationMessage.append("opaque is null, ");
        }
        if (null == dt.method) {
            validationMessage.append("method is null, ");
        }
        if (null == dt.nonce) {
            validationMessage.append("nonce is null, ");
        }
        if (dt.qop != HttpDigest.Qop.NONE) {
            if (null == dt.nc) {
                validationMessage.append("nc is null, ");
            }
            if (null == dt.cnonce) {
                validationMessage.append("cnonce is null, ");
            }
        }
        if (validationMessage.length() != 0) {
            throw new HttpAuthException("Validation of digest header failed: " + validationMessage.substring(0, validationMessage.length() - 2));
        }
        return dt;
    }

    private static String unquote(String string) {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    private static String md5(String data) {
        MessageDigest digest;
        byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("MD5 algorithm should be supported", e);
        }
        return DigestToken.bytesToHex(digest.digest(bytes));
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    String getUsername() {
        return this.username;
    }

    void setUsername(String username) {
        this.username = username;
    }

    String getRealm() {
        return this.realm;
    }

    void setRealm(String realm) {
        this.realm = realm;
    }

    String getUri() {
        return this.uri;
    }

    void setUri(String uri) {
        this.uri = uri;
    }

    HttpDigest.Algorithm getAlgorithm() {
        return this.algorithm;
    }

    void setAlgorithm(HttpDigest.Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    String getResponse() {
        return this.response;
    }

    void setResponse(String response) {
        this.response = response;
    }

    String getOpaque() {
        return this.opaque;
    }

    void setOpaque(String opaque) {
        this.opaque = opaque;
    }

    HttpDigest.Qop getQop() {
        return this.qop;
    }

    void setQop(HttpDigest.Qop qop) {
        this.qop = qop;
    }

    String getNc() {
        return this.nc;
    }

    void setNc(String nc) {
        this.nc = nc;
    }

    String getCnonce() {
        return this.cnonce;
    }

    void setCnonce(String cnonce) {
        this.cnonce = cnonce;
    }

    String getNonce() {
        return this.nonce;
    }

    void setNonce(String nonce) {
        this.nonce = nonce;
    }

    String getMethod() {
        return this.method;
    }

    void setMethod(String method) {
        this.method = method;
    }

    boolean validateLogin(char[] password) {
        String digest = this.digest(password);
        return digest.equals(this.response);
    }

    String digest(char[] password) {
        String ha1 = this.ha1(password);
        String ha2 = this.ha2();
        switch (this.qop) {
            case NONE: {
                return DigestToken.md5(ha1 + ":" + this.nonce + ":" + ha2);
            }
            case AUTH: {
                return DigestToken.md5(ha1 + ":" + this.nonce + ":" + this.nc + ":" + this.cnonce + ":" + this.qop.getQop() + ":" + ha2);
            }
        }
        throw new IllegalArgumentException("Only auth or no QOP are supported");
    }

    private String ha2() {
        return DigestToken.md5(this.a2());
    }

    private String ha1(char[] password) {
        switch (this.algorithm) {
            case MD5: {
                return DigestToken.md5(this.a1(password));
            }
        }
        throw new IllegalArgumentException("Only MD5 algorithm is supported");
    }

    private String a1(char[] password) {
        switch (this.algorithm) {
            case MD5: {
                return this.username + ":" + this.realm + ":" + new String(password);
            }
        }
        throw new IllegalArgumentException("Only MD5 algorithm is supported");
    }

    private String a2() {
        switch (this.qop) {
            case NONE: 
            case AUTH: {
                return this.method + ":" + this.uri;
            }
        }
        throw new IllegalArgumentException("Only auth or no QOP are supported");
    }

    public String toString() {
        return "DigestToken{username='" + this.username + '\'' + ", realm='" + this.realm + '\'' + ", uri='" + this.uri + '\'' + ", algorithm=" + (Object)((Object)this.algorithm) + ", response='" + this.response + '\'' + ", opaque='" + this.opaque + '\'' + ", qop=" + (Object)((Object)this.qop) + ", nc='" + this.nc + '\'' + ", cnonce='" + this.cnonce + '\'' + ", method='" + this.method + '\'' + ", nonce='" + this.nonce + '\'' + '}';
    }
}

