/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.provider.httpauth;

import io.helidon.common.CollectionsHelper;
import io.helidon.config.Config;
import io.helidon.security.provider.httpauth.UserStore;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ConfigUserStore
implements UserStore {
    private final Map<String, UserStore.User> users = new HashMap<String, UserStore.User>();

    public static ConfigUserStore fromConfig(Config config) {
        ConfigUserStore store = new ConfigUserStore();
        config.nodeList().ifPresent(configs -> configs.forEach(config1 -> {
            UserStore.User user = (UserStore.User)config1.map(ConfigUser::fromConfig);
            store.users.put(user.getLogin(), user);
        }));
        return store;
    }

    @Override
    public Optional<UserStore.User> getUser(String login) {
        return Optional.ofNullable(this.users.get(login));
    }

    private static class ConfigUser
    implements UserStore.User {
        private final Set<String> roles = new LinkedHashSet<String>();
        private String login;
        private char[] password;

        private ConfigUser() {
        }

        static ConfigUser fromConfig(Config config) {
            ConfigUser cu = new ConfigUser();
            cu.login = config.get("login").asString();
            cu.password = config.get("password").asString("").toCharArray();
            cu.roles.addAll(config.get("roles").asStringList(CollectionsHelper.listOf()));
            return cu;
        }

        @Override
        public String getLogin() {
            return this.login;
        }

        @Override
        public char[] getPassword() {
            return this.password;
        }

        public Set<String> getRoles() {
            return this.roles;
        }

        public String toString() {
            return "User info for \"" + this.login + "\"";
        }
    }
}

