/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.provider.header;

import io.helidon.config.Config;
import io.helidon.security.AuthenticationResponse;
import io.helidon.security.EndpointConfig;
import io.helidon.security.OutboundSecurityResponse;
import io.helidon.security.Principal;
import io.helidon.security.ProviderRequest;
import io.helidon.security.SecurityEnvironment;
import io.helidon.security.Subject;
import io.helidon.security.SubjectType;
import io.helidon.security.spi.AuthenticationProvider;
import io.helidon.security.spi.OutboundSecurityProvider;
import io.helidon.security.spi.SynchronousProvider;
import io.helidon.security.util.TokenHandler;
import java.util.HashMap;
import java.util.Optional;

public class HeaderAtnProvider
extends SynchronousProvider
implements AuthenticationProvider,
OutboundSecurityProvider {
    private final boolean optional;
    private final boolean authenticate;
    private final boolean propagate;
    private final SubjectType subjectType;
    private final TokenHandler atnTokenHandler;
    private final TokenHandler outboundTokenHandler;

    private HeaderAtnProvider(Builder builder) {
        this.optional = builder.optional;
        this.authenticate = builder.authenticate;
        this.propagate = builder.propagate;
        this.subjectType = builder.subjectType;
        this.atnTokenHandler = builder.atnTokenHandler;
        this.outboundTokenHandler = builder.outboundTokenHandler;
    }

    public static HeaderAtnProvider fromConfig(Config config) {
        return HeaderAtnProvider.builder().fromConfig(config).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    protected AuthenticationResponse syncAuthenticate(ProviderRequest providerRequest) {
        if (!this.authenticate) {
            return AuthenticationResponse.abstain();
        }
        Optional username = this.atnTokenHandler.extractToken(providerRequest.getEnv().getHeaders());
        return username.map(Principal::create).map(principal -> {
            if (this.subjectType == SubjectType.USER) {
                return AuthenticationResponse.success((Principal)principal);
            }
            return AuthenticationResponse.successService((Principal)principal);
        }).orElseGet(() -> {
            if (this.optional) {
                return AuthenticationResponse.abstain();
            }
            return AuthenticationResponse.failed((String)"Header not available or in a wrong format");
        });
    }

    public boolean isOutboundSupported(ProviderRequest providerRequest, SecurityEnvironment outboundEnv, EndpointConfig outboundConfig) {
        return this.propagate;
    }

    protected OutboundSecurityResponse syncOutbound(ProviderRequest providerRequest, SecurityEnvironment outboundEnv, EndpointConfig outboundEndpointConfig) {
        Optional toPropagate = this.subjectType == SubjectType.USER ? providerRequest.getContext().getUser() : providerRequest.getContext().getService();
        return toPropagate.map(Subject::getPrincipal).map(Principal::getId).map(id -> {
            HashMap headers = new HashMap();
            this.outboundTokenHandler.setHeader(headers, id);
            return OutboundSecurityResponse.withHeaders(headers);
        }).orElse(OutboundSecurityResponse.abstain());
    }

    public static class Builder
    implements io.helidon.common.Builder<HeaderAtnProvider> {
        private boolean optional = false;
        private boolean authenticate = true;
        private boolean propagate = true;
        private SubjectType subjectType = SubjectType.USER;
        private TokenHandler atnTokenHandler;
        private TokenHandler outboundTokenHandler;

        private Builder() {
        }

        public HeaderAtnProvider build() {
            if (null == this.outboundTokenHandler) {
                this.outboundTokenHandler = this.atnTokenHandler;
            }
            return new HeaderAtnProvider(this);
        }

        public Builder fromConfig(Config config) {
            config.get("optional").asOptional(Boolean.class).ifPresent(this::optional);
            config.get("authenticate").asOptional(Boolean.class).ifPresent(this::authenticate);
            config.get("propagate").asOptional(Boolean.class).ifPresent(this::propagate);
            config.get("principal-type").asOptional(SubjectType.class).ifPresent(this::subjectType);
            config.get("atn-token").asOptional(TokenHandler.class).ifPresent(this::atnTokenHandler);
            config.get("outbound-token").asOptional(TokenHandler.class).ifPresent(this::outboundTokenHandler);
            return this;
        }

        public Builder subjectType(SubjectType subjectType) {
            this.subjectType = subjectType;
            switch (subjectType) {
                case USER: 
                case SERVICE: {
                    break;
                }
                default: {
                    throw new SecurityException("Invalid configuration. Principal type not supported: " + subjectType);
                }
            }
            return this;
        }

        public Builder propagate(boolean propagate) {
            this.propagate = propagate;
            return this;
        }

        public Builder authenticate(boolean authenticate) {
            this.authenticate = authenticate;
            return this;
        }

        public Builder atnTokenHandler(TokenHandler tokenHandler) {
            this.atnTokenHandler = tokenHandler;
            return this;
        }

        public Builder outboundTokenHandler(TokenHandler tokenHandler) {
            this.outboundTokenHandler = tokenHandler;
            return this;
        }

        public Builder optional(boolean optional) {
            this.optional = optional;
            return this;
        }
    }
}

