/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.jwt.jwk;

import io.helidon.common.OptionalHelper;
import io.helidon.security.jwt.JwtException;
import io.helidon.security.jwt.JwtUtil;
import io.helidon.security.jwt.jwk.Jwk;
import java.io.ByteArrayInputStream;
import java.net.URI;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.JsonObject;

abstract class JwkPki
extends Jwk {
    public static final String PARAM_X509_CHAIN_URL = "x5u";
    public static final String PARAM_X509_CHAIN = "x5c";
    public static final String PARAM_X509_SHA_1 = "x5t";
    public static final String PARAM_X509_SHA_256 = "x5t#S256";
    private static final Logger LOGGER = Logger.getLogger(JwkPki.class.getName());
    private static final Base64.Decoder DECODER = Base64.getDecoder();
    private final Optional<PrivateKey> privateKey;
    private final PublicKey publicKey;
    private final Optional<List<X509Certificate>> certificateChain;
    private final Optional<byte[]> sha1Thumbprint;
    private final Optional<byte[]> sha256Thumbprint;

    JwkPki(Builder<?> builder, PrivateKey privKey, PublicKey pubKey, String defaultAlgorithm) {
        super(builder, defaultAlgorithm);
        this.privateKey = Optional.ofNullable(privKey);
        this.publicKey = pubKey;
        this.certificateChain = Optional.ofNullable(((Builder)builder).certificateChain).map(Collections::unmodifiableList);
        this.sha1Thumbprint = Optional.ofNullable(((Builder)builder).sha1Thumbprint);
        this.sha256Thumbprint = Optional.ofNullable(((Builder)builder).sha256Thumbprint);
    }

    public Optional<PrivateKey> getPrivateKey() {
        return this.privateKey;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public Optional<List<X509Certificate>> getCertificateChain() {
        return this.certificateChain;
    }

    public Optional<byte[]> getSha1Thumbprint() {
        return this.sha1Thumbprint;
    }

    public Optional<byte[]> getSha256Thumbprint() {
        return this.sha256Thumbprint;
    }

    abstract String getSignatureAlgorithm();

    @Override
    public boolean doVerify(byte[] signedBytes, byte[] signatureToVerify) {
        String alg = this.getSignatureAlgorithm();
        if ("none".equals(alg)) {
            return this.verifyNoneAlg(signatureToVerify);
        }
        Signature signature = JwtUtil.getSignature(alg);
        try {
            signature.initVerify(this.publicKey);
            signature.update(signedBytes);
            return signature.verify(signatureToVerify);
        }
        catch (Exception e) {
            throw new JwtException("Failed to verify signature. It may still be valid, but an exception was thrown", e);
        }
    }

    @Override
    public byte[] doSign(byte[] bytesToSign) {
        String alg = this.getSignatureAlgorithm();
        if ("none".equals(alg)) {
            return EMPTY_BYTES;
        }
        Signature signature = JwtUtil.getSignature(alg);
        try {
            PrivateKey privateKey = this.privateKey.orElseThrow(() -> new JwtException("To sign data, private key MUST be present"));
            signature.initSign(privateKey);
            signature.update(bytesToSign);
            return signature.sign();
        }
        catch (Exception e) {
            throw new JwtException("Failed to sign data", e);
        }
    }

    static class Builder<T extends Builder>
    extends Jwk.Builder<T> {
        private T myInstance = this;
        private List<X509Certificate> certificateChain;
        private byte[] sha1Thumbprint;
        private byte[] sha256Thumbprint;

        Builder() {
        }

        private static List<X509Certificate> processCertChain(List<String> base64s) {
            CertificateFactory cf;
            LinkedList<X509Certificate> certs = new LinkedList<X509Certificate>();
            try {
                cf = CertificateFactory.getInstance("X.509");
            }
            catch (CertificateException e) {
                throw new JwtException("Failed to get certificate factory. This is JVM misconfiguration", e);
            }
            base64s.forEach(it -> {
                byte[] rawBytes = DECODER.decode((String)it);
                try {
                    X509Certificate certificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(rawBytes));
                    certs.add(certificate);
                }
                catch (CertificateException e) {
                    throw new JwtException("Failed to read certificate from JWK", e);
                }
            });
            return certs;
        }

        private static List<X509Certificate> processCertChain(URI uri) {
            LOGGER.log(Level.SEVERE, "Certificate chain from URL is not (yet) supported");
            return new LinkedList<X509Certificate>();
        }

        public T certificateChain(List<X509Certificate> chain) {
            if (null == this.certificateChain) {
                this.certificateChain = new LinkedList<X509Certificate>();
            } else {
                this.certificateChain.clear();
            }
            this.certificateChain.addAll(chain);
            return this.myInstance;
        }

        public T addCertificateChain(X509Certificate cert) {
            if (null == this.certificateChain) {
                this.certificateChain = new LinkedList<X509Certificate>();
            }
            this.certificateChain.add(cert);
            return this.myInstance;
        }

        public T sha1Thumbprint(byte[] thumbprint) {
            this.sha1Thumbprint = thumbprint;
            return this.myInstance;
        }

        public T sha256Thumbprint(byte[] thumbprint) {
            this.sha256Thumbprint = thumbprint;
            return this.myInstance;
        }

        @Override
        T fromJson(JsonObject json) {
            super.fromJson(json);
            OptionalHelper.from(JwtUtil.getString(json, JwkPki.PARAM_X509_CHAIN_URL).map(URI::create).map(Builder::processCertChain)).or(() -> JwtUtil.getStrings(json, JwkPki.PARAM_X509_CHAIN).map(Builder::processCertChain)).asOptional().ifPresent(this::certificateChain);
            this.sha1Thumbprint = JwtUtil.getByteArray(json, JwkPki.PARAM_X509_SHA_1, "SHA-1 Certificate Thumbprint").orElse(null);
            this.sha256Thumbprint = JwtUtil.getByteArray(json, JwkPki.PARAM_X509_SHA_256, "SHA-256 Certificate Thumbprint").orElse(null);
            return this.myInstance;
        }
    }
}

