/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.jwt.jwk;

import io.helidon.security.jwt.JwtException;
import io.helidon.security.jwt.JwtUtil;
import io.helidon.security.jwt.jwk.Jwk;
import java.security.InvalidKeyException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.json.JsonObject;

public class JwkOctet
extends Jwk {
    public static final String ALG_HS256 = "HS256";
    public static final String ALG_HS384 = "HS384";
    public static final String ALG_HS512 = "HS512";
    public static final String PARAM_OCTET_KEY = "k";
    private static final Map<String, String> ALG_MAP = new HashMap<String, String>();
    private final byte[] keyBytes;

    private JwkOctet(Builder builder) {
        super(builder, ALG_HS256);
        this.keyBytes = builder.key;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static JwkOctet fromJson(JsonObject json) {
        return JwkOctet.builder().fromJson(json).build();
    }

    public byte[] getKeyBytes() {
        return Arrays.copyOf(this.keyBytes, this.keyBytes.length);
    }

    @Override
    public boolean doVerify(byte[] signedBytes, byte[] signature) {
        String alg = this.getSignatureAlgorithm();
        if ("none".equals(alg)) {
            return this.verifyNoneAlg(signature);
        }
        byte[] ourSignature = this.sign(signedBytes);
        return Arrays.equals(signature, ourSignature);
    }

    @Override
    public byte[] doSign(byte[] bytesToSign) {
        String alg = this.getSignatureAlgorithm();
        if ("none".equals(alg)) {
            return EMPTY_BYTES;
        }
        Mac mac = JwtUtil.getMac(alg);
        SecretKeySpec secretKey = new SecretKeySpec(this.keyBytes, alg);
        try {
            mac.init(secretKey);
        }
        catch (InvalidKeyException e) {
            throw new JwtException("Failed to init Mac for algorithm: " + alg, e);
        }
        return mac.doFinal(bytesToSign);
    }

    private String getSignatureAlgorithm() {
        String jwkAlg = this.getAlgorithm();
        String javaAlg = ALG_MAP.get(this.getAlgorithm());
        if (null == javaAlg) {
            throw new JwtException("Unsupported algorithm for MAC: " + jwkAlg);
        }
        return javaAlg;
    }

    static {
        ALG_MAP.put(ALG_HS256, "HmacSHA256");
        ALG_MAP.put(ALG_HS384, "HmacSHA384");
        ALG_MAP.put(ALG_HS512, "HmacSHA512");
        ALG_MAP.put("none", "none");
    }

    public static final class Builder
    extends Jwk.Builder<Builder>
    implements io.helidon.common.Builder<JwkOctet> {
        private byte[] key;

        private Builder() {
        }

        @Override
        public Builder fromJson(JsonObject json) {
            super.fromJson(json);
            this.key = JwtUtil.asByteArray(json, JwkOctet.PARAM_OCTET_KEY, "Octet key");
            return this;
        }

        public JwkOctet build() {
            return new JwkOctet(this);
        }
    }
}

