/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.jwt.jwk;

import io.helidon.common.configurable.Resource;
import io.helidon.security.jwt.jwk.Jwk;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;

public class JwkKeys {
    private static final Logger LOGGER = Logger.getLogger(JwkKeys.class.getName());
    private final Map<String, Jwk> keyMap;

    private JwkKeys(Map<String, Jwk> keyMap) {
        this.keyMap = keyMap;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<Jwk> forKeyId(String keyId) {
        return Optional.ofNullable(this.keyMap.get(keyId));
    }

    public static class Builder
    implements io.helidon.common.Builder<JwkKeys> {
        private Map<String, Jwk> keyMap = new HashMap<String, Jwk>();

        public JwkKeys build() {
            return new JwkKeys(new HashMap<String, Jwk>(this.keyMap));
        }

        public Builder addKey(Jwk key) {
            Objects.requireNonNull(key, "Key must not be null");
            Objects.requireNonNull(key.getKeyId(), "Key id must not be null for key: " + key);
            this.keyMap.put(key.getKeyId(), key);
            return this;
        }

        public Builder resource(Resource resource) {
            Objects.requireNonNull(resource, "Json resource must not be null");
            try (InputStream is = resource.getStream();){
                JsonObject jsonObject = Json.createReader((InputStream)is).readObject();
                this.addKeys(jsonObject);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to close input stream on resource: " + resource);
            }
            return this;
        }

        private void addKeys(JsonObject jsonObject) {
            JsonArray keyArray = jsonObject.getJsonArray("keys");
            keyArray.forEach(it -> {
                JsonObject aKey = (JsonObject)it;
                this.addKey(Jwk.fromJson(aKey));
            });
        }
    }
}

