/*
 * Copyright (c) 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * JWT (JSON web token) support.
 * Classes in this package allow you to process and validate JWT.
 *
 * <p>
 * Standards used:
 * <ul>
 * <li>JSON Web Token (JWT): <a href="https://tools.ietf.org/html/rfc7519">RFC 7519</a></li>
 * <li>JSON Web Key (JWK): <a href="https://tools.ietf.org/html/rfc7517">RFC 7517</a></li>
 * <li>JSON Web Algorithms (JWA): <a href="https://tools.ietf.org/html/rfc7518">RFC 7518</a></li>
 * </ul>
 *
 * @see io.helidon.security.jwt.Jwt
 * @see io.helidon.security.jwt.jwk.Jwk
 */
package io.helidon.security.jwt;
