/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.webserver;

import io.helidon.common.CollectionsHelper;
import io.helidon.common.OptionalHelper;
import io.helidon.common.reactive.Flow;
import io.helidon.config.Config;
import io.helidon.security.AuditEvent;
import io.helidon.security.AuthenticationResponse;
import io.helidon.security.ClassToInstanceStore;
import io.helidon.security.Entity;
import io.helidon.security.QueryParamMapping;
import io.helidon.security.SecurityClientBuilder;
import io.helidon.security.SecurityContext;
import io.helidon.security.SecurityRequest;
import io.helidon.security.SecurityRequestBuilder;
import io.helidon.security.SecurityResponse;
import io.helidon.security.internal.SecurityAuditEvent;
import io.helidon.security.util.TokenHandler;
import io.helidon.webserver.Handler;
import io.helidon.webserver.Http;
import io.helidon.webserver.RequestChunk;
import io.helidon.webserver.ResponseChunk;
import io.helidon.webserver.ResponseHeaders;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SecurityHandler
implements Handler {
    private static final Logger LOGGER = Logger.getLogger(SecurityHandler.class.getName());
    private static final String KEY_ROLES_ALLOWED = "roles-allowed";
    private static final String KEY_AUTHENTICATOR = "authenticator";
    private static final String KEY_AUTHORIZER = "authorizer";
    private static final String KEY_AUTHENTICATE = "authenticate";
    private static final String KEY_AUTHENTICATION_OPTIONAL = "authentication-optional";
    private static final String KEY_AUTHORIZE = "authorize";
    private static final String KEY_AUDIT = "audit";
    private static final String KEY_AUDIT_EVENT_TYPE = "audit-event-type";
    private static final String KEY_AUDIT_MESSAGE_FORMAT = "audit-message-format";
    private static final String KEY_QUERY_PARAM_HANDLERS = "query-params";
    private static final String DEFAULT_AUDIT_EVENT_TYPE = "request";
    private static final String DEFAULT_AUDIT_MESSAGE_FORMAT = "%3$s %1$s \"%2$s\" %5$s %6$s requested by %4$s";
    private static final SecurityHandler DEFAULT_INSTANCE = SecurityHandler.builder().build();
    private final Optional<Set<String>> rolesAllowed;
    private final Optional<ClassToInstanceStore<Object>> customObjects;
    private final Optional<Config> config;
    private final Optional<String> explicitAuthenticator;
    private final Optional<String> explicitAuthorizer;
    private final Optional<Boolean> authenticate;
    private final Optional<Boolean> authenticationOptional;
    private final Optional<Boolean> authorize;
    private final Optional<Boolean> audited;
    private final Optional<String> auditEventType;
    private final Optional<String> auditMessageFormat;
    private final List<QueryParamHandler> queryParamHandlers = new LinkedList<QueryParamHandler>();
    private final boolean combined;
    private final Map<String, Config> configMap = new HashMap<String, Config>();
    private final AtomicReference<SecurityHandler> combinedHandler = new AtomicReference();

    private SecurityHandler(Builder builder) {
        this.rolesAllowed = builder.rolesAllowed.flatMap(strings -> {
            HashSet newRoles = new HashSet(strings);
            return Optional.of(newRoles);
        });
        this.customObjects = builder.customObjects.flatMap(store -> {
            ClassToInstanceStore ctis = new ClassToInstanceStore();
            ctis.putAll(store);
            return Optional.of(ctis);
        });
        this.config = builder.config;
        this.explicitAuthenticator = builder.explicitAuthenticator;
        this.explicitAuthorizer = builder.explicitAuthorizer;
        this.authenticate = builder.authenticate;
        this.authenticationOptional = builder.authenticationOptional;
        this.audited = builder.audited;
        this.auditEventType = builder.auditEventType;
        this.auditMessageFormat = builder.auditMessageFormat;
        this.authorize = builder.authorize;
        this.combined = builder.combined;
        this.queryParamHandlers.addAll(builder.queryParamHandlers);
        this.config.ifPresent(conf -> conf.asNodeList().forEach(node -> this.configMap.put(node.name(), (Config)node)));
    }

    static SecurityHandler from(Config config, SecurityHandler defaults) {
        Builder builder = SecurityHandler.builder(defaults);
        OptionalHelper.from((Optional)config.get(KEY_ROLES_ALLOWED).asOptionalList(String.class)).ifPresentOrElse(builder::rolesAllowed, () -> defaults.rolesAllowed.ifPresent(builder::rolesAllowed));
        if (config.exists()) {
            builder.config(config);
        }
        OptionalHelper.from((Optional)config.get(KEY_AUTHENTICATOR).value()).or(() -> defaults.explicitAuthenticator).asOptional().ifPresent(builder::authenticator);
        OptionalHelper.from((Optional)config.get(KEY_AUTHORIZER).value()).or(() -> defaults.explicitAuthorizer).asOptional().ifPresent(builder::authorizer);
        OptionalHelper.from((Optional)config.get(KEY_AUTHENTICATE).asOptional(Boolean.class)).or(() -> defaults.authenticate).asOptional().ifPresent(builder::authenticate);
        OptionalHelper.from((Optional)config.get(KEY_AUTHENTICATION_OPTIONAL).asOptional(Boolean.class)).or(() -> defaults.authenticationOptional).asOptional().ifPresent(builder::authenticationOptional);
        OptionalHelper.from((Optional)config.get(KEY_AUDIT).asOptional(Boolean.class)).or(() -> defaults.audited).asOptional().ifPresent(builder::audit);
        OptionalHelper.from((Optional)config.get(KEY_AUTHORIZE).asOptional(Boolean.class)).or(() -> defaults.authorize).asOptional().ifPresent(builder::authorize);
        OptionalHelper.from((Optional)config.get(KEY_AUDIT_EVENT_TYPE).value()).or(() -> defaults.auditEventType).asOptional().ifPresent(builder::auditEventType);
        OptionalHelper.from((Optional)config.get(KEY_AUDIT_MESSAGE_FORMAT).value()).or(() -> defaults.auditMessageFormat).asOptional().ifPresent(builder::auditMessageFormat);
        config.get(KEY_QUERY_PARAM_HANDLERS).asOptionalList(QueryParamHandler.class).ifPresent(it -> it.forEach(builder::addQueryParamHandler));
        if (config.get(KEY_ROLES_ALLOWED).exists()) {
            if (!config.get(KEY_AUTHENTICATE).exists()) {
                builder.authenticate(true);
            }
            if (!config.get(KEY_AUTHORIZE).exists()) {
                builder.authorize(true);
            }
        }
        config.get(KEY_AUTHENTICATION_OPTIONAL).asOptional(Boolean.class).ifPresent(aBoolean -> {
            if (aBoolean.booleanValue() && !config.get(KEY_AUTHENTICATE).exists()) {
                builder.authenticate(true);
            }
        });
        config.get(KEY_AUTHENTICATOR).value().ifPresent(value -> {
            if (!config.get(KEY_AUTHENTICATE).exists()) {
                builder.authenticate(true);
            }
        });
        config.get(KEY_AUTHORIZER).value().ifPresent(value -> {
            if (!config.get(KEY_AUTHORIZE).exists()) {
                builder.authorize(true);
            }
        });
        return builder.build();
    }

    private static <T> void configure(Config config, String key, Optional<T> defaultValue, Consumer<T> builderMethod, Class<T> clazz) {
        OptionalHelper.from((Optional)config.get(key).asOptional(clazz)).or(() -> defaultValue).asOptional().ifPresent(builderMethod);
    }

    static SecurityHandler newInstance() {
        return DEFAULT_INSTANCE;
    }

    private static Builder builder() {
        return new Builder();
    }

    private static Builder builder(SecurityHandler toCopy) {
        return new Builder().configureFrom(toCopy);
    }

    static void traceError(Span span, Throwable throwable) {
        Tags.ERROR.set(span, Boolean.valueOf(true));
        span.log(CollectionsHelper.mapOf((Object)"event", (Object)"error", (Object)"error.object", (Object)throwable));
        span.finish();
    }

    void extractQueryParams(SecurityContext securityContext, ServerRequest req) {
        HashMap headers = new HashMap();
        this.queryParamHandlers.forEach(handler -> handler.extract(req, headers));
        securityContext.setEnv(securityContext.getEnv().derive().headers(headers).build());
    }

    public void accept(ServerRequest req, ServerResponse res) {
        SecurityContext securityContext = (SecurityContext)req.context().get(SecurityContext.class).orElseThrow(() -> new SecurityException("Security context not present. Maybe you forgot to Routing.builder().register(SecurityAdapter.from(security))..."));
        if (this.combined) {
            this.processSecurity(securityContext, req, res);
        } else {
            if (null == this.combinedHandler.get()) {
                SecurityHandler defaultHandler = req.context().get(SecurityHandler.class).orElse(DEFAULT_INSTANCE);
                if (defaultHandler == DEFAULT_INSTANCE) {
                    this.combinedHandler.set(this);
                } else {
                    this.combinedHandler.compareAndSet(null, SecurityHandler.builder(defaultHandler).configureFrom(this).combined().build());
                }
            }
            this.combinedHandler.get().processSecurity(securityContext, req, res);
        }
    }

    private void processSecurity(SecurityContext securityContext, ServerRequest req, ServerResponse res) {
        Tracer tracer = securityContext.getTracer();
        Span securitySpan = tracer.buildSpan("security").asChildOf(securityContext.getTracingSpan()).start();
        securitySpan.log(CollectionsHelper.mapOf((Object)"securityId", (Object)securityContext.getId()));
        this.extractQueryParams(securityContext, req);
        securityContext.setEndpointConfig(securityContext.getEndpointConfig().derive().configMap(this.configMap).customObjects(this.customObjects.orElse((ClassToInstanceStore<Object>)new ClassToInstanceStore())).build());
        this.processAuthentication(req, res, securityContext, tracer, securitySpan).thenCompose(atnResult -> {
            if (((AtxResult)atnResult).proceed) {
                return this.processAuthorization(req, res, securityContext, tracer, securitySpan);
            }
            return CompletableFuture.completedFuture(AtxResult.STOP);
        }).thenAccept(atzResult -> {
            if (((AtxResult)atzResult).proceed) {
                securitySpan.log("status: PROCEED");
                securitySpan.finish();
                req.next();
            } else {
                securitySpan.log("status: DENY");
                securitySpan.finish();
            }
        }).exceptionally(throwable -> {
            SecurityHandler.traceError(securitySpan, throwable);
            LOGGER.log(Level.SEVERE, "Unexpected exception during security processing", (Throwable)throwable);
            this.abortRequest(res, null, Http.Status.INTERNAL_SERVER_ERROR_500.code(), CollectionsHelper.mapOf());
            return null;
        });
        res.whenSent().thenAccept(sr -> this.processAudit(req, (ServerResponse)sr, securityContext));
    }

    private void processAudit(ServerRequest req, ServerResponse res, SecurityContext securityContext) {
        AuditEvent.AuditSeverity auditSeverity;
        if (!this.audited.orElse(true).booleanValue()) {
            return;
        }
        if (!this.audited.isPresent() && req.method() instanceof Http.Method) {
            switch ((Http.Method)req.method()) {
                case GET: 
                case HEAD: {
                    return;
                }
            }
        }
        switch (res.status().family()) {
            case INFORMATIONAL: 
            case SUCCESSFUL: 
            case REDIRECTION: {
                auditSeverity = AuditEvent.AuditSeverity.SUCCESS;
                break;
            }
            default: {
                auditSeverity = AuditEvent.AuditSeverity.FAILURE;
            }
        }
        SecurityAuditEvent auditEvent = SecurityAuditEvent.audit((AuditEvent.AuditSeverity)auditSeverity, (String)this.auditEventType.orElse(DEFAULT_AUDIT_EVENT_TYPE), (String)this.auditMessageFormat.orElse(DEFAULT_AUDIT_MESSAGE_FORMAT)).addParam(AuditEvent.AuditParam.plain((String)"method", (Object)req.method())).addParam(AuditEvent.AuditParam.plain((String)"path", (Object)req.path())).addParam(AuditEvent.AuditParam.plain((String)"status", (Object)String.valueOf(res.status().code()))).addParam(AuditEvent.AuditParam.plain((String)"subject", (Object)securityContext.getUser().orElse(SecurityContext.ANONYMOUS))).addParam(AuditEvent.AuditParam.plain((String)"transport", (Object)"http")).addParam(AuditEvent.AuditParam.plain((String)"resourceType", (Object)"http")).addParam(AuditEvent.AuditParam.plain((String)"targetUri", (Object)req.uri()));
        securityContext.getService().ifPresent(svc -> auditEvent.addParam(AuditEvent.AuditParam.plain((String)"service", (Object)svc.toString())));
        securityContext.audit((AuditEvent)auditEvent);
    }

    private CompletionStage<AtxResult> processAuthentication(ServerRequest req, ServerResponse res, SecurityContext securityContext, Tracer tracer, Span securitySpan) {
        if (!this.authenticate.orElse(false).booleanValue()) {
            return CompletableFuture.completedFuture(AtxResult.PROCEED);
        }
        CompletableFuture<AtxResult> future = new CompletableFuture<AtxResult>();
        Span atnSpan = tracer.buildSpan("security:atn").asChildOf(securitySpan).start();
        SecurityClientBuilder clientBuilder = securityContext.atnClientBuilder();
        this.configureSecurityRequest((SecurityRequestBuilder<? extends SecurityRequestBuilder<?>>)clientBuilder, req, res, atnSpan);
        ((SecurityClientBuilder)clientBuilder.explicitProvider((String)this.explicitAuthenticator.orElse(null))).submit().thenAccept(response -> {
            switch (response.getStatus()) {
                case SUCCESS: {
                    break;
                }
                case FAILURE_FINISH: {
                    if (!this.atnFinishFailure(res, future, (AuthenticationResponse)response)) break;
                    this.atnSpanFinish(atnSpan, (AuthenticationResponse)response);
                    return;
                }
                case SUCCESS_FINISH: {
                    this.atnFinish(res, future, (AuthenticationResponse)response);
                    this.atnSpanFinish(atnSpan, (AuthenticationResponse)response);
                    return;
                }
                case ABSTAIN: 
                case FAILURE: {
                    if (!this.atnAbstainFailure(res, future, (AuthenticationResponse)response)) break;
                    this.atnSpanFinish(atnSpan, (AuthenticationResponse)response);
                    return;
                }
                default: {
                    SecurityException e = new SecurityException("Invalid SecurityStatus returned: " + response.getStatus());
                    future.completeExceptionally(e);
                    SecurityHandler.traceError(atnSpan, e);
                    return;
                }
            }
            this.atnSpanFinish(atnSpan, (AuthenticationResponse)response);
            future.complete(new AtxResult(clientBuilder.buildRequest()));
        }).exceptionally(throwable -> {
            SecurityHandler.traceError(atnSpan, throwable);
            future.completeExceptionally((Throwable)throwable);
            return null;
        });
        return future;
    }

    private void atnSpanFinish(Span atnSpan, AuthenticationResponse response) {
        response.getUser().ifPresent(subject -> atnSpan.log("security.user: " + subject.getPrincipal().getName()));
        response.getService().ifPresent(subject -> atnSpan.log("security.service: " + subject.getPrincipal().getName()));
        atnSpan.log("status: " + response.getStatus());
        atnSpan.finish();
    }

    private boolean atnAbstainFailure(ServerResponse res, CompletableFuture<AtxResult> future, AuthenticationResponse response) {
        if (this.authenticationOptional.orElse(false).booleanValue()) {
            LOGGER.finest("Authentication failed, but was optional, so assuming anonymous");
            return false;
        }
        this.abortRequest(res, (SecurityResponse)response, Http.Status.UNAUTHORIZED_401.code(), CollectionsHelper.mapOf((Object)"WWW-Authenticate", (Object)CollectionsHelper.listOf((Object[])new String[]{"Basic realm=\"Security Realm\""})));
        future.complete(AtxResult.STOP);
        return true;
    }

    private boolean atnFinishFailure(ServerResponse res, CompletableFuture<AtxResult> future, AuthenticationResponse response) {
        if (this.authenticationOptional.orElse(false).booleanValue()) {
            LOGGER.finest("Authentication failed, but was optional, so assuming anonymous");
            return false;
        }
        int defaultStatusCode = Http.Status.UNAUTHORIZED_401.code();
        this.abortRequest(res, (SecurityResponse)response, defaultStatusCode, CollectionsHelper.mapOf());
        future.complete(AtxResult.STOP);
        return true;
    }

    private void atnFinish(ServerResponse res, CompletableFuture<AtxResult> future, AuthenticationResponse response) {
        int defaultStatusCode = Http.Status.OK_200.code();
        this.abortRequest(res, (SecurityResponse)response, defaultStatusCode, CollectionsHelper.mapOf());
        future.complete(AtxResult.STOP);
    }

    private void abortRequest(ServerResponse res, SecurityResponse response, int defaultCode, Map<String, List<String>> defaultHeaders) {
        int statusCode = null == response ? defaultCode : response.getStatusCode().orElse(defaultCode);
        Map responseHeaders = null == response ? defaultHeaders : response.getResponseHeaders();
        responseHeaders = responseHeaders.isEmpty() ? defaultHeaders : responseHeaders;
        ResponseHeaders httpHeaders = res.headers();
        for (Map.Entry entry : responseHeaders.entrySet()) {
            httpHeaders.put((String)entry.getKey(), (Iterable)entry.getValue());
        }
        res.status(statusCode);
        res.send();
    }

    private void configureSecurityRequest(SecurityRequestBuilder<? extends SecurityRequestBuilder<?>> request, ServerRequest req, ServerResponse res, Span parentSpan) {
        request.optional(this.authenticationOptional.orElse(false).booleanValue()).tracingSpan(parentSpan).requestMessage(this.toRequestMessage(req)).responseMessage(this.toResponseMessage(res));
    }

    private Entity toResponseMessage(ServerResponse res) {
        return filterFunction -> res.registerFilter(responseChunkPublisher -> {
            ResponseProcessor<ResponseChunk, ByteBuffer> bytesFromBizLogic = new ResponseProcessor<ResponseChunk, ByteBuffer>(responseChunkPublisher){

                public void onNext(ResponseChunk item) {
                    this.getSubscriber().onNext((Object)item.data());
                }
            };
            Flow.Publisher securedBytes = (Flow.Publisher)filterFunction.apply(bytesFromBizLogic);
            return new ResponseProcessor<ByteBuffer, ResponseChunk>(securedBytes){

                public void onNext(ByteBuffer item) {
                    this.getSubscriber().onNext((Object)new ResponseChunk(true, item));
                }
            };
        });
    }

    private Entity toRequestMessage(ServerRequest req) {
        return filterFunction -> req.content().registerFilter(requestChunkPublisher -> {
            ResponseProcessor<RequestChunk, ByteBuffer> bytesFromExternal = new ResponseProcessor<RequestChunk, ByteBuffer>(requestChunkPublisher){

                public void onNext(RequestChunk item) {
                    this.getSubscriber().onNext((Object)item.data());
                }
            };
            Flow.Publisher securedBytes = (Flow.Publisher)filterFunction.apply(bytesFromExternal);
            return new ResponseProcessor<ByteBuffer, RequestChunk>(securedBytes){

                public void onNext(ByteBuffer item) {
                    this.getSubscriber().onNext((Object)RequestChunk.from((ByteBuffer)item));
                }
            };
        });
    }

    private CompletionStage<AtxResult> processAuthorization(ServerRequest req, ServerResponse res, SecurityContext context, Tracer tracer, Span securitySpan) {
        CompletableFuture<AtxResult> future = new CompletableFuture<AtxResult>();
        if (!this.authorize.orElse(false).booleanValue()) {
            future.complete(AtxResult.PROCEED);
            return future;
        }
        Span atzSpan = tracer.buildSpan("security:atz").asChildOf(securitySpan).start();
        Set<String> rolesSet = this.rolesAllowed.orElse(CollectionsHelper.setOf());
        if (!rolesSet.isEmpty()) {
            if (this.explicitAuthorizer.isPresent()) {
                if (rolesSet.stream().noneMatch(role -> context.isUserInRole(role, this.explicitAuthorizer.get()))) {
                    this.abortRequest(res, null, Http.Status.FORBIDDEN_403.code(), CollectionsHelper.mapOf());
                    future.complete(AtxResult.STOP);
                    atzSpan.finish();
                    return future;
                }
            } else if (rolesSet.stream().noneMatch(arg_0 -> ((SecurityContext)context).isUserInRole(arg_0))) {
                this.abortRequest(res, null, Http.Status.FORBIDDEN_403.code(), CollectionsHelper.mapOf());
                future.complete(AtxResult.STOP);
                atzSpan.finish();
                return future;
            }
        }
        SecurityClientBuilder client = context.atzClientBuilder();
        this.configureSecurityRequest((SecurityRequestBuilder<? extends SecurityRequestBuilder<?>>)client, req, res, atzSpan);
        ((SecurityClientBuilder)client.explicitProvider((String)this.explicitAuthorizer.orElse(null))).submit().thenAccept(response -> {
            switch (response.getStatus()) {
                case SUCCESS: {
                    break;
                }
                case FAILURE_FINISH: 
                case SUCCESS_FINISH: {
                    int defaultStatus = response.getStatus() == SecurityResponse.SecurityStatus.FAILURE_FINISH ? Http.Status.FORBIDDEN_403.code() : Http.Status.OK_200.code();
                    atzSpan.finish();
                    this.abortRequest(res, (SecurityResponse)response, defaultStatus, CollectionsHelper.mapOf());
                    future.complete(AtxResult.STOP);
                    return;
                }
                case ABSTAIN: 
                case FAILURE: {
                    atzSpan.finish();
                    this.abortRequest(res, (SecurityResponse)response, Http.Status.FORBIDDEN_403.code(), CollectionsHelper.mapOf());
                    future.complete(AtxResult.STOP);
                    return;
                }
                default: {
                    SecurityException e = new SecurityException("Invalid SecurityStatus returned: " + response.getStatus());
                    SecurityHandler.traceError(atzSpan, e);
                    future.completeExceptionally(e);
                    return;
                }
            }
            atzSpan.finish();
            future.complete(AtxResult.PROCEED);
        }).exceptionally(throwable -> {
            SecurityHandler.traceError(atzSpan, throwable);
            future.completeExceptionally((Throwable)throwable);
            return null;
        });
        return future;
    }

    public List<QueryParamHandler> getQueryParamHandlers() {
        return Collections.unmodifiableList(this.queryParamHandlers);
    }

    public SecurityHandler authenticator(String explicitAuthenticator) {
        return SecurityHandler.builder(this).authenticator(explicitAuthenticator).build();
    }

    public SecurityHandler authorizer(String explicitAuthorizer) {
        return SecurityHandler.builder(this).authorizer(explicitAuthorizer).build();
    }

    public SecurityHandler rolesAllowed(String ... roles) {
        return SecurityHandler.builder(this).rolesAllowed(roles).authorize(true).authenticate(true).build();
    }

    public SecurityHandler authenticationOptional() {
        return SecurityHandler.builder(this).authenticationOptional(true).build();
    }

    public SecurityHandler authenticate() {
        return SecurityHandler.builder(this).authenticate(true).build();
    }

    public SecurityHandler skipAuthentication() {
        return SecurityHandler.builder(this).authenticate(false).build();
    }

    public SecurityHandler customObject(Object object) {
        return SecurityHandler.builder(this).customObject(object).build();
    }

    public SecurityHandler auditEventType(String eventType) {
        return SecurityHandler.builder(this).auditEventType(eventType).build();
    }

    public SecurityHandler auditMessageFormat(String messageFormat) {
        return SecurityHandler.builder(this).auditMessageFormat(messageFormat).build();
    }

    public SecurityHandler authorize() {
        return SecurityHandler.builder(this).authorize(true).build();
    }

    public SecurityHandler skipAuthorization() {
        return SecurityHandler.builder(this).authorize(false).build();
    }

    public SecurityHandler audit() {
        return SecurityHandler.builder(this).audit(true).build();
    }

    public SecurityHandler skipAudit() {
        return SecurityHandler.builder(this).audit(false).build();
    }

    public SecurityHandler queryParam(String queryParamName, TokenHandler headerHandler) {
        return SecurityHandler.builder(this).addQueryParamHandler(QueryParamHandler.from(queryParamName, headerHandler)).build();
    }

    public static final class QueryParamHandler {
        private final String queryParamName;
        private final TokenHandler headerHandler;

        private QueryParamHandler(QueryParamMapping mapping) {
            this.queryParamName = mapping.getQueryParamName();
            this.headerHandler = mapping.getTokenHandler();
        }

        public static QueryParamHandler from(Config config) {
            return QueryParamHandler.from(QueryParamMapping.from((Config)config));
        }

        public static QueryParamHandler from(QueryParamMapping mapping) {
            return new QueryParamHandler(mapping);
        }

        public static QueryParamHandler from(String queryParamName, TokenHandler headerHandler) {
            return QueryParamHandler.from(QueryParamMapping.create((String)queryParamName, (TokenHandler)headerHandler));
        }

        void extract(ServerRequest req, Map<String, List<String>> headers) {
            List values = req.queryParams().all(this.queryParamName);
            values.forEach(token -> {
                String tokenValue = this.headerHandler.extractToken(token);
                this.headerHandler.addHeader(headers, tokenValue);
            });
        }
    }

    private static final class Builder
    implements io.helidon.common.Builder<SecurityHandler> {
        private Optional<Set<String>> rolesAllowed = Optional.empty();
        private Optional<ClassToInstanceStore<Object>> customObjects = Optional.empty();
        private Optional<Config> config = Optional.empty();
        private Optional<String> explicitAuthenticator = Optional.empty();
        private Optional<String> explicitAuthorizer = Optional.empty();
        private Optional<Boolean> authenticate = Optional.empty();
        private Optional<Boolean> authenticationOptional = Optional.empty();
        private Optional<Boolean> authorize = Optional.empty();
        private Optional<Boolean> audited = Optional.empty();
        private Optional<String> auditEventType = Optional.empty();
        private Optional<String> auditMessageFormat = Optional.empty();
        private final List<QueryParamHandler> queryParamHandlers = new LinkedList<QueryParamHandler>();
        private boolean combined;

        private Builder() {
        }

        public SecurityHandler build() {
            return new SecurityHandler(this);
        }

        private Builder combined() {
            this.combined = true;
            return this;
        }

        private Builder configureFrom(SecurityHandler handler) {
            handler.rolesAllowed.ifPresent(this::rolesAllowed);
            handler.customObjects.ifPresent(this::customObjects);
            handler.config.ifPresent(this::config);
            handler.explicitAuthenticator.ifPresent(this::authenticator);
            handler.explicitAuthorizer.ifPresent(this::authorizer);
            handler.authenticate.ifPresent(this::authenticate);
            handler.authenticationOptional.ifPresent(this::authenticationOptional);
            handler.audited.ifPresent(this::audit);
            handler.auditEventType.ifPresent(this::auditEventType);
            handler.auditMessageFormat.ifPresent(this::auditMessageFormat);
            handler.authorize.ifPresent(this::authorize);
            this.queryParamHandlers.addAll(handler.getQueryParamHandlers());
            return this;
        }

        private Builder customObjects(ClassToInstanceStore<Object> store) {
            OptionalHelper.from(this.customObjects).ifPresentOrElse(myStore -> myStore.putAll(store), () -> {
                ClassToInstanceStore ctis = new ClassToInstanceStore();
                ctis.putAll(store);
                this.customObjects = Optional.of(ctis);
            });
            return this;
        }

        public Builder addQueryParamHandler(QueryParamHandler handler) {
            this.queryParamHandlers.add(handler);
            return this;
        }

        Builder authenticator(String explicitAuthenticator) {
            this.explicitAuthenticator = Optional.of(explicitAuthenticator);
            return this;
        }

        Builder authorizer(String explicitAuthorizer) {
            this.explicitAuthorizer = Optional.of(explicitAuthorizer);
            return this;
        }

        Builder rolesAllowed(String ... roles) {
            return this.rolesAllowed(Arrays.asList(roles));
        }

        private Builder config(Config config) {
            this.config = Optional.of(config);
            return this;
        }

        Builder authenticationOptional(boolean isOptional) {
            this.authenticationOptional = Optional.of(isOptional);
            return this;
        }

        Builder authenticate(boolean authenticate) {
            this.authenticate = Optional.of(authenticate);
            return this;
        }

        Builder customObject(Object object) {
            OptionalHelper.from(this.customObjects).ifPresentOrElse(store -> store.putInstance(object), () -> {
                ClassToInstanceStore ctis = new ClassToInstanceStore();
                ctis.putInstance(object);
                this.customObjects = Optional.of(ctis);
            });
            return this;
        }

        Builder auditEventType(String eventType) {
            this.auditEventType = Optional.of(eventType);
            return this;
        }

        Builder auditMessageFormat(String messageFormat) {
            this.auditMessageFormat = Optional.of(messageFormat);
            return this;
        }

        Builder authorize(boolean authorize) {
            this.authorize = Optional.of(authorize);
            return this;
        }

        Builder audit(boolean audited) {
            this.audited = Optional.of(audited);
            return this;
        }

        Builder rolesAllowed(Collection<String> roles) {
            OptionalHelper.from(this.rolesAllowed).ifPresentOrElse(strings -> strings.addAll(roles), () -> {
                HashSet newRoles = new HashSet(roles);
                this.rolesAllowed = Optional.of(newRoles);
            });
            return this;
        }
    }

    private static abstract class ResponseProcessor<T, R>
    implements Flow.Processor<T, R> {
        private final CountDownLatch subscribedLatch = new CountDownLatch(1);
        private final Flow.Publisher<T> externalPublisher;
        private final AtomicBoolean isSubscribed = new AtomicBoolean();
        private Flow.Subscriber<? super R> subscriber;
        private volatile Flow.Subscription mySubscription;
        private volatile Flow.Subscription subscribersSubscription;

        ResponseProcessor(Flow.Publisher<T> externalPublisher) {
            this.externalPublisher = externalPublisher;
        }

        public void subscribe(Flow.Subscriber<? super R> subscriber) {
            if (!this.isSubscribed.compareAndSet(false, true)) {
                subscriber.onError((Throwable)new IllegalStateException("This publisher only supports a single subscriber."));
                return;
            }
            this.subscriber = subscriber;
            this.subscribersSubscription = new Flow.Subscription(){

                public void request(long n) {
                    try {
                        subscribedLatch.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        mySubscription.cancel();
                        return;
                    }
                    mySubscription.request(n);
                }

                public void cancel() {
                    try {
                        subscribedLatch.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    mySubscription.cancel();
                }
            };
            this.externalPublisher.subscribe((Flow.Subscriber)this);
            subscriber.onSubscribe(this.subscribersSubscription);
        }

        public void onSubscribe(Flow.Subscription subscription) {
            this.mySubscription = subscription;
            this.subscribedLatch.countDown();
        }

        public void onError(Throwable throwable) {
            this.subscriber.onError(throwable);
        }

        public void onComplete() {
            this.subscriber.onComplete();
        }

        Flow.Subscriber<? super R> getSubscriber() {
            return this.subscriber;
        }
    }

    private static final class AtxResult {
        private static final AtxResult PROCEED = new AtxResult(true);
        private static final AtxResult STOP = new AtxResult(false);
        private final boolean proceed;

        private AtxResult(boolean proceed) {
            this.proceed = proceed;
        }

        private AtxResult(SecurityRequest ignored) {
            this.proceed = true;
        }
    }
}

