/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.scheduling;

import io.helidon.common.configurable.ScheduledThreadPoolConfig;
import io.helidon.common.configurable.ScheduledThreadPoolSupplier;
import io.helidon.scheduling.FixedRate;
import io.helidon.scheduling.FixedRateConfig;
import io.helidon.scheduling.FixedRateInvocation;
import io.helidon.scheduling.ScheduledConsumer;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

class FixedRateTask
implements FixedRate {
    private static final System.Logger LOGGER = System.getLogger(FixedRateTask.class.getName());
    private final AtomicLong iteration = new AtomicLong(0L);
    private final ScheduledExecutorService executorService;
    private final long initialDelay;
    private final long delay;
    private final TimeUnit timeUnit;
    private final ScheduledConsumer actualTask;
    private FixedRateConfig config = null;

    FixedRateTask(FixedRateConfig config) {
        this.config = config;
        this.initialDelay = config.initialDelay();
        this.delay = config.delay();
        this.timeUnit = config.timeUnit();
        this.actualTask = config.task();
        this.executorService = config.executor() == null ? ((ScheduledThreadPoolConfig.Builder)ScheduledThreadPoolSupplier.builder().threadNamePrefix("scheduled-")).build().get() : config.executor();
        switch (config.delayType()) {
            case SINCE_PREVIOUS_START: {
                this.executorService.scheduleAtFixedRate(this::run, this.initialDelay, this.delay, this.timeUnit);
                break;
            }
            case SINCE_PREVIOUS_END: {
                this.executorService.scheduleWithFixedDelay(this::run, this.initialDelay, this.delay, this.timeUnit);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected delay type " + String.valueOf((Object)config.delayType()));
            }
        }
    }

    public FixedRateConfig prototype() {
        return this.config;
    }

    @Override
    public String description() {
        String unit = this.timeUnit.toString().toLowerCase();
        if (this.initialDelay == 0L) {
            return String.format("every %s %s", this.delay, unit);
        }
        return String.format("every %s %s with initial delay %s %s", this.delay, unit, this.initialDelay, unit);
    }

    @Override
    public ScheduledExecutorService executor() {
        return this.executorService;
    }

    void run() {
        try {
            final long it = this.iteration.incrementAndGet();
            this.actualTask.run(new FixedRateInvocation(){

                @Override
                public long initialDelay() {
                    return FixedRateTask.this.initialDelay;
                }

                @Override
                public long delay() {
                    return FixedRateTask.this.delay;
                }

                @Override
                public TimeUnit timeUnit() {
                    return FixedRateTask.this.timeUnit;
                }

                @Override
                public long iteration() {
                    return it;
                }

                @Override
                public String description() {
                    return FixedRateTask.this.description();
                }
            });
        }
        catch (Throwable e) {
            LOGGER.log(System.Logger.Level.ERROR, () -> "Error when invoking scheduled method.", e);
        }
    }
}

