/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.scheduling;

import com.cronutils.descriptor.CronDescriptor;
import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import io.helidon.scheduling.CronInvocation;
import io.helidon.scheduling.ScheduledConsumer;
import io.helidon.scheduling.Task;
import java.time.ZonedDateTime;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;

class CronTask
implements Task {
    private static final System.Logger LOGGER = System.getLogger(CronTask.class.getName());
    private final AtomicLong iteration = new AtomicLong(0L);
    private final ExecutionTime executionTime;
    private final boolean concurrentExecution;
    private final ScheduledConsumer<CronInvocation> actualTask;
    private final ScheduledExecutorService executorService;
    private final Cron cron;
    private final ReentrantLock scheduleNextLock = new ReentrantLock();
    private ZonedDateTime lastNext = null;

    CronTask(ScheduledExecutorService executorService, String cronExpression, boolean concurrentExecution, ScheduledConsumer<CronInvocation> actualTask) {
        this.executorService = executorService;
        this.concurrentExecution = concurrentExecution;
        this.actualTask = actualTask;
        CronDefinition cronDefinition = CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ);
        CronParser parser = new CronParser(cronDefinition);
        this.cron = parser.parse(cronExpression);
        this.executionTime = ExecutionTime.forCron((Cron)this.cron);
        this.scheduleNext();
    }

    void run() {
        if (this.concurrentExecution) {
            this.scheduleNext();
        }
        try {
            final long it = this.iteration.incrementAndGet();
            this.actualTask.run(new CronInvocation(){

                @Override
                public String cron() {
                    return CronTask.this.cron.asString();
                }

                @Override
                public boolean concurrent() {
                    return CronTask.this.concurrentExecution;
                }

                @Override
                public long iteration() {
                    return it;
                }

                @Override
                public String description() {
                    return CronTask.this.description();
                }
            });
        }
        catch (Throwable e) {
            LOGGER.log(System.Logger.Level.ERROR, () -> "Error when invoking scheduled method.", e);
        }
        if (!this.concurrentExecution) {
            this.scheduleNext();
        }
    }

    @Override
    public String description() {
        return CronDescriptor.instance((Locale)Locale.ENGLISH).describe(this.cron);
    }

    @Override
    public ScheduledExecutorService executor() {
        return this.executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleNext() {
        try {
            Optional time;
            this.scheduleNextLock.lock();
            ZonedDateTime now = ZonedDateTime.now();
            Optional nextExecution = this.executionTime.nextExecution(now);
            if (nextExecution.isEmpty()) {
                return;
            }
            ZonedDateTime next = (ZonedDateTime)nextExecution.get();
            if (this.lastNext != null && this.lastNext.isEqual(next)) {
                this.lastNext = this.executionTime.nextExecution(now).orElse(null);
                time = this.executionTime.timeToNextExecution(next);
            } else {
                this.lastNext = next;
                time = this.executionTime.timeToNextExecution(now);
            }
            time.ifPresent(t -> this.executorService.schedule(this::run, t.toMillis(), TimeUnit.MILLISECONDS));
        }
        finally {
            this.scheduleNextLock.unlock();
        }
    }
}

