/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.processor;

import io.helidon.pico.tools.Options;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

public class UnsupportedConstructsProcessor
extends AbstractProcessor {
    private static final System.Logger LOGGER = System.getLogger(UnsupportedConstructsProcessor.class.getName());
    private static final Set<String> UNSUPPORTED_TARGETS = Set.of("jakarta.annotation.ManagedBean", "jakarta.annotation.Resource", "jakarta.annotation.Resources", "jakarta.enterprise.context.ApplicationScoped", "javax.enterprise.context.ApplicationScoped", "jakarta.enterprise.context.BeforeDestroyed", "jakarta.enterprise.context.ConversationScoped", "jakarta.enterprise.context.Dependent", "jakarta.enterprise.context.Destroyed", "jakarta.enterprise.context.Initialized", "jakarta.enterprise.context.NormalScope", "jakarta.enterprise.context.RequestScoped", "jakarta.enterprise.context.SessionScoped", "jakarta.enterprise.context.control.ActivateRequestContext", "jakarta.enterprise.event.Observes", "jakarta.enterprise.event.ObservesAsync", "jakarta.enterprise.inject.Alternative", "jakarta.enterprise.inject.Disposes", "jakarta.enterprise.inject.Intercepted", "jakarta.enterprise.inject.Model", "jakarta.enterprise.inject.Produces", "jakarta.enterprise.inject.Specializes", "jakarta.enterprise.inject.Stereotype", "jakarta.enterprise.inject.TransientReference", "jakarta.enterprise.inject.Typed", "jakarta.enterprise.inject.Vetoed", "jakarta.enterprise.util.Nonbinding");

    @Deprecated
    public UnsupportedConstructsProcessor() {
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return UNSUPPORTED_TARGETS;
    }

    @Override
    public void init(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
        Options.init((ProcessingEnvironment)processingEnv);
        super.init(processingEnv);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!annotations.isEmpty()) {
            Set annotationTypeNames = annotations.stream().map(Object::toString).collect(Collectors.toSet());
            if (Options.isOptionEnabled((String)"pico.mapApplicationToSingletonScope")) {
                annotationTypeNames.remove("jakarta.enterprise.context.ApplicationScoped");
                annotationTypeNames.remove("javax.enterprise.context.ApplicationScoped");
            }
            if (!annotationTypeNames.isEmpty()) {
                if (Options.isOptionEnabled((String)"pico.ignoreUnsupportedAnnotations")) {
                    String msg = "ignoring unsupported annotations: " + String.valueOf(annotationTypeNames);
                    LOGGER.log(System.Logger.Level.DEBUG, msg);
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, msg);
                    return false;
                }
                String msg = "This module contains unsupported annotations for pico to process: " + String.valueOf(annotationTypeNames) + ".\n";
                if (annotationTypeNames.contains("jakarta.enterprise.context.ApplicationScoped") || annotationTypeNames.contains("javax.enterprise.context.ApplicationScoped")) {
                    msg = msg + "'jakarta.enterprise.context.ApplicationScoped' can be optionally mapped to 'jakarta.inject.Singleton' scope by passing -Apico.mapApplicationToSingletonScope=true.\n";
                }
                msg = msg + "Use -Apico.ignoreUnsupportedAnnotations=true to ignore all unsupported annotations.";
                LOGGER.log(System.Logger.Level.ERROR, msg);
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
            }
        }
        return false;
    }
}

