/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.processor;

import io.helidon.pico.processor.BaseAnnotationProcessor;
import io.helidon.pico.processor.ProcessorUtils;
import io.helidon.pico.tools.ModuleInfoDescriptor;
import io.helidon.pico.tools.ModuleUtils;
import io.helidon.pico.tools.Options;
import io.helidon.pico.tools.ToolsException;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

public class ServiceAnnotationProcessor
extends BaseAnnotationProcessor<Void> {
    private static final Set<String> SUPPORTED_TARGETS = Set.of("jakarta.inject.Singleton", "io.helidon.pico.api.ExternalContracts", "io.helidon.pico.api.Intercepted", "javax.inject.Singleton", "jakarta.enterprise.context.ApplicationScoped", "javax.enterprise.context.ApplicationScoped");

    @Deprecated
    public ServiceAnnotationProcessor() {
    }

    @Override
    protected Set<String> annoTypes() {
        return SUPPORTED_TARGETS;
    }

    @Override
    protected Set<String> contraAnnotations() {
        return Set.of("io.helidon.pico.configdriven.api.ConfiguredBy");
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            if (!roundEnv.processingOver() && this.servicesToProcess().moduleName() == null) {
                AtomicReference<String> typeSuffix = new AtomicReference<String>();
                AtomicReference<File> moduleInfoFile = new AtomicReference<File>();
                AtomicReference<File> srcPath = new AtomicReference<File>();
                ModuleInfoDescriptor thisModuleDescriptor = this.getThisModuleDescriptor(typeSuffix, moduleInfoFile, srcPath);
                if (thisModuleDescriptor != null) {
                    this.servicesToProcess().lastKnownModuleInfoDescriptor(thisModuleDescriptor);
                } else {
                    String thisModuleName = this.getThisModuleName(null);
                    if (thisModuleName == null) {
                        this.servicesToProcess().clearModuleName();
                    } else {
                        this.servicesToProcess().moduleName(thisModuleName);
                    }
                }
                if (typeSuffix.get() != null) {
                    this.servicesToProcess().lastKnownTypeSuffix(typeSuffix.get());
                }
                if (srcPath.get() != null) {
                    this.servicesToProcess().lastKnownSourcePathBeingProcessed(srcPath.get().toPath());
                }
                if (moduleInfoFile.get() != null) {
                    this.servicesToProcess().lastKnownModuleInfoFilePath(moduleInfoFile.get().toPath());
                }
            }
            boolean typeSuffix = super.process(annotations, roundEnv);
            return typeSuffix;
        }
        catch (Throwable t) {
            this.error(this.getClass().getSimpleName() + " error during processing; " + String.valueOf(t) + " @ " + String.valueOf(ProcessorUtils.rootStackTraceElementOf(t)), t);
            throw new ToolsException("Error detected while processing: " + String.valueOf(t) + " @ " + String.valueOf(ProcessorUtils.rootStackTraceElementOf(t)), t);
        }
        finally {
            if (roundEnv.processingOver()) {
                this.servicesToProcess().clearModuleName();
            }
        }
    }

    String getThisModuleName(ModuleInfoDescriptor descriptor) {
        String moduleName = Options.getOption((String)"modulename").orElse(null);
        if (moduleName != null) {
            return moduleName;
        }
        return descriptor == null ? null : descriptor.name();
    }

    ModuleInfoDescriptor getThisModuleDescriptor(AtomicReference<String> typeSuffix, AtomicReference<File> moduleInfoFile, AtomicReference<File> srcPath) {
        return this.tryFindModuleInfo(StandardLocation.SOURCE_OUTPUT, typeSuffix, moduleInfoFile, srcPath).or(() -> this.tryFindModuleInfo(StandardLocation.SOURCE_PATH, typeSuffix, moduleInfoFile, srcPath)).or(() -> this.getThisModuleDescriptorFromSourceMain(moduleInfoFile, srcPath)).orElse(null);
    }

    Optional<ModuleInfoDescriptor> getThisModuleDescriptorFromSourceMain(AtomicReference<File> moduleInfoFile, AtomicReference<File> srcPath) {
        block4: {
            if (srcPath != null && srcPath.get() != null && srcPath.get().getPath().contains("/target/")) {
                String path = srcPath.get().getPath();
                int pos = path.indexOf("/target/");
                File srcRoot = new File(path = path.substring(0, pos), "/src/main/java");
                File file = new File(srcRoot, "module-info.java");
                if (file.exists()) {
                    try {
                        return Optional.of(ModuleInfoDescriptor.create((Path)file.toPath(), (ModuleInfoDescriptor.Ordering)ModuleInfoDescriptor.Ordering.NATURAL_PRESERVE_COMMENTS));
                    }
                    catch (Exception e) {
                        this.debug("unable to read source module-info.java from: " + String.valueOf(srcRoot) + "; " + e.getMessage(), e);
                        if (moduleInfoFile == null) break block4;
                        moduleInfoFile.set(file);
                    }
                }
            }
        }
        this.debug("unable to find module-info.java from: " + String.valueOf(srcPath));
        return Optional.empty();
    }

    Optional<ModuleInfoDescriptor> tryFindModuleInfo(StandardLocation location, AtomicReference<String> typeSuffix, AtomicReference<File> moduleInfoFile, AtomicReference<File> srcPath) {
        Filer filer = this.processingEnv.getFiler();
        try {
            FileObject f = filer.getResource(location, "", "module-info.java");
            URI uri = f.toUri();
            Path filePath = ProcessorUtils.toPath(uri).orElse(null);
            if (filePath != null) {
                Path parent = filePath.getParent();
                if (srcPath != null) {
                    srcPath.set(parent.toFile());
                }
                if (typeSuffix != null) {
                    String type = ModuleUtils.inferSourceOrTest((Path)parent);
                    typeSuffix.set(type);
                }
                if (filePath.toFile().exists()) {
                    if (moduleInfoFile != null) {
                        moduleInfoFile.set(filePath.toFile());
                    }
                    return Optional.of(ModuleInfoDescriptor.create((Path)filePath));
                }
            }
        }
        catch (Exception e) {
            this.debug("unable to retrieve " + String.valueOf(location) + " from filer: " + e.getMessage());
        }
        return Optional.empty();
    }
}

