/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.processor;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

final class ProcessorUtils {
    private ProcessorUtils() {
    }

    static StackTraceElement rootStackTraceElementOf(Throwable t) {
        while (t.getCause() != null && t.getCause() != t) {
            t = t.getCause();
        }
        return t.getStackTrace()[0];
    }

    static String toString(Collection<?> coll) {
        return ProcessorUtils.toString(coll, null, null);
    }

    static <T> String toString(Collection<T> coll, Function<T, String> fnc, String separator) {
        Function<Object, String> fn = fnc == null ? String::valueOf : fnc;
        separator = separator == null ? ", " : separator;
        return coll.stream().map(fn).collect(Collectors.joining(separator));
    }

    static List<String> toList(String str) {
        return ProcessorUtils.toList(str, ",");
    }

    static List<String> toList(String str, String delim) {
        String[] split = str.split(delim);
        return Arrays.stream(split).map(String::trim).collect(Collectors.toList());
    }

    static Optional<Path> toPath(URI uri) {
        if (uri.getHost() != null) {
            return Optional.empty();
        }
        return Optional.of(Paths.get(uri));
    }
}

