/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.processor;

import io.helidon.builder.processor.tools.BuilderTypeTools;
import io.helidon.common.types.TypeName;
import io.helidon.pico.api.ElementInfo;
import io.helidon.pico.processor.BaseAnnotationProcessor;
import io.helidon.pico.tools.ToolsException;
import io.helidon.pico.tools.TypeTools;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;

public class PostConstructPreDestroyAnnotationProcessor
extends BaseAnnotationProcessor<Void> {
    private static final Set<String> SUPPORTED_TARGETS = Set.of("jakarta.annotation.PreDestroy", "jakarta.annotation.PostConstruct", "javax.annotation.PreDestroy", "javax.annotation.PostConstruct");

    @Deprecated
    public PostConstructPreDestroyAnnotationProcessor() {
    }

    @Override
    protected Set<String> annoTypes() {
        return SUPPORTED_TARGETS;
    }

    @Override
    protected Set<String> contraAnnotations() {
        return Set.of("io.helidon.pico.configdriven.api.ConfiguredBy");
    }

    @Override
    void doInner(ExecutableElement method, Void builder) {
        if (method.getKind() == ElementKind.CONSTRUCTOR) {
            throw new ToolsException("Invalid use of PreDestroy/PostConstruct on " + String.valueOf(method.getEnclosingElement()) + "." + String.valueOf(method));
        }
        boolean isStatic = false;
        ElementInfo.Access access = ElementInfo.Access.PACKAGE_PRIVATE;
        Set<Modifier> modifiers = method.getModifiers();
        if (modifiers != null) {
            for (Modifier modifier : modifiers) {
                if (Modifier.PUBLIC == modifier) {
                    access = ElementInfo.Access.PUBLIC;
                    continue;
                }
                if (Modifier.PROTECTED == modifier) {
                    access = ElementInfo.Access.PROTECTED;
                    continue;
                }
                if (Modifier.PRIVATE == modifier) {
                    access = ElementInfo.Access.PRIVATE;
                    continue;
                }
                if (Modifier.STATIC != modifier) continue;
                isStatic = true;
            }
        }
        if (isStatic || ElementInfo.Access.PRIVATE == access) {
            throw new ToolsException("Invalid use of a private and/or static PreDestroy/PostConstruct method on " + String.valueOf(method.getEnclosingElement()) + "." + String.valueOf(method));
        }
        if (!method.getParameters().isEmpty()) {
            throw new ToolsException("Invalid use PreDestroy/PostConstruct method w/ parameters on " + String.valueOf(method.getEnclosingElement()) + "." + String.valueOf(method));
        }
        List<? extends AnnotationMirror> annotations = method.getAnnotationMirrors();
        Optional mirror = BuilderTypeTools.findAnnotationMirror((String)"jakarta.annotation.PreDestroy", annotations);
        if (mirror.isPresent()) {
            this.servicesToProcess().addPreDestroyMethod((TypeName)TypeTools.createTypeNameFromElement((Element)method.getEnclosingElement()).orElseThrow(), method.getSimpleName().toString());
        } else {
            mirror = BuilderTypeTools.findAnnotationMirror((String)"javax.annotation.PreDestroy", annotations);
            if (mirror.isPresent()) {
                this.servicesToProcess().addPreDestroyMethod((TypeName)TypeTools.createTypeNameFromElement((Element)method.getEnclosingElement()).orElseThrow(), method.getSimpleName().toString());
            }
        }
        mirror = BuilderTypeTools.findAnnotationMirror((String)"jakarta.annotation.PostConstruct", annotations);
        if (mirror.isPresent()) {
            this.servicesToProcess().addPostConstructMethod((TypeName)TypeTools.createTypeNameFromElement((Element)method.getEnclosingElement()).orElseThrow(), method.getSimpleName().toString());
        } else {
            mirror = BuilderTypeTools.findAnnotationMirror((String)"javax.annotation.PostConstruct", annotations);
            if (mirror.isPresent()) {
                this.servicesToProcess().addPostConstructMethod((TypeName)TypeTools.createTypeNameFromElement((Element)method.getEnclosingElement()).orElseThrow(), method.getSimpleName().toString());
            }
        }
    }
}

