/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.processor;

import io.helidon.common.types.DefaultTypeName;
import io.helidon.common.types.TypeName;
import io.helidon.pico.api.DependenciesInfo;
import io.helidon.pico.api.DependencyInfo;
import io.helidon.pico.api.ElementInfo;
import io.helidon.pico.processor.BaseAnnotationProcessor;
import io.helidon.pico.runtime.Dependencies;
import io.helidon.pico.tools.ToolsException;
import io.helidon.pico.tools.TypeTools;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

public class InjectAnnotationProcessor
extends BaseAnnotationProcessor<Dependencies.BuilderContinuation> {
    private static final Set<String> SUPPORTED_TARGETS = Set.of("jakarta.inject.Inject", "javax.inject.Inject");

    @Deprecated
    public InjectAnnotationProcessor() {
    }

    @Override
    protected Set<String> annoTypes() {
        return SUPPORTED_TARGETS;
    }

    @Override
    protected Set<String> contraAnnotations() {
        return Set.of("io.helidon.pico.configdriven.api.ConfiguredBy");
    }

    @Override
    int doBulkInner(Set<? extends Element> typesToProcess, TypeName typeName, Dependencies.BuilderContinuation builder) {
        if (typesToProcess.isEmpty()) {
            return 0;
        }
        assert (typeName == null);
        assert (builder == null);
        Set serviceTypeNames = typesToProcess.stream().map(element -> (DefaultTypeName)TypeTools.createTypeNameFromElement((Element)element.getEnclosingElement()).orElseThrow()).collect(Collectors.toSet());
        assert (!serviceTypeNames.isEmpty());
        for (TypeName serviceTypeName : serviceTypeNames) {
            int ctorCount = super.doBulkInner(typesToProcess, serviceTypeName, builder = Dependencies.builder((String)serviceTypeName.name()));
            if (ctorCount > 1) {
                throw new ToolsException("There can be max of 1 injectable constructor for " + String.valueOf(serviceTypeName));
            }
            DependenciesInfo dependencies = builder.build();
            this.servicesToProcess().addDependencies(dependencies);
            this.maybeSetBasicsForServiceType(serviceTypeName, null);
        }
        return 0;
    }

    @Override
    void doInner(String serviceTypeName, VariableElement varType, Dependencies.BuilderContinuation continuation, String elemName, int elemArgs, Integer elemOffset, ElementInfo.ElementKind elemKind, ElementInfo.Access access, Boolean isStaticAlready) {
        boolean isStatic;
        boolean bl = isStatic = isStaticAlready != null && isStaticAlready != false;
        if (access == null) {
            if (varType.getKind() != ElementKind.FIELD) {
                throw new ToolsException("Unsupported element kind " + String.valueOf(varType.getEnclosingElement()) + "." + String.valueOf(varType) + " with " + String.valueOf((Object)varType.getKind()));
            }
            access = TypeTools.toAccess((Element)varType);
            elemKind = ElementInfo.ElementKind.FIELD;
            isStatic = TypeTools.isStatic((Element)varType);
        }
        serviceTypeName = serviceTypeName != null ? serviceTypeName : varType.getEnclosingElement().toString();
        elemName = elemName != null ? elemName : varType.getSimpleName().toString();
        AtomicReference isProvider = new AtomicReference();
        AtomicReference isOptional = new AtomicReference();
        AtomicReference isList = new AtomicReference();
        String varTypeName = TypeTools.extractInjectionPointTypeInfo((Element)varType, isProvider, isList, isOptional);
        Set qualifiers = TypeTools.createQualifierAndValueSet(varType.getAnnotationMirrors());
        assert (elemKind != null && elemName != null);
        continuation = continuation.add(serviceTypeName, elemName, varTypeName, elemKind, elemArgs, access).elemOffset(elemOffset).qualifiers((Collection)qualifiers).providerWrapped(((Boolean)isProvider.get()).booleanValue()).listWrapped(((Boolean)isList.get()).booleanValue()).optionalWrapped(((Boolean)isOptional.get()).booleanValue()).staticDeclaration(isStatic);
        DependencyInfo ipInfo = (DependencyInfo)continuation.commitLastDependency().orElseThrow();
        this.debug("dependency for " + String.valueOf(varType) + " was " + String.valueOf(ipInfo));
    }

    @Override
    void doInner(ExecutableElement method, Dependencies.BuilderContinuation builder) {
        ElementInfo.ElementKind elemKind;
        if (method.getKind() != ElementKind.METHOD && method.getKind() != ElementKind.CONSTRUCTOR) {
            throw new ToolsException("Unsupported element kind " + String.valueOf(method.getEnclosingElement()) + "." + String.valueOf(method) + " with " + String.valueOf((Object)method.getKind()));
        }
        ElementInfo.Access access = TypeTools.toAccess((Element)method);
        boolean isStatic = TypeTools.isStatic((Element)method);
        List<? extends VariableElement> params = method.getParameters();
        if (params.isEmpty() && method.getKind() != ElementKind.CONSTRUCTOR) {
            throw new ToolsException("Unsupported element kind " + String.valueOf(method.getEnclosingElement()) + "." + String.valueOf(method) + " with " + String.valueOf((Object)method.getKind()));
        }
        String serviceTypeName = method.getEnclosingElement().toString();
        String methodTypeName = ElementKind.CONSTRUCTOR == method.getKind() ? "<init>" : method.getSimpleName().toString();
        ElementInfo.ElementKind elementKind = elemKind = ElementKind.CONSTRUCTOR == method.getKind() ? ElementInfo.ElementKind.CONSTRUCTOR : ElementInfo.ElementKind.METHOD;
        if (!params.isEmpty()) {
            int elemOffset = 0;
            for (VariableElement variableElement : params) {
                this.doInner(serviceTypeName, variableElement, builder, methodTypeName, params.size(), (Integer)(++elemOffset), elemKind, access, (Boolean)isStatic);
            }
        }
    }

    @Override
    public void doInner(TypeElement type, Dependencies.BuilderContinuation builder) {
        throw new IllegalStateException();
    }
}

