/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.processor;

import io.helidon.common.types.DefaultTypeName;
import io.helidon.common.types.TypeName;
import io.helidon.pico.processor.MessagerToLogAdapter;
import io.helidon.pico.processor.ProcessorUtils;
import io.helidon.pico.tools.CustomAnnotationTemplateRequest;
import io.helidon.pico.tools.CustomAnnotationTemplateResponse;
import io.helidon.pico.tools.DefaultCustomAnnotationTemplateResponse;
import io.helidon.pico.tools.GenericTemplateCreator;
import io.helidon.pico.tools.GenericTemplateCreatorRequest;
import io.helidon.pico.tools.Messager;
import io.helidon.pico.tools.TemplateHelper;
import io.helidon.pico.tools.ToolsException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

class DefaultGenericTemplateCreator
implements GenericTemplateCreator {
    private final Class<?> generator;
    private final Messager messager;

    DefaultGenericTemplateCreator(Class<?> generator) {
        this(generator, new MessagerToLogAdapter(System.getLogger(DefaultGenericTemplateCreator.class.getName())));
    }

    DefaultGenericTemplateCreator(Class<?> generator, Messager messager) {
        this.generator = Objects.requireNonNull(generator);
        this.messager = messager;
    }

    public Optional<CustomAnnotationTemplateResponse> create(GenericTemplateCreatorRequest req) {
        Objects.requireNonNull(req);
        if (!DefaultTypeName.isFQN((TypeName)req.generatedTypeName())) {
            this.messager.debug("skipping custom template production for: " + String.valueOf(req.generatedTypeName()) + " = " + String.valueOf(req));
            return Optional.empty();
        }
        TemplateHelper templateHelper = TemplateHelper.create();
        Map<String, Object> substitutions = this.gatherSubstitutions(req, templateHelper);
        String javaBody = templateHelper.applySubstitutions(req.template(), substitutions, true);
        return Optional.of(((DefaultCustomAnnotationTemplateResponse.Builder)((DefaultCustomAnnotationTemplateResponse.Builder)DefaultCustomAnnotationTemplateResponse.builder().request(req.customAnnotationTemplateRequest())).addGeneratedSourceCode(req.generatedTypeName(), javaBody)).build());
    }

    CharSequence supplyFromResources(String templateProfile, String templateName) {
        TemplateHelper templateHelper = TemplateHelper.create();
        String template = templateHelper.loadTemplate(templateProfile, templateName);
        if (template == null) {
            ToolsException te = new ToolsException("Unable to find template " + templateProfile + "/" + templateName);
            this.messager.error(te.getMessage(), (Throwable)te);
            throw te;
        }
        return template;
    }

    Map<String, Object> gatherSubstitutions(GenericTemplateCreatorRequest genericRequest, TemplateHelper templateHelper) {
        CustomAnnotationTemplateRequest req = genericRequest.customAnnotationTemplateRequest();
        TypeName generatedTypeName = genericRequest.generatedTypeName();
        HashMap<String, Object> substitutions = new HashMap<String, Object>();
        substitutions.put("generatedSticker", templateHelper.generatedStickerFor(this.generator.getName()));
        substitutions.put("annoTypeName", req.annoTypeName());
        substitutions.put("generatedTypeName", generatedTypeName);
        substitutions.put("packageName", generatedTypeName.packageName());
        substitutions.put("className", generatedTypeName.className());
        substitutions.put("enclosingClassTypeName", req.enclosingTypeInfo().typeName());
        substitutions.put("enclosingAnnotations", req.enclosingTypeInfo().annotations());
        substitutions.put("basicServiceInfo", req.serviceInfo());
        substitutions.put("weight", req.serviceInfo().realizedWeight());
        substitutions.put("runLevel", req.serviceInfo().realizedRunLevel());
        substitutions.put("elementAccess", req.targetElementAccess());
        substitutions.put("elementIsStatic", req.isElementStatic());
        substitutions.put("elementKind", req.targetElement().elementTypeKind());
        substitutions.put("elementName", req.targetElement().elementName());
        substitutions.put("elementAnnotations", req.targetElement().annotations());
        substitutions.put("elementEnclosingTypeName", req.targetElement().typeName());
        substitutions.put("elementArgs", req.targetElementArgs());
        substitutions.put("elementArgs-declaration", ProcessorUtils.toString(req.targetElementArgs()));
        substitutions.putAll(genericRequest.overrideProperties());
        return substitutions;
    }
}

