/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.processor;

import io.helidon.builder.processor.spi.TypeInfoCreatorProvider;
import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.types.DefaultTypeName;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementName;
import io.helidon.pico.api.ServiceInfoBasics;
import io.helidon.pico.processor.BaseAnnotationProcessor;
import io.helidon.pico.processor.DefaultGenericTemplateCreator;
import io.helidon.pico.processor.ProcessorUtils;
import io.helidon.pico.tools.AbstractFilerMessager;
import io.helidon.pico.tools.ActivatorCreatorCodeGen;
import io.helidon.pico.tools.CodeGenFiler;
import io.helidon.pico.tools.CustomAnnotationTemplateRequest;
import io.helidon.pico.tools.CustomAnnotationTemplateResponse;
import io.helidon.pico.tools.DefaultActivatorCreator;
import io.helidon.pico.tools.DefaultCustomAnnotationTemplateRequest;
import io.helidon.pico.tools.DefaultCustomAnnotationTemplateResponse;
import io.helidon.pico.tools.GenericTemplateCreator;
import io.helidon.pico.tools.Messager;
import io.helidon.pico.tools.ServicesToProcess;
import io.helidon.pico.tools.ToolsException;
import io.helidon.pico.tools.TypeTools;
import io.helidon.pico.tools.spi.CustomAnnotationTemplateCreator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

public class CustomAnnotationProcessor
extends BaseAnnotationProcessor<Void> {
    private static final Map<TypeName, Set<CustomAnnotationTemplateCreator>> PRODUCERS_BY_ANNOTATION = new ConcurrentHashMap<TypeName, Set<CustomAnnotationTemplateCreator>>();
    private static final Set<String> ALL_ANNO_TYPES_HANDLED = new CopyOnWriteArraySet<String>();
    private static final List<CustomAnnotationTemplateCreator> PRODUCERS = CustomAnnotationProcessor.initialize();

    @Deprecated
    public CustomAnnotationProcessor() {
    }

    static List<CustomAnnotationTemplateCreator> initialize() {
        List creators = HelidonServiceLoader.create(ServiceLoader.load(CustomAnnotationTemplateCreator.class, CustomAnnotationTemplateCreator.class.getClassLoader())).asList();
        creators.forEach(creator -> {
            try {
                Set annoTypes = creator.annoTypes();
                annoTypes.forEach(annoType -> PRODUCERS_BY_ANNOTATION.compute((TypeName)DefaultTypeName.createFromTypeName((String)annoType), (k, v) -> {
                    if (v == null) {
                        v = new LinkedHashSet<CustomAnnotationTemplateCreator>();
                    }
                    v.add(creator);
                    return v;
                }));
                ALL_ANNO_TYPES_HANDLED.addAll(annoTypes);
            }
            catch (Throwable t) {
                System.Logger logger = System.getLogger(CustomAnnotationProcessor.class.getName());
                ToolsException te = new ToolsException("Failed to initialize: " + String.valueOf(creator), t);
                logger.log(System.Logger.Level.ERROR, te.getMessage(), (Throwable)te);
                throw te;
            }
        });
        return creators;
    }

    @Override
    public void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.logger().log(System.Logger.Level.DEBUG, CustomAnnotationTemplateCreator.class.getSimpleName() + "s: " + String.valueOf(PRODUCERS));
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            if (!roundEnv.processingOver()) {
                for (String annoType : this.annoTypes()) {
                    DefaultTypeName annoName = DefaultTypeName.createFromTypeName((String)annoType);
                    Optional<TypeElement> annoElement = this.toTypeElement((TypeName)annoName);
                    if (annoElement.isEmpty()) continue;
                    Set<? extends Element> typesToProcess = roundEnv.getElementsAnnotatedWith(annoElement.get());
                    this.doInner((TypeName)annoName, typesToProcess, roundEnv);
                }
            }
            return false;
        }
        catch (Throwable t) {
            this.error(this.getClass().getSimpleName() + " error during processing; " + String.valueOf(t) + " @ " + String.valueOf(ProcessorUtils.rootStackTraceElementOf(t)), t);
            throw new ToolsException("Error while processing: " + String.valueOf(t) + " @ " + String.valueOf(ProcessorUtils.rootStackTraceElementOf(t)), t);
        }
    }

    @Override
    protected Set<String> annoTypes() {
        return Set.copyOf(ALL_ANNO_TYPES_HANDLED);
    }

    Set<CustomAnnotationTemplateCreator> producersForType(TypeName annoTypeName) {
        Set<CustomAnnotationTemplateCreator> set = PRODUCERS_BY_ANNOTATION.get(annoTypeName);
        return set == null ? null : Collections.unmodifiableSet(set);
    }

    void doInner(TypeName annoTypeName, Set<? extends Element> typesToProcess, RoundEnvironment roundEnv) {
        if (typesToProcess.isEmpty()) {
            return;
        }
        Set<CustomAnnotationTemplateCreator> producers = this.producersForType(annoTypeName);
        if (producers.isEmpty()) {
            return;
        }
        for (Element element : typesToProcess) {
            try {
                DefaultCustomAnnotationTemplateRequest.Builder req = this.toRequestBuilder(annoTypeName, element, roundEnv, true);
                if (req == null) continue;
                DefaultCustomAnnotationTemplateResponse.Builder res = (DefaultCustomAnnotationTemplateResponse.Builder)DefaultCustomAnnotationTemplateResponse.builder().request((CustomAnnotationTemplateRequest)req);
                for (CustomAnnotationTemplateCreator producer : producers) {
                    req.genericTemplateCreator((GenericTemplateCreator)new DefaultGenericTemplateCreator(producer.getClass(), this));
                    CustomAnnotationTemplateResponse producerResponse = this.process(producer, (CustomAnnotationTemplateRequest)req);
                    if (producerResponse == null) continue;
                    res = CustomAnnotationTemplateResponse.aggregate((CustomAnnotationTemplateRequest)req, (CustomAnnotationTemplateResponse[])new CustomAnnotationTemplateResponse[]{res, producerResponse});
                }
                DefaultCustomAnnotationTemplateResponse response = res.build();
                if (!req.isFilerEnabled()) continue;
                this.doFiler((CustomAnnotationTemplateResponse)response);
            }
            catch (Throwable t) {
                throw new ToolsException("Error detected while processing: " + String.valueOf(typesToProcess) + String.valueOf(t), t);
            }
        }
    }

    void doFiler(CustomAnnotationTemplateResponse response) {
        AbstractFilerMessager filer = AbstractFilerMessager.createAnnotationBasedFiler((ProcessingEnvironment)this.processingEnv, (Messager)this);
        CodeGenFiler codegen = CodeGenFiler.create((AbstractFilerMessager)filer);
        response.generatedSourceCode().forEach((arg_0, arg_1) -> ((CodeGenFiler)codegen).codegenJavaFilerOut(arg_0, arg_1));
        response.generatedResources().forEach((typedElementName, resourceBody) -> {
            String fileType = typedElementName.elementName();
            if (!CustomAnnotationProcessor.hasValue(fileType)) {
                fileType = ".generated";
            }
            codegen.codegenResourceFilerOut(TypeTools.toFilePath((TypeName)typedElementName.typeName(), (String)fileType), resourceBody, Optional.empty());
        });
    }

    CustomAnnotationTemplateResponse process(CustomAnnotationTemplateCreator producer, CustomAnnotationTemplateRequest req) {
        if (producer == null) {
            return null;
        }
        try {
            CustomAnnotationTemplateResponse res = producer.create(req).orElse(null);
            if (res != null && req.isFilerEnabled() && !res.generatedSourceCode().isEmpty()) {
                res.generatedSourceCode().entrySet().forEach(entry -> {
                    DefaultTypeName.ensureIsFQN((TypeName)((TypeName)entry.getKey()));
                    if (!CustomAnnotationProcessor.hasValue((String)entry.getValue())) {
                        throw new ToolsException("expected to have valid code for: " + String.valueOf(req) + " for " + String.valueOf(entry));
                    }
                });
            }
            return res;
        }
        catch (Throwable t) {
            throw new ToolsException("failed in producer: " + String.valueOf(producer) + "; " + String.valueOf(t), t);
        }
    }

    DefaultCustomAnnotationTemplateRequest.Builder toRequestBuilder(TypeName annoTypeName, Element typeToProcess, RoundEnvironment ignoredRoundEnv, boolean wantDefaultMethods) {
        TypeElement enclosingClassType = this.toEnclosingClassTypeElement(typeToProcess);
        TypeName enclosingClassTypeName = TypeTools.createTypeNameFromElement((Element)enclosingClassType).orElse(null);
        if (enclosingClassTypeName == null) {
            return null;
        }
        ServiceInfoBasics siInfo = this.toBasicServiceInfo(enclosingClassTypeName);
        if (siInfo == null) {
            return null;
        }
        TypeInfoCreatorProvider tools = HelidonServiceLoader.create(ServiceLoader.load(TypeInfoCreatorProvider.class, TypeInfoCreatorProvider.class.getClassLoader())).asList().stream().findFirst().orElse(null);
        TypeInfo enclosingClassTypeInfo = (TypeInfo)tools.createTypeInfo(annoTypeName, enclosingClassTypeName, enclosingClassType, this.processingEnv, wantDefaultMethods).orElseThrow();
        Elements elements = this.processingEnv.getElementUtils();
        return (DefaultCustomAnnotationTemplateRequest.Builder)((DefaultCustomAnnotationTemplateRequest.Builder)((DefaultCustomAnnotationTemplateRequest.Builder)((DefaultCustomAnnotationTemplateRequest.Builder)((DefaultCustomAnnotationTemplateRequest.Builder)((DefaultCustomAnnotationTemplateRequest.Builder)((DefaultCustomAnnotationTemplateRequest.Builder)((DefaultCustomAnnotationTemplateRequest.Builder)DefaultCustomAnnotationTemplateRequest.builder().filerEnabled(true)).annoTypeName(annoTypeName)).serviceInfo(siInfo)).targetElement(TypeTools.createTypedElementNameFromElement((Element)typeToProcess, (Elements)elements))).targetElementArgs(this.toArgs(typeToProcess))).targetElementAccess(TypeTools.toAccess((Element)typeToProcess))).elementStatic(TypeTools.isStatic((Element)typeToProcess))).enclosingTypeInfo(enclosingClassTypeInfo);
    }

    ServiceInfoBasics toBasicServiceInfo(TypeName enclosingClassType) {
        ActivatorCreatorCodeGen codeGen = DefaultActivatorCreator.createActivatorCreatorCodeGen((ServicesToProcess)this.servicesToProcess()).orElse(null);
        if (codeGen == null) {
            return null;
        }
        return DefaultActivatorCreator.toServiceInfo((TypeName)enclosingClassType, (ActivatorCreatorCodeGen)codeGen);
    }

    List<TypedElementName> toArgs(Element typeToProcess) {
        if (!(typeToProcess instanceof ExecutableElement)) {
            return List.of();
        }
        Elements elements = this.processingEnv.getElementUtils();
        ArrayList<TypedElementName> result = new ArrayList<TypedElementName>();
        ExecutableElement executableElement = (ExecutableElement)typeToProcess;
        executableElement.getParameters().forEach(v -> result.add(TypeTools.createTypedElementNameFromElement((Element)v, (Elements)elements)));
        return result;
    }

    TypeElement toEnclosingClassTypeElement(Element typeToProcess) {
        while (typeToProcess != null && !(typeToProcess instanceof TypeElement)) {
            typeToProcess = typeToProcess.getEnclosingElement();
        }
        return typeToProcess == null ? null : (TypeElement)typeToProcess;
    }
}

