/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.processor;

import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import io.helidon.builder.processor.tools.BuilderTypeTools;
import io.helidon.common.Weight;
import io.helidon.common.types.AnnotationAndValue;
import io.helidon.common.types.DefaultAnnotationAndValue;
import io.helidon.common.types.DefaultTypeName;
import io.helidon.common.types.TypeName;
import io.helidon.pico.api.Contract;
import io.helidon.pico.api.DefaultServiceInfo;
import io.helidon.pico.api.ElementInfo;
import io.helidon.pico.api.ExternalContracts;
import io.helidon.pico.api.RunLevel;
import io.helidon.pico.api.ServiceInfoBasics;
import io.helidon.pico.processor.ProcessorUtils;
import io.helidon.pico.tools.AbstractFilerMessager;
import io.helidon.pico.tools.AbstractGeneralCreatorRequest;
import io.helidon.pico.tools.ActivatorCreatorCodeGen;
import io.helidon.pico.tools.ActivatorCreatorConfigOptions;
import io.helidon.pico.tools.ActivatorCreatorProvider;
import io.helidon.pico.tools.ActivatorCreatorRequest;
import io.helidon.pico.tools.ActivatorCreatorResponse;
import io.helidon.pico.tools.CodeGenFiler;
import io.helidon.pico.tools.DefaultActivatorCreator;
import io.helidon.pico.tools.DefaultActivatorCreatorConfigOptions;
import io.helidon.pico.tools.DefaultGeneralCreatorRequest;
import io.helidon.pico.tools.GeneralCreatorRequest;
import io.helidon.pico.tools.InterceptorCreatorProvider;
import io.helidon.pico.tools.Messager;
import io.helidon.pico.tools.ModuleUtils;
import io.helidon.pico.tools.Options;
import io.helidon.pico.tools.ServicesToProcess;
import io.helidon.pico.tools.ToolsException;
import io.helidon.pico.tools.TypeTools;
import io.helidon.pico.tools.spi.ActivatorCreator;
import io.helidon.pico.tools.spi.InterceptorCreator;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

abstract class BaseAnnotationProcessor<B>
extends AbstractProcessor
implements Messager {
    static final boolean MAYBE_ANNOTATIONS_CLAIMED_BY_THIS_PROCESSOR = false;
    static final String TARGET_DIR = "/target/";
    static final String SRC_MAIN_JAVA_DIR = "/src/main/java";
    private final System.Logger logger = System.getLogger(this.getClass().getName());
    private final ServicesToProcess services;
    private final InterceptorCreator interceptorCreator;
    private final Map<Path, Path> deferredMoves = new LinkedHashMap<Path, Path>();
    private RoundEnvironment roundEnv;

    @Deprecated
    protected BaseAnnotationProcessor() {
        try {
            this.services = ServicesToProcess.servicesInstance();
            this.interceptorCreator = InterceptorCreatorProvider.instance();
        }
        catch (Throwable t) {
            this.logger().log(System.Logger.Level.ERROR, "failed to initialize: " + t.getMessage(), t);
            throw new ToolsException("Failed to initialize: " + t.getMessage(), t);
        }
    }

    static boolean hasValue(String val) {
        return val != null && !val.isBlank();
    }

    @Override
    public void init(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
        Options.init((ProcessingEnvironment)processingEnv);
        this.debug("*** Processing " + this.getClass().getSimpleName() + " ***");
        super.init(processingEnv);
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return this.annoTypes();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.roundEnv = roundEnv;
        try {
            ServicesToProcess.onBeginProcessing((Messager)this, annotations, (RoundEnvironment)roundEnv);
            if (!roundEnv.processingOver()) {
                for (String annoType : this.annoTypes()) {
                    DefaultTypeName annoName = DefaultTypeName.createFromTypeName((String)annoType);
                    Optional<TypeElement> annoTypeElement = this.toTypeElement((TypeName)annoName);
                    if (!annoTypeElement.isPresent()) continue;
                    Set<Element> typesToProcess = roundEnv.getElementsAnnotatedWith(annoTypeElement.get());
                    Set<String> contraAnnotations = this.contraAnnotations();
                    if (!contraAnnotations.isEmpty()) {
                        typesToProcess = typesToProcess.stream().filter(it -> !this.containsAnyAnnotation((Element)it, contraAnnotations)).collect(Collectors.toSet());
                    }
                    this.doBulkInner(typesToProcess, null, null);
                }
            }
            boolean claimedResult = this.doFiler(roundEnv);
            ServicesToProcess.onEndProcessing((Messager)this, annotations, (RoundEnvironment)roundEnv);
            return claimedResult;
        }
        catch (Throwable t) {
            this.error(this.getClass().getSimpleName() + " error during processing; " + String.valueOf(t) + " @ " + String.valueOf(ProcessorUtils.rootStackTraceElementOf(t)), t);
            throw new ToolsException("Error during processing: " + String.valueOf(t) + " @ " + String.valueOf(ProcessorUtils.rootStackTraceElementOf(t)), t);
        }
    }

    public void debug(String message, Throwable t) {
        if (Options.isOptionEnabled((String)"pico.debug") && this.logger.isLoggable(this.loggerLevel())) {
            this.logger.log(this.loggerLevel(), this.getClass().getSimpleName() + ": Debug: " + message, t);
        }
        if (this.processingEnv != null && this.processingEnv.getMessager() != null) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.OTHER, message);
        }
    }

    public void debug(String message) {
        if (Options.isOptionEnabled((String)"pico.debug") && this.logger.isLoggable(this.loggerLevel())) {
            this.logger.log(this.loggerLevel(), this.getClass().getSimpleName() + ": Debug: " + message);
        }
        if (this.processingEnv != null && this.processingEnv.getMessager() != null) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.OTHER, message);
        }
    }

    public void log(String message) {
        if (this.processingEnv != null && this.processingEnv.getMessager() != null) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, message);
        }
    }

    public void warn(String message, Throwable t) {
        if (Options.isOptionEnabled((String)"pico.debug") && t != null) {
            this.logger.log(System.Logger.Level.WARNING, this.getClass().getSimpleName() + ": Warning: " + message, t);
            t.printStackTrace();
        }
        if (this.processingEnv != null && this.processingEnv.getMessager() != null) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message);
        }
    }

    public void warn(String message) {
        if (Options.isOptionEnabled((String)"pico.debug")) {
            this.logger.log(System.Logger.Level.WARNING, this.getClass().getSimpleName() + ": Warning: " + message);
        }
        if (this.processingEnv != null && this.processingEnv.getMessager() != null) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message);
        }
    }

    public void error(String message, Throwable t) {
        this.logger.log(System.Logger.Level.ERROR, this.getClass().getSimpleName() + ": Error: " + message, t);
        if (this.processingEnv != null && this.processingEnv.getMessager() != null) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message);
        }
    }

    protected abstract Set<String> annoTypes();

    protected Set<String> contraAnnotations() {
        return Set.of();
    }

    ServicesToProcess servicesToProcess() {
        return this.services;
    }

    int doBulkInner(Set<? extends Element> typesToProcess, TypeName serviceTypeName, B builder) {
        int injectedCtorCount = 0;
        try {
            for (Element element : typesToProcess) {
                assert (element != null);
                if (serviceTypeName != null && !element.getEnclosingElement().toString().equals(serviceTypeName.name())) continue;
                if (element instanceof TypeElement) {
                    this.doInner((TypeElement)element, builder);
                    continue;
                }
                if (element instanceof ExecutableElement) {
                    this.doInner((ExecutableElement)element, builder);
                    if (element.getKind() != ElementKind.CONSTRUCTOR) continue;
                    ++injectedCtorCount;
                    continue;
                }
                if (!(element instanceof VariableElement)) continue;
                this.doInner(null, (VariableElement)element, builder, null, 0, null, null, null, null);
            }
        }
        catch (Throwable t) {
            throw new ToolsException("Error detected while processing: " + String.valueOf(typesToProcess) + " for " + String.valueOf(serviceTypeName) + ": " + String.valueOf(t), t);
        }
        return injectedCtorCount;
    }

    void doInner(ExecutableElement method, B builder) {
    }

    void doInner(String serviceTypeName, VariableElement var, B builder, String elemName, int elemArgs, Integer elemOffset, ElementInfo.ElementKind elemKind, ElementInfo.Access access, Boolean isStaticAlready) {
    }

    void doInner(TypeElement type, B builder) {
        BuilderTypeTools.createTypeNameFromElement((Element)type).ifPresent(serviceTypeName -> this.processServiceType((TypeName)serviceTypeName, type));
    }

    protected void processServiceType(TypeName serviceTypeName, TypeElement type) {
        this.maybeSetBasicsForServiceType(serviceTypeName, type);
        this.maybeSetContractsAndModulesForServiceType(serviceTypeName, type);
        this.maybeSetInterceptorPlanForServiceType(serviceTypeName, type);
    }

    void maybeSetInterceptorPlanForServiceType(TypeName serviceTypeName, TypeElement ignoredType) {
        if (this.services.hasVisitedInterceptorPlanFor(serviceTypeName)) {
            return;
        }
        ServiceInfoBasics interceptedServiceInfo = this.toInterceptedServiceInfoFor(serviceTypeName);
        InterceptorCreator.InterceptorProcessor processor = this.interceptorCreator.createInterceptorProcessor(interceptedServiceInfo, this.interceptorCreator, Optional.of(this.processingEnv));
        Set annotationTypeTriggers = processor.allAnnotationTypeTriggers();
        if (annotationTypeTriggers.isEmpty()) {
            this.services.addInterceptorPlanFor(serviceTypeName, Optional.empty());
            return;
        }
        Optional plan = processor.createInterceptorPlan(annotationTypeTriggers);
        if (plan.isEmpty()) {
            this.warn("unable to produce an interception plan for: " + String.valueOf(serviceTypeName));
        }
        this.services.addInterceptorPlanFor(serviceTypeName, plan);
    }

    ServiceInfoBasics toInterceptedServiceInfoFor(TypeName serviceTypeName) {
        return ((DefaultServiceInfo.Builder)((DefaultServiceInfo.Builder)((DefaultServiceInfo.Builder)((DefaultServiceInfo.Builder)DefaultServiceInfo.builder().serviceTypeName(serviceTypeName.name())).declaredWeight(Optional.ofNullable((Double)this.services.weightedPriorities().get(serviceTypeName)))).declaredRunLevel(Optional.ofNullable((Integer)this.services.runLevels().get(serviceTypeName)))).scopeTypeNames((Collection)this.services.scopeTypeNames().getOrDefault(serviceTypeName, Set.of()))).build();
    }

    void maybeSetContractsAndModulesForServiceType(TypeName serviceTypeName, TypeElement type) {
        if (this.services.hasContractsFor(serviceTypeName)) {
            return;
        }
        LinkedHashSet<TypeName> providerForSet = new LinkedHashSet<TypeName>();
        LinkedHashSet<String> externalModuleNamesRequired = new LinkedHashSet<String>();
        Set<TypeName> contracts = this.toContracts(type, providerForSet);
        Set<TypeName> externalContracts = this.toExternalContracts(type, externalModuleNamesRequired);
        this.adjustContractsForExternals(contracts, externalContracts, externalModuleNamesRequired);
        LinkedHashSet<TypeName> allContracts = new LinkedHashSet<TypeName>();
        allContracts.addAll(contracts);
        allContracts.addAll(externalContracts);
        allContracts.addAll(providerForSet);
        this.debug("found contracts " + String.valueOf(allContracts) + " for " + String.valueOf(serviceTypeName));
        for (TypeName contract : allContracts) {
            boolean isExternal = externalContracts.contains(contract);
            this.services.addTypeForContract(serviceTypeName, contract, isExternal);
        }
        if (!providerForSet.isEmpty()) {
            this.services.addProviderFor(serviceTypeName, providerForSet);
        }
        if (!externalModuleNamesRequired.isEmpty()) {
            this.services.addExternalRequiredModules(serviceTypeName, externalModuleNamesRequired);
        }
    }

    void maybeSetBasicsForServiceType(TypeName serviceTypeName, TypeElement type) {
        AnnotationMirror weight;
        Set qualifiers;
        List<String> scopeAnnotations;
        if (this.services.hasHierarchyFor(serviceTypeName)) {
            return;
        }
        this.debug("processing service type basics for " + String.valueOf(serviceTypeName));
        if (type == null && (type = this.processingEnv.getElementUtils().getTypeElement(serviceTypeName.name())) == null) {
            this.warn("expected to find a typeElement for " + String.valueOf(serviceTypeName));
            return;
        }
        TypeElement superTypeElement = TypeTools.toTypeElement((TypeMirror)type.getSuperclass()).orElse(null);
        TypeName parentServiceTypeName = superTypeElement == null ? null : (TypeName)BuilderTypeTools.createTypeNameFromElement((Element)superTypeElement).orElseThrow();
        this.services.addParentServiceType(serviceTypeName, parentServiceTypeName);
        this.services.addAccessLevel(serviceTypeName, TypeTools.toAccess((Element)type));
        this.services.addIsAbstract(serviceTypeName, TypeTools.isAbstract((Element)type));
        this.services.addServiceTypeHierarchy(serviceTypeName, this.toServiceTypeHierarchy(type, true));
        AnnotationMirror runLevel = BuilderTypeTools.findAnnotationMirror((String)RunLevel.class.getName(), type.getAnnotationMirrors()).orElse(null);
        if (runLevel != null) {
            String val = BuilderTypeTools.extractValue((AnnotationMirror)runLevel, (Elements)this.processingEnv.getElementUtils());
            this.services.addDeclaredRunLevel(serviceTypeName, Integer.valueOf(Integer.parseInt(val)));
        }
        if ((scopeAnnotations = this.annotationsWithAnnotationOf(type, "jakarta.inject.Scope")).isEmpty()) {
            scopeAnnotations = this.annotationsWithAnnotationOf(type, "jakarta.enterprise.context.NormalScope");
        }
        scopeAnnotations.forEach(scope -> this.services.addScopeTypeName(serviceTypeName, scope));
        if (Options.isOptionEnabled((String)"pico.mapApplicationToSingletonScope") && (scopeAnnotations.contains("javax.enterprise.context.ApplicationScoped") || scopeAnnotations.contains("jakarta.enterprise.context.ApplicationScoped"))) {
            this.services.addScopeTypeName(serviceTypeName, "jakarta.inject.Singleton");
        }
        if (!(qualifiers = TypeTools.createQualifierAndValueSet((Element)type)).isEmpty()) {
            this.services.addQualifiers(serviceTypeName, qualifiers);
        }
        if ((weight = (AnnotationMirror)BuilderTypeTools.findAnnotationMirror((String)Weight.class.getName(), type.getAnnotationMirrors()).orElse(null)) != null) {
            String val = BuilderTypeTools.extractValue((AnnotationMirror)weight, (Elements)this.processingEnv.getElementUtils());
            this.services.addDeclaredWeight(serviceTypeName, Double.valueOf(Double.parseDouble(val)));
        } else {
            this.processPriority(serviceTypeName, type);
        }
    }

    boolean processPriority(TypeName serviceTypeName, TypeElement type) {
        Optional mirror = BuilderTypeTools.findAnnotationMirror((String)"jakarta.annotation.Priority", type.getAnnotationMirrors());
        if (mirror.isEmpty()) {
            mirror = BuilderTypeTools.findAnnotationMirror((String)"javax.annotation.Priority", type.getAnnotationMirrors());
        }
        if (mirror.isEmpty()) {
            return false;
        }
        String priorityString = (String)BuilderTypeTools.extractValues(((AnnotationMirror)mirror.get()).getElementValues()).get("value");
        if (priorityString == null) {
            return false;
        }
        int priority = Integer.parseInt(priorityString);
        this.services.addDeclaredWeight(serviceTypeName, Double.valueOf(priority));
        return true;
    }

    List<TypeName> toServiceTypeHierarchy(TypeElement type, boolean includeSelf) {
        TypeMirror mirror;
        ArrayList<TypeName> result = new ArrayList<TypeName>();
        if (!includeSelf) {
            mirror = type.getSuperclass();
            type = TypeTools.toTypeElement((TypeMirror)mirror).orElse(null);
        }
        while (type != null) {
            result.add(0, (TypeName)BuilderTypeTools.createTypeNameFromElement((Element)type).orElseThrow());
            mirror = type.getSuperclass();
            type = TypeTools.toTypeElement((TypeMirror)mirror).orElse(null);
        }
        return result;
    }

    void adjustContractsForExternals(Set<TypeName> contracts, Set<TypeName> externalContracts, Set<String> externalModuleNamesRequired) {
        Optional<TypeElement> typeElement;
        AtomicReference<String> externalModuleName = new AtomicReference<String>();
        for (TypeName contract : contracts) {
            typeElement = this.toTypeElement(contract);
            if (!typeElement.isPresent() || this.isInThisModule(typeElement.get(), externalModuleName)) continue;
            this.maybeAddExternalModule(externalModuleName.get(), externalModuleNamesRequired);
            externalContracts.add(contract);
        }
        for (TypeName externalContract : externalContracts) {
            typeElement = this.toTypeElement(externalContract);
            if (!typeElement.isPresent() || !this.isInThisModule(typeElement.get(), externalModuleName)) continue;
            this.warn(String.valueOf(externalContract) + " is actually in this module and therefore should not be labelled as external.", null);
            this.maybeAddExternalModule(externalModuleName.get(), externalModuleNamesRequired);
        }
        contracts.removeAll(externalContracts);
    }

    void maybeAddExternalModule(String externalModuleName, Set<String> externalModuleNamesRequired) {
        if (TypeTools.needToDeclareModuleUsage((String)externalModuleName)) {
            externalModuleNamesRequired.add(externalModuleName);
        }
    }

    boolean isInThisModule(TypeElement type, AtomicReference<String> moduleName) {
        if (this.roundEnv.getRootElements().contains(type)) {
            return true;
        }
        moduleName.set(null);
        try {
            Trees trees = Trees.instance(this.processingEnv);
            TreePath path = trees.getPath(type);
            if (path == null) {
                return false;
            }
            JavaFileObject sourceFile = path.getCompilationUnit().getSourceFile();
            Optional<Path> filePath = ProcessorUtils.toPath(sourceFile.toUri());
            filePath.flatMap(it -> ModuleUtils.toSourcePath((Path)it, (TypeElement)type)).ifPresent(arg_0 -> ((ServicesToProcess)this.services).lastKnownSourcePathBeingProcessed(arg_0));
            return true;
        }
        catch (Throwable t) {
            this.debug("unable to determine if contract is external: " + String.valueOf(type) + "; " + t.getMessage(), t);
            ModuleElement module = this.processingEnv.getElementUtils().getModuleOf(type);
            if (!module.isUnnamed()) {
                String name = module.getQualifiedName().toString();
                moduleName.set(name);
            }
            return false;
        }
    }

    List<String> annotationsWithAnnotationOf(TypeElement type, String annotation) {
        List<String> list = this.annotationsWithAnnotationsOfNoOpposite(type, annotation);
        if (list.isEmpty()) {
            return this.annotationsWithAnnotationsOfNoOpposite(type, TypeTools.oppositeOf((String)annotation));
        }
        return list;
    }

    CodeGenFiler createCodeGenFiler() {
        AbstractFilerMessager filer = AbstractFilerMessager.createAnnotationBasedFiler((ProcessingEnvironment)this.processingEnv, (Messager)this);
        return CodeGenFiler.create((AbstractFilerMessager)filer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doFiler(RoundEnvironment roundEnv) {
        boolean isProcessingOver = roundEnv.processingOver();
        ActivatorCreator creator = ActivatorCreatorProvider.instance();
        CodeGenFiler filer = this.createCodeGenFiler();
        Map interceptionPlanMap = this.services.interceptorPlans();
        if (!interceptionPlanMap.isEmpty()) {
            AbstractGeneralCreatorRequest.Builder req = DefaultGeneralCreatorRequest.builder().filer(filer);
            creator.codegenInterceptors((GeneralCreatorRequest)req, interceptionPlanMap);
            this.services.clearInterceptorPlans();
        }
        if (!isProcessingOver) {
            return false;
        }
        ActivatorCreatorCodeGen codeGen = DefaultActivatorCreator.createActivatorCreatorCodeGen((ServicesToProcess)this.services).orElse(null);
        if (codeGen == null) {
            return false;
        }
        DefaultActivatorCreatorConfigOptions configOptions = ((DefaultActivatorCreatorConfigOptions.Builder)((DefaultActivatorCreatorConfigOptions.Builder)DefaultActivatorCreatorConfigOptions.builder().applicationPreCreated(Options.isOptionEnabled((String)"pico.application.pre.create"))).moduleCreated(isProcessingOver)).build();
        ActivatorCreatorRequest req = DefaultActivatorCreator.createActivatorCreatorRequest((ServicesToProcess)this.services, (ActivatorCreatorCodeGen)codeGen, (ActivatorCreatorConfigOptions)configOptions, (CodeGenFiler)filer, (boolean)false);
        try {
            this.services.lastGeneratedPackageName((String)req.packageName().orElseThrow());
            ActivatorCreatorResponse res = creator.createModuleActivators(req);
            if (!res.success()) {
                throw new ToolsException("error during codegen", (Throwable)res.error().orElse(null));
            }
            this.deferredMoves.putAll(filer.deferredMoves());
        }
        catch (Exception te) {
            Map hierarchy = codeGen.serviceTypeHierarchy();
            if (hierarchy == null) {
                this.warn("expected to have a known service type hierarchy in the context");
            } else {
                this.debug("service type hierarchy is " + String.valueOf(hierarchy));
            }
            ToolsException revisedTe = new ToolsException("Error detected while processing " + String.valueOf(req.serviceTypeNames()), (Throwable)te);
            this.error(revisedTe.getMessage(), (Throwable)revisedTe);
        }
        finally {
            if (isProcessingOver) {
                this.handleDeferredMoves();
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.OTHER, this.getClass().getSimpleName() + ": processing is over - resetting");
                this.services.reset(false);
            }
        }
        return false;
    }

    Set<TypeName> toContracts(TypeElement type, Set<TypeName> providerForSet) {
        LinkedHashSet<TypeName> result = new LinkedHashSet<TypeName>();
        LinkedHashSet<TypeMirror> processed = new LinkedHashSet<TypeMirror>();
        this.gatherContractsToBeProcessed(processed, type);
        for (TypeMirror possibleContract : processed) {
            TypeName gTypeName;
            TypeMirror gType;
            TypeParameterElement tpe;
            TypeElement teContract = TypeTools.toTypeElement((TypeMirror)possibleContract).orElse(null);
            if (teContract == null) continue;
            TypeName parentTe = BuilderTypeTools.createTypeNameFromElement((Element)teContract).orElse(null);
            if (BuilderTypeTools.findAnnotationMirror((String)Contract.class.getName(), teContract.getAnnotationMirrors()).isPresent()) {
                result.add(parentTe);
                continue;
            }
            if (Options.isOptionEnabled((String)"pico.autoAddNonContractInterfaces") && ElementKind.INTERFACE == teContract.getKind()) {
                result.add(parentTe);
            } else if (this.services.serviceTypeNames().contains(parentTe)) {
                result.add(parentTe);
            }
            String potentialProviderClassName = 1 == teContract.getTypeParameters().size() ? teContract.getQualifiedName().toString() : null;
            boolean isProviderType = potentialProviderClassName != null && TypeTools.isProviderType((String)potentialProviderClassName);
            if (!isProviderType || 1 != (tpe = teContract.getTypeParameters().get(0)).getBounds().size() || (gType = ((DeclaredType)possibleContract).getTypeArguments().get(0)) == null || (gTypeName = (TypeName)TypeTools.createTypeNameFromMirror((TypeMirror)gType).orElse(null)) == null) continue;
            TypeName teContractName = (TypeName)BuilderTypeTools.createTypeNameFromElement((Element)teContract).orElseThrow();
            result.add(teContractName);
            if (TypeTools.isProviderType((String)teContractName.name())) {
                result.add((TypeName)DefaultTypeName.createFromTypeName((String)"jakarta.inject.Provider"));
            }
            providerForSet.add(gTypeName);
        }
        if (!result.isEmpty()) {
            this.debug("Contracts for " + String.valueOf(type) + " was " + String.valueOf(result) + " w/ providerSet " + String.valueOf(providerForSet));
        }
        return result;
    }

    void gatherContractsToBeProcessed(Set<TypeMirror> processed, TypeElement typeElement) {
        if (typeElement == null) {
            return;
        }
        typeElement.getInterfaces().forEach(tm -> {
            processed.add((TypeMirror)tm);
            this.gatherContractsToBeProcessed(processed, TypeTools.toTypeElement((TypeMirror)tm).orElse(null));
        });
        this.toServiceTypeHierarchy(typeElement, false).stream().map(te -> this.toTypeElement((TypeName)te).orElseThrow().asType()).forEach(tm -> {
            processed.add((TypeMirror)tm);
            this.gatherContractsToBeProcessed(processed, TypeTools.toTypeElement((TypeMirror)tm).orElse(null));
        });
    }

    Set<TypeName> toExternalContracts(TypeElement type, Set<String> externalModulesRequired) {
        LinkedHashSet<TypeName> result = new LinkedHashSet<TypeName>();
        Stack<TypeMirror> stack = new Stack<TypeMirror>();
        stack.push(type.asType());
        stack.addAll(type.getInterfaces());
        stack.add(type.getSuperclass());
        while (!stack.isEmpty()) {
            TypeMirror gType;
            TypeParameterElement tpe;
            TypeMirror iface = (TypeMirror)stack.pop();
            TypeElement teContract = TypeTools.toTypeElement((TypeMirror)iface).orElse(null);
            if (teContract == null) continue;
            stack.addAll(teContract.getInterfaces());
            stack.add(teContract.getSuperclass());
            AnnotationMirror externalContracts = BuilderTypeTools.findAnnotationMirror((String)ExternalContracts.class.getName(), teContract.getAnnotationMirrors()).orElse(null);
            if (externalContracts != null) {
                Set annotations = TypeTools.createAnnotationAndValueSet((Element)teContract);
                Optional annotation = DefaultAnnotationAndValue.findFirst((String)ExternalContracts.class.getName(), (Collection)annotations);
                List<String> values = annotation.isPresent() && ((AnnotationAndValue)annotation.get()).value().isPresent() ? ProcessorUtils.toList((String)((AnnotationAndValue)annotation.get()).value().get()) : List.of();
                for (String externalContract : values) {
                    result.add((TypeName)DefaultTypeName.createFromTypeName((String)externalContract));
                }
                Map map = BuilderTypeTools.extractValues((AnnotationMirror)externalContracts, (Elements)this.processingEnv.getElementUtils());
                String moduleNames = (String)map.get("moduleNames");
                if (!BaseAnnotationProcessor.hasValue(moduleNames)) continue;
                externalModulesRequired.addAll(Arrays.asList(moduleNames.split(",[ ]*")));
                continue;
            }
            String potentialProviderClassName = 1 == teContract.getTypeParameters().size() ? teContract.getQualifiedName().toString() : null;
            boolean isProviderType = potentialProviderClassName != null && TypeTools.isProviderType((String)potentialProviderClassName);
            if (!isProviderType || 1 != (tpe = teContract.getTypeParameters().get(0)).getBounds().size() || (gType = ((DeclaredType)iface).getTypeArguments().get(0)) == null) continue;
            stack.add(gType);
        }
        if (!result.isEmpty()) {
            this.debug("ExternalContracts for " + String.valueOf(type) + " was " + String.valueOf(result) + " w/ modulesRequired " + String.valueOf(externalModulesRequired));
        }
        return result;
    }

    Optional<TypeElement> toTypeElement(TypeName typeName) {
        return Optional.ofNullable(this.processingEnv.getElementUtils().getTypeElement(typeName.name()));
    }

    System.Logger logger() {
        return this.logger;
    }

    System.Logger.Level loggerLevel() {
        return Options.isOptionEnabled((String)"pico.debug") ? System.Logger.Level.INFO : System.Logger.Level.DEBUG;
    }

    private boolean containsAnyAnnotation(Element element, Set<String> contraAnnotations) {
        List annotationAndValues = TypeTools.createAnnotationAndValueListFromElement((Element)element, (Elements)this.processingEnv.getElementUtils());
        Optional<AnnotationAndValue> annotation = annotationAndValues.stream().filter(it -> contraAnnotations.contains(it.typeName().name())).findFirst();
        return annotation.isPresent();
    }

    private List<String> annotationsWithAnnotationsOfNoOpposite(TypeElement type, String annotation) {
        ArrayList<String> list = new ArrayList<String>();
        type.getAnnotationMirrors().forEach(am -> BuilderTypeTools.findAnnotationMirror((String)annotation, am.getAnnotationType().asElement().getAnnotationMirrors()).ifPresent(it -> list.add(am.getAnnotationType().asElement().toString())));
        return list;
    }

    private void handleDeferredMoves() {
        if (this.logger.isLoggable(System.Logger.Level.INFO) && !this.deferredMoves.isEmpty()) {
            this.logger.log(System.Logger.Level.INFO, "handling deferred moves: " + String.valueOf(this.deferredMoves));
        }
        try {
            for (Map.Entry<Path, Path> e : this.deferredMoves.entrySet()) {
                Files.move(e.getKey(), e.getValue(), new CopyOption[0]);
            }
        }
        catch (IOException e) {
            throw new ToolsException(e.getMessage(), (Throwable)e);
        }
        this.deferredMoves.clear();
    }
}

