/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.spi;

import io.helidon.builder.AttributeVisitor;
import io.helidon.pico.api.InjectionPointInfo;
import io.helidon.pico.api.ServiceProvider;
import io.helidon.pico.spi.InjectionPlan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractInjectionPlan
implements InjectionPlan {
    private static final Map<String, Map<String, Object>> __META_PROPS = Collections.unmodifiableMap(AbstractInjectionPlan.__calcMeta());
    private final ServiceProvider<?> serviceProvider;
    private final InjectionPointInfo injectionPointInfo;
    private final List<ServiceProvider<?>> injectionPointQualifiedServiceProviders;
    private final boolean wasResolved;
    private final Optional<Object> resolved;

    protected AbstractInjectionPlan(Builder<?, ?> b) {
        this.serviceProvider = b.serviceProvider;
        this.injectionPointInfo = b.injectionPointInfo;
        this.injectionPointQualifiedServiceProviders = Collections.unmodifiableList(new ArrayList(b.injectionPointQualifiedServiceProviders));
        this.wasResolved = b.wasResolved;
        this.resolved = b.resolved;
    }

    @Override
    public ServiceProvider<?> serviceProvider() {
        return this.serviceProvider;
    }

    @Override
    public InjectionPointInfo injectionPointInfo() {
        return this.injectionPointInfo;
    }

    @Override
    public List<ServiceProvider<?>> injectionPointQualifiedServiceProviders() {
        return this.injectionPointQualifiedServiceProviders;
    }

    @Override
    public boolean wasResolved() {
        return this.wasResolved;
    }

    @Override
    public Optional<Object> resolved() {
        return this.resolved;
    }

    private static Map<String, Map<String, Object>> __calcMeta() {
        LinkedHashMap<String, Map<String, Object>> metaProps = new LinkedHashMap<String, Map<String, Object>>();
        metaProps.put("__generated", Map.of("version", "1"));
        metaProps.put("serviceProvider", Map.of("__type", ServiceProvider.class, "__componentType", Object.class));
        metaProps.put("injectionPointInfo", Map.of("__type", InjectionPointInfo.class));
        metaProps.put("injectionPointQualifiedServiceProviders", Map.of("__type", List.class, "__componentType", ServiceProvider.class));
        metaProps.put("wasResolved", Map.of("__type", Boolean.TYPE));
        metaProps.put("resolved", Map.of("__type", Optional.class, "__componentType", Object.class));
        return metaProps;
    }

    public static Map<String, Map<String, Object>> __metaAttributes() {
        return __META_PROPS;
    }

    public String toString() {
        return InjectionPlan.class.getSimpleName() + "(" + this.toStringInner() + ")";
    }

    protected String toStringInner() {
        Object result = "";
        result = (String)result + "serviceProvider=" + String.valueOf(this.serviceProvider()) + ", ";
        result = (String)result + "injectionPointInfo=" + String.valueOf(this.injectionPointInfo()) + ", ";
        result = (String)result + "injectionPointQualifiedServiceProviders=" + String.valueOf(this.injectionPointQualifiedServiceProviders()) + ", ";
        result = (String)result + "wasResolved=" + this.wasResolved() + ", ";
        result = (String)result + "resolved=" + String.valueOf(this.resolved());
        return result;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hash(this.serviceProvider(), this.injectionPointInfo(), this.injectionPointQualifiedServiceProviders(), this.wasResolved(), this.resolved());
        return hashCode;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof InjectionPlan)) {
            return false;
        }
        InjectionPlan other = (InjectionPlan)another;
        boolean equals = true;
        equals &= Objects.equals(this.serviceProvider(), other.serviceProvider());
        equals &= Objects.equals(this.injectionPointInfo(), other.injectionPointInfo());
        equals &= Objects.equals(this.injectionPointQualifiedServiceProviders(), other.injectionPointQualifiedServiceProviders());
        equals &= Objects.equals(this.wasResolved(), other.wasResolved());
        return equals &= Objects.equals(this.resolved(), other.resolved());
    }

    public <T> void visitAttributes(AttributeVisitor<T> visitor, T userDefinedCtx) {
        visitor.visit("serviceProvider", () -> this.serviceProvider(), __META_PROPS.get("serviceProvider"), userDefinedCtx, ServiceProvider.class, new Class[]{Object.class});
        visitor.visit("injectionPointInfo", () -> this.injectionPointInfo(), __META_PROPS.get("injectionPointInfo"), userDefinedCtx, InjectionPointInfo.class, new Class[0]);
        visitor.visit("injectionPointQualifiedServiceProviders", () -> this.injectionPointQualifiedServiceProviders(), __META_PROPS.get("injectionPointQualifiedServiceProviders"), userDefinedCtx, List.class, new Class[]{ServiceProvider.class});
        visitor.visit("wasResolved", () -> this.wasResolved(), __META_PROPS.get("wasResolved"), userDefinedCtx, Boolean.TYPE, new Class[0]);
        visitor.visit("resolved", () -> this.resolved(), __META_PROPS.get("resolved"), userDefinedCtx, Optional.class, new Class[]{Object.class});
    }

    public static abstract class Builder<B extends Builder<B, T>, T extends InjectionPlan>
    implements InjectionPlan,
    io.helidon.common.Builder<B, T> {
        protected final List injectionPointQualifiedServiceProviders = new ArrayList();
        private ServiceProvider serviceProvider;
        private InjectionPointInfo injectionPointInfo;
        private boolean wasResolved;
        private Optional resolved = Optional.empty();

        protected Builder() {
        }

        @Override
        public ServiceProvider<?> serviceProvider() {
            return this.serviceProvider;
        }

        @Override
        public InjectionPointInfo injectionPointInfo() {
            return this.injectionPointInfo;
        }

        @Override
        public List<ServiceProvider<?>> injectionPointQualifiedServiceProviders() {
            return this.injectionPointQualifiedServiceProviders;
        }

        @Override
        public boolean wasResolved() {
            return this.wasResolved;
        }

        @Override
        public Optional<Object> resolved() {
            return this.resolved;
        }

        public B serviceProvider(ServiceProvider<?> val) {
            this.serviceProvider = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B injectionPointInfo(InjectionPointInfo val) {
            this.injectionPointInfo = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B injectionPointQualifiedServiceProviders(Collection<ServiceProvider<?>> val) {
            this.injectionPointQualifiedServiceProviders.clear();
            this.injectionPointQualifiedServiceProviders.addAll(Objects.requireNonNull(val));
            return (B)((Builder)this.identity());
        }

        public B addInjectionPointQualifiedServiceProviders(Collection<ServiceProvider<?>> val) {
            this.injectionPointQualifiedServiceProviders.addAll(Objects.requireNonNull(val));
            return (B)((Builder)this.identity());
        }

        public B addInjectionPointQualifiedServiceProvider(ServiceProvider<?> val) {
            Objects.requireNonNull(val);
            this.injectionPointQualifiedServiceProviders.add(val);
            return (B)((Builder)this.identity());
        }

        public B wasResolved(boolean val) {
            this.wasResolved = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B resolved(Optional<Object> val) {
            this.resolved = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B resolved(Object val) {
            Objects.requireNonNull(val);
            return this.resolved(Optional.of(val));
        }

        public B accept(T val) {
            Objects.requireNonNull(val);
            this.__acceptThis(val);
            return (B)((Builder)this.identity());
        }

        private void __acceptThis(T val) {
            Objects.requireNonNull(val);
            this.serviceProvider(val.serviceProvider());
            this.injectionPointInfo(val.injectionPointInfo());
            this.injectionPointQualifiedServiceProviders(val.injectionPointQualifiedServiceProviders());
            this.wasResolved(val.wasResolved());
            this.resolved(val.resolved());
        }

        public <T> void visitAttributes(AttributeVisitor<T> visitor, T userDefinedCtx) {
            visitor.visit("serviceProvider", () -> this.serviceProvider, __META_PROPS.get("serviceProvider"), userDefinedCtx, ServiceProvider.class, new Class[]{Object.class});
            visitor.visit("injectionPointInfo", () -> this.injectionPointInfo, __META_PROPS.get("injectionPointInfo"), userDefinedCtx, InjectionPointInfo.class, new Class[0]);
            visitor.visit("injectionPointQualifiedServiceProviders", () -> this.injectionPointQualifiedServiceProviders, __META_PROPS.get("injectionPointQualifiedServiceProviders"), userDefinedCtx, List.class, new Class[]{ServiceProvider.class});
            visitor.visit("wasResolved", () -> this.wasResolved, __META_PROPS.get("wasResolved"), userDefinedCtx, Boolean.TYPE, new Class[0]);
            visitor.visit("resolved", () -> this.resolved, __META_PROPS.get("resolved"), userDefinedCtx, Optional.class, new Class[]{Object.class});
        }
    }
}

