/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.api;

import io.helidon.pico.api.InjectionPointInfo;
import io.helidon.pico.api.PicoException;
import io.helidon.pico.api.ServiceInfoCriteria;
import io.helidon.pico.api.ServiceProvider;
import java.util.List;
import java.util.Optional;

public interface Services {
    default public <T> ServiceProvider<T> lookup(Class<T> type) {
        return this.lookupFirst(type, true).orElseThrow(() -> new PicoException("There are no service providers for service of type " + type.getName()));
    }

    default public <T> ServiceProvider<T> lookup(Class<T> type, String name) {
        return this.lookupFirst(type, name, true).orElseThrow(() -> new PicoException("There are no service providers for service of type " + type.getName()));
    }

    public <T> Optional<ServiceProvider<T>> lookupFirst(Class<T> var1, boolean var2);

    public <T> Optional<ServiceProvider<T>> lookupFirst(Class<T> var1, String var2, boolean var3);

    default public <T> ServiceProvider<T> lookup(ServiceInfoCriteria criteria) {
        return this.lookupFirst(criteria, true).orElseThrow();
    }

    public <T> Optional<ServiceProvider<T>> lookupFirst(ServiceInfoCriteria var1, boolean var2);

    default public <T> ServiceProvider<T> lookupFirst(ServiceInfoCriteria criteria) {
        return this.lookupFirst(criteria, true).orElseThrow();
    }

    default public <T> ServiceProvider<T> lookupFirst(Class<T> type) {
        return this.lookupFirst(type, true).orElseThrow();
    }

    public <T> List<ServiceProvider<T>> lookupAll(Class<T> var1);

    default public <T> List<ServiceProvider<T>> lookupAll(ServiceInfoCriteria criteria) {
        return this.lookupAll(criteria, false);
    }

    public List<ServiceProvider<?>> lookupAll(ServiceInfoCriteria var1, boolean var2);

    default public Services contextualServices(InjectionPointInfo ctx) {
        return this;
    }
}

