/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.api;

import io.helidon.builder.Builder;
import io.helidon.pico.api.PicoServices;
import io.helidon.pico.api.QualifierAndValue;
import io.helidon.pico.api.ServiceInfo;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@Builder
public interface ServiceInfoCriteria {
    public Optional<String> serviceTypeName();

    public Set<String> scopeTypeNames();

    public Set<QualifierAndValue> qualifiers();

    public Set<String> contractsImplemented();

    public Optional<Integer> runLevel();

    public Optional<Double> weight();

    public Set<String> externalContractsImplemented();

    public Optional<String> activatorTypeName();

    public Optional<String> moduleName();

    public boolean includeIntercepted();

    default public boolean matches(ServiceInfoCriteria criteria) {
        return this.matchesContracts(criteria) && this.scopeTypeNames().containsAll(criteria.scopeTypeNames()) && ServiceInfo.matchesQualifiers(this.qualifiers(), criteria.qualifiers()) && ServiceInfoCriteria.matches(this.activatorTypeName(), criteria.activatorTypeName()) && ServiceInfoCriteria.matches(this.runLevel(), criteria.runLevel()) && ServiceInfoCriteria.matches(this.moduleName(), criteria.moduleName());
    }

    default public boolean matchesContracts(ServiceInfoCriteria criteria) {
        if (criteria == PicoServices.EMPTY_CRITERIA) {
            return true;
        }
        boolean matches = ServiceInfoCriteria.matches(this.serviceTypeName(), criteria.serviceTypeName());
        if (matches && criteria.serviceTypeName().isEmpty()) {
            matches = this.contractsImplemented().containsAll(criteria.contractsImplemented());
        }
        return matches;
    }

    private static boolean matches(Object src, Optional<?> criteria) {
        if (criteria.isEmpty()) {
            return true;
        }
        return Objects.equals(src, criteria.get());
    }
}

