/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.api;

import io.helidon.builder.Builder;
import io.helidon.pico.api.CommonQualifiers;
import io.helidon.pico.api.DefaultServiceInfo;
import io.helidon.pico.api.PicoServices;
import io.helidon.pico.api.QualifierAndValue;
import io.helidon.pico.api.ServiceInfoBasics;
import io.helidon.pico.api.ServiceInfoBuildInterceptor;
import io.helidon.pico.api.ServiceInfoCriteria;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@Builder(interceptor=ServiceInfoBuildInterceptor.class)
public interface ServiceInfo
extends ServiceInfoBasics {
    public Set<String> externalContractsImplemented();

    public Optional<String> activatorTypeName();

    public Optional<String> moduleName();

    default public boolean matches(ServiceInfoCriteria criteria) {
        if (criteria == PicoServices.EMPTY_CRITERIA) {
            return true;
        }
        boolean matches = ServiceInfo.matches(this.serviceTypeName(), criteria.serviceTypeName());
        if (matches && criteria.serviceTypeName().isEmpty()) {
            matches = this.contractsImplemented().containsAll(criteria.contractsImplemented()) || criteria.contractsImplemented().contains(this.serviceTypeName());
        }
        return matches && this.scopeTypeNames().containsAll(criteria.scopeTypeNames()) && ServiceInfo.matchesQualifiers(this.qualifiers(), criteria.qualifiers()) && ServiceInfo.matches(this.activatorTypeName(), criteria.activatorTypeName()) && ServiceInfo.matchesWeight(this, criteria) && ServiceInfo.matches(this.realizedRunLevel(), criteria.runLevel()) && ServiceInfo.matches(this.moduleName(), criteria.moduleName());
    }

    public static boolean matchesQualifiers(Collection<QualifierAndValue> src, Collection<QualifierAndValue> criteria) {
        if (criteria.isEmpty()) {
            return true;
        }
        if (src.isEmpty()) {
            return false;
        }
        if (src.contains(CommonQualifiers.WILDCARD_NAMED)) {
            return true;
        }
        for (QualifierAndValue criteriaQualifier : criteria) {
            if (src.contains(criteriaQualifier)) continue;
            if (criteriaQualifier.typeName().equals((Object)CommonQualifiers.NAMED)) {
                boolean hasSameTypeAsCriteria;
                if (criteriaQualifier.equals(CommonQualifiers.WILDCARD_NAMED) || criteriaQualifier.value().isEmpty() ? (hasSameTypeAsCriteria = src.stream().anyMatch(q -> q.typeName().equals((Object)criteriaQualifier.typeName()))) : src.contains(CommonQualifiers.WILDCARD_NAMED)) continue;
                return false;
            }
            if (criteriaQualifier.value().isEmpty()) {
                Set sameTypeAsCriteriaSet = src.stream().filter(q -> q.typeName().equals((Object)criteriaQualifier.typeName())).collect(Collectors.toSet());
                if (!sameTypeAsCriteriaSet.isEmpty()) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private static boolean matches(Object src, Optional<?> criteria) {
        if (criteria.isEmpty()) {
            return true;
        }
        return Objects.equals(src, criteria.get());
    }

    private static boolean matchesWeight(ServiceInfoBasics src, ServiceInfoCriteria criteria) {
        if (criteria.weight().isEmpty()) {
            return true;
        }
        Double srcWeight = src.realizedWeight();
        return srcWeight.compareTo(criteria.weight().get()) <= 0;
    }

    public static DefaultServiceInfo.Builder toBuilder(ServiceInfoBasics val) {
        if (val instanceof ServiceInfo) {
            return DefaultServiceInfo.toBuilder((ServiceInfo)val);
        }
        DefaultServiceInfo.Builder result = DefaultServiceInfo.builder();
        result.serviceTypeName(val.serviceTypeName());
        result.scopeTypeNames(val.scopeTypeNames());
        result.qualifiers(val.qualifiers());
        result.contractsImplemented(val.contractsImplemented());
        result.declaredRunLevel(val.declaredRunLevel());
        result.declaredWeight(val.declaredWeight());
        return result;
    }
}

