/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.api;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.pico.api.Bootstrap;
import io.helidon.pico.api.CallingContext;
import io.helidon.pico.api.InternalBootstrap;
import io.helidon.pico.api.PicoServices;
import io.helidon.pico.api.Resettable;
import io.helidon.pico.spi.PicoServicesProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;

public abstract class PicoServicesHolder {
    private static final AtomicReference<InternalBootstrap> BOOTSTRAP = new AtomicReference();
    private static final AtomicReference<ProviderAndServicesTuple> INSTANCE = new AtomicReference();

    @Deprecated
    protected PicoServicesHolder() {
    }

    static Optional<PicoServices> picoServices() {
        if (INSTANCE.get() == null) {
            INSTANCE.compareAndSet(null, new ProviderAndServicesTuple(PicoServicesHolder.load()));
            if (PicoServicesHolder.INSTANCE.get().picoServices == null) {
                System.getLogger(PicoServices.class.getName()).log(System.Logger.Level.WARNING, "pico runtime services not detected on the classpath");
            }
        }
        return Optional.ofNullable(PicoServicesHolder.INSTANCE.get().picoServices);
    }

    protected static void reset() {
        ProviderAndServicesTuple instance = INSTANCE.get();
        if (instance != null) {
            instance.reset();
        }
        INSTANCE.set(null);
        BOOTSTRAP.set(null);
    }

    static void bootstrap(Bootstrap bootstrap) {
        Objects.requireNonNull(bootstrap);
        InternalBootstrap iBootstrap = InternalBootstrap.create(bootstrap, null);
        if (!BOOTSTRAP.compareAndSet(null, iBootstrap)) {
            StackTraceElement[] trace;
            InternalBootstrap existing = BOOTSTRAP.get();
            CallingContext callingContext = existing == null ? null : (CallingContext)existing.callingContext().orElse(null);
            StackTraceElement[] stackTraceElementArray = trace = callingContext == null ? new StackTraceElement[]{} : callingContext.trace();
            if (trace != null && trace.length > 0) {
                throw new IllegalStateException("bootstrap was previously set from this code path:\n" + PicoServicesHolder.prettyPrintStackTraceOf(trace) + "; module name is '" + callingContext.moduleName().orElse("undefined") + "'");
            }
            throw new IllegalStateException("The bootstrap has already been set - use the (-D and/or -A) tag 'pico.debug=true' to see full trace output.");
        }
    }

    static Optional<Bootstrap> bootstrap(boolean assignIfNeeded) {
        InternalBootstrap iBootstrap;
        if (assignIfNeeded) {
            iBootstrap = InternalBootstrap.create();
            BOOTSTRAP.compareAndSet(null, iBootstrap);
        }
        return Optional.ofNullable((iBootstrap = BOOTSTRAP.get()) != null ? iBootstrap.bootStrap() : null);
    }

    private static Optional<PicoServicesProvider> load() {
        return HelidonServiceLoader.create(ServiceLoader.load(PicoServicesProvider.class, PicoServicesProvider.class.getClassLoader())).asList().stream().findFirst();
    }

    static List<String> stackTraceOf(StackTraceElement[] trace) {
        ArrayList<String> result = new ArrayList<String>();
        for (StackTraceElement e : trace) {
            result.add(e.toString());
        }
        return result;
    }

    static String prettyPrintStackTraceOf(StackTraceElement[] trace) {
        return String.join((CharSequence)"\n", PicoServicesHolder.stackTraceOf(trace));
    }

    private static class ProviderAndServicesTuple {
        private final PicoServicesProvider provider;
        private final PicoServices picoServices;

        private ProviderAndServicesTuple(Optional<PicoServicesProvider> provider) {
            this.provider = provider.orElse(null);
            this.picoServices = provider.isPresent() ? this.provider.services(PicoServicesHolder.bootstrap(true).orElseThrow()) : null;
        }

        private void reset() {
            if (this.provider instanceof Resettable) {
                ((Resettable)((Object)this.provider)).reset(true);
            } else if (this.picoServices instanceof Resettable) {
                ((Resettable)((Object)this.picoServices)).reset(true);
            }
        }
    }
}

