/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.api;

import io.helidon.builder.Builder;
import io.helidon.common.config.Config;
import io.helidon.pico.api.Bootstrap;
import io.helidon.pico.api.PicoServicesHolder;
import java.util.Optional;
import java.util.function.Supplier;

@Builder
public abstract class PicoServicesConfig {
    public static final String NAME = "pico";
    public static final String FQN = "io.helidon.pico";
    public static final String KEY_PROVIDER_NAME = "provider-name";
    public static final String TAG_DEBUG = "pico.debug";
    public static final String TAG_MODULE_NAME = "modulename";
    public static final String KEY_PROVIDER_VERSION = "provider-version";
    public static final String KEY_ACTIVATION_DEADLOCK_TIMEOUT_IN_MILLIS = "activation-deadlock-timeout-millis";
    public static final String DEFAULT_ACTIVATION_DEADLOCK_TIMEOUT_IN_MILLIS = "10000";
    public static final String KEY_ACTIVATION_LOGS = "activation-logs";
    public static final String DEFAULT_ACTIVATION_LOGS = "false";
    public static final String KEY_SERVICE_LOOKUP_CACHING = "service-lookup-caching";
    public static final String DEFAULT_SERVICE_LOOKUP_CACHING = "false";
    public static final String KEY_PERMITS_DYNAMIC = "permits-dynamic";
    public static final String DEFAULT_PERMITS_DYNAMIC = "false";
    public static final String KEY_SUPPORTS_DYNAMIC = "supports-dynamic";
    public static final String DEFAULT_SUPPORTS_DYNAMIC = "true";
    public static final String KEY_PERMITS_REFLECTION = "permits-reflection";
    public static final String DEFAULT_PERMITS_REFLECTION = "false";
    public static final String KEY_SUPPORTS_REFLECTION = "supports-reflection";
    public static final String DEFAULT_SUPPORTS_REFLECTION = "false";
    public static final String KEY_USES_COMPILE_TIME_APPLICATIONS = "uses-compile-time-applications";
    public static final String DEFAULT_USES_COMPILE_TIME_APPLICATIONS = "true";
    public static final String KEY_USES_COMPILE_TIME_MODULES = "uses-compile-time-modules";
    public static final String DEFAULT_USES_COMPILE_TIME_MODULES = "true";
    public static final String KEY_SUPPORTS_COMPILE_TIME = "supports-compile-time";
    public static final String DEFAULT_SUPPORTS_COMPILE_TIME = "true";
    public static final String KEY_USES_JSR330 = "uses-jsr330";
    public static final String DEFAULT_USES_JSR330 = "false";
    public static final String KEY_SUPPORTS_JSR330 = "supports-jsr330";
    public static final String DEFAULT_SUPPORTS_JSR330 = "true";
    public static final String KEY_SUPPORTS_JSR330_STATICS = "supports-jsr330-statics";
    public static final String DEFAULT_SUPPORTS_JSR330_STATICS = "false";
    public static final String KEY_SUPPORTS_JSR330_PRIVATES = "supports-jsr330-privates";
    public static final String DEFAULT_SUPPORTS_JSR330_PRIVATES = "false";
    public static final String KEY_SUPPORTS_CONTEXTUAL_LOOKUP = "supports-contextual-lookup";
    public static final String DEFAULT_SUPPORTS_CONTEXTUAL_LOOKUP = "false";

    protected PicoServicesConfig() {
    }

    public abstract String providerName();

    public abstract String providerVersion();

    public long activationDeadlockDetectionTimeoutMillis() {
        return PicoServicesConfig.asLong(KEY_ACTIVATION_DEADLOCK_TIMEOUT_IN_MILLIS, () -> Long.valueOf(DEFAULT_ACTIVATION_DEADLOCK_TIMEOUT_IN_MILLIS));
    }

    public boolean activationLogs() {
        return PicoServicesConfig.asBoolean(KEY_ACTIVATION_LOGS, () -> Boolean.valueOf("false"));
    }

    public boolean serviceLookupCaching() {
        return PicoServicesConfig.asBoolean(KEY_SERVICE_LOOKUP_CACHING, () -> Boolean.valueOf("false"));
    }

    public boolean permitsDynamic() {
        return PicoServicesConfig.asBoolean(KEY_PERMITS_DYNAMIC, () -> Boolean.valueOf("false"));
    }

    public abstract boolean supportsDynamic();

    public boolean permitsReflection() {
        return PicoServicesConfig.asBoolean(KEY_PERMITS_REFLECTION, () -> Boolean.valueOf("false"));
    }

    public abstract boolean supportsReflection();

    public boolean usesCompileTimeApplications() {
        return PicoServicesConfig.asBoolean(KEY_USES_COMPILE_TIME_APPLICATIONS, () -> Boolean.valueOf("true"));
    }

    public boolean usesCompileTimeModules() {
        return PicoServicesConfig.asBoolean(KEY_USES_COMPILE_TIME_MODULES, () -> Boolean.valueOf("true"));
    }

    public abstract boolean supportsCompileTime();

    public boolean usesJsr330() {
        return PicoServicesConfig.asBoolean(KEY_USES_JSR330, () -> Boolean.valueOf("false"));
    }

    public abstract boolean supportsJsr330();

    public abstract boolean supportsJsr330Statics();

    public abstract boolean supportsJsr330Privates();

    public abstract boolean supportsContextualLookup();

    static Boolean asBoolean(String key, Supplier<Boolean> defaultValueSupplier) {
        Optional<Config> cfg = PicoServicesConfig.get(key);
        if (cfg.isEmpty() || !cfg.get().hasValue()) {
            return defaultValueSupplier.get();
        }
        return (Boolean)cfg.get().asBoolean().orElseGet(defaultValueSupplier);
    }

    static Long asLong(String key, Supplier<Long> defaultValueSupplier) {
        Optional<Config> cfg = PicoServicesConfig.get(key);
        if (cfg.isEmpty() || !cfg.get().hasValue()) {
            return defaultValueSupplier.get();
        }
        return (Long)cfg.get().asLong().orElseGet(defaultValueSupplier);
    }

    static Optional<Config> get(String key) {
        Optional<Bootstrap> bootstrap = PicoServicesHolder.bootstrap(false);
        if (bootstrap.isEmpty() || bootstrap.get().config().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(bootstrap.get().config().get().get(NAME).get(key));
    }
}

